/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.format;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.format.XMLDiffXFormatter;
import com.topologi.diffx.sequence.PrefixMapping;
import com.topologi.diffx.xml.XMLWriter;
import com.topologi.diffx.xml.XMLWriterNSImpl;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConvenientXMLFormatter
implements XMLDiffXFormatter {
    private final XMLWriter xml;
    private DiffXConfig config = new DiffXConfig();
    private transient boolean writeXMLDeclaration = true;
    private transient boolean isSetup = false;
    private transient short textFormat = 0;
    private transient Stack<AttributeEvent> insAttributes = new Stack();
    private transient Stack<AttributeEvent> delAttributes = new Stack();

    public ConvenientXMLFormatter(Writer w) throws NullPointerException {
        if (w == null) {
            throw new NullPointerException("The XML formatter requires a writer");
        }
        this.xml = new XMLWriterNSImpl(w, false);
    }

    @Override
    public void format(DiffXEvent e) throws IOException {
        if (!this.isSetup) {
            this.setUpXML();
        }
        this.endTextChange();
        if (!(e instanceof AttributeEvent)) {
            this.flushAttributes();
        }
        e.toXML(this.xml);
        if (e instanceof TextEvent && this.config.isIgnoreWhiteSpace() && !this.config.isPreserveWhiteSpace()) {
            this.xml.writeXML(" ");
        }
        this.xml.flush();
    }

    @Override
    public void insert(DiffXEvent e) throws IOException {
        this.change(e, 1);
    }

    @Override
    public void delete(DiffXEvent e) throws IOException {
        this.change(e, -1);
    }

    private void change(DiffXEvent e, int mod) throws IOException {
        if (!this.isSetup) {
            this.setUpXML();
        }
        if (e instanceof OpenElementEvent) {
            this.flushAttributes();
            this.endTextChange();
            e.toXML(this.xml);
            this.xml.attribute("http://www.topologi.com/2005/Diff-X", mod > 0 ? "insert" : "delete", "true");
        } else if (e instanceof CloseElementEvent) {
            this.flushAttributes();
            this.endTextChange();
            this.xml.closeElement();
        } else if (e instanceof TextEvent) {
            this.flushAttributes();
            this.switchTextChange(mod);
            e.toXML(this.xml);
            if (this.config.isIgnoreWhiteSpace() && !this.config.isPreserveWhiteSpace()) {
                this.xml.writeXML(" ");
            }
        } else if (e instanceof AttributeEvent) {
            if (mod > 0) {
                e.toXML(this.xml);
                this.insAttributes.push((AttributeEvent)e);
            } else {
                this.delAttributes.push((AttributeEvent)e);
            }
        } else {
            this.flushAttributes();
            this.endTextChange();
            e.toXML(this.xml);
        }
        this.xml.flush();
    }

    @Override
    public void setConfig(DiffXConfig config) {
        this.config = config;
    }

    @Override
    public void setWriteXMLDeclaration(boolean show) {
        this.writeXMLDeclaration = show;
    }

    @Override
    public void declarePrefixMapping(PrefixMapping mapping) {
        Enumeration<String> uris = mapping.getURIs();
        while (uris.hasMoreElements()) {
            String uri = uris.nextElement();
            this.xml.setPrefixMapping(uri, mapping.getPrefix(uri));
        }
    }

    private void setUpXML() throws IOException {
        if (this.writeXMLDeclaration) {
            this.xml.xmlDecl();
        }
        this.xml.setPrefixMapping("http://www.topologi.com/2005/Diff-X", "dfx");
        this.writeXMLDeclaration = false;
        this.isSetup = true;
    }

    private void endTextChange() throws IOException {
        if (this.textFormat != 0) {
            this.xml.closeElement();
            this.textFormat = 0;
        }
    }

    private void switchTextChange(int mod) throws IOException {
        if (mod > 0) {
            if (this.textFormat < 0) {
                this.xml.closeElement();
            }
            if (this.textFormat <= 0) {
                this.xml.openElement("http://www.topologi.com/2005/Diff-X", "ins", false);
                this.textFormat = 1;
            }
        } else {
            if (this.textFormat > 0) {
                this.xml.closeElement();
            }
            if (this.textFormat >= 0) {
                this.xml.openElement("http://www.topologi.com/2005/Diff-X", "del", false);
                this.textFormat = (short)-1;
            }
        }
    }

    private void flushAttributes() throws IOException {
        this.flushAttributes(this.insAttributes, 1);
        this.flushAttributes(this.delAttributes, -1);
    }

    private void flushAttributes(Stack<AttributeEvent> atts, int mod) throws IOException {
        while (!atts.empty()) {
            AttributeEvent att = atts.pop();
            this.xml.openElement("http://www.topologi.com/2005/Diff-X", mod > 0 ? "ins" : "del", false);
            this.xml.attribute(att.getURI(), att.getName(), att.getValue());
            this.xml.closeElement();
        }
    }
}

