/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fonts.CustomFontCollection;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontEventAdapter;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontInfoConfigurator;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.base14.Base14FontCollection;
import org.apache.fop.render.AbstractRendererConfigurator;
import org.apache.fop.render.DefaultFontResolver;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererConfigurator;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintRendererConfigurator
extends AbstractRendererConfigurator
implements RendererConfigurator,
IFDocumentHandlerConfigurator {
    protected static final Log log = LogFactory.getLog(PrintRendererConfigurator.class);

    public PrintRendererConfigurator(FOUserAgent userAgent) {
        super(userAgent);
    }

    @Override
    public void configure(Renderer renderer) throws FOPException {
        Configuration cfg = this.getRendererConfig(renderer);
        if (cfg == null) {
            log.trace("no configuration found for " + renderer);
            return;
        }
        PrintRenderer printRenderer = (PrintRenderer)renderer;
        FontResolver fontResolver = printRenderer.getFontResolver();
        FontEventAdapter listener = new FontEventAdapter(renderer.getUserAgent().getEventBroadcaster());
        List<EmbedFontInfo> embedFontInfoList = this.buildFontList(cfg, fontResolver, listener);
        printRenderer.addFontList(embedFontInfoList);
    }

    protected List<EmbedFontInfo> buildFontList(Configuration cfg, FontResolver fontResolver, FontEventListener listener) throws FOPException {
        FopFactory factory = this.userAgent.getFactory();
        FontManager fontManager = factory.getFontManager();
        if (fontResolver == null) {
            fontResolver = FontManager.createMinimalFontResolver(this.userAgent.isComplexScriptFeaturesEnabled());
        }
        boolean strict = factory.validateUserConfigStrictly();
        FontInfoConfigurator fontInfoConfigurator = new FontInfoConfigurator(cfg, fontManager, fontResolver, listener, strict);
        ArrayList<EmbedFontInfo> fontInfoList = new ArrayList<EmbedFontInfo>();
        fontInfoConfigurator.configure(fontInfoList);
        return fontInfoList;
    }

    @Override
    public void configure(IFDocumentHandler documentHandler) throws FOPException {
    }

    @Override
    public void setupFontInfo(IFDocumentHandler documentHandler, FontInfo fontInfo) throws FOPException {
        FontManager fontManager = this.userAgent.getFactory().getFontManager();
        ArrayList<FontCollection> fontCollections = new ArrayList<FontCollection>();
        fontCollections.add(new Base14FontCollection(fontManager.isBase14KerningEnabled()));
        Configuration cfg = super.getRendererConfig(documentHandler.getMimeType());
        if (cfg != null) {
            DefaultFontResolver fontResolver = new DefaultFontResolver(this.userAgent);
            FontEventAdapter listener = new FontEventAdapter(this.userAgent.getEventBroadcaster());
            List<EmbedFontInfo> fontList = this.buildFontList(cfg, fontResolver, listener);
            fontCollections.add(new CustomFontCollection(fontResolver, fontList, this.userAgent.isComplexScriptFeaturesEnabled()));
        }
        fontManager.setup(fontInfo, fontCollections.toArray(new FontCollection[fontCollections.size()]));
        documentHandler.setFontInfo(fontInfo);
    }
}

