/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.docx4j.Docx4J;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.HTMLSettings;
import org.docx4j.convert.out.html.AbstractHtmlExporter;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HtmlExporterNG2
extends AbstractHtmlExporter {
    protected static final int DEFAULT_OUTPUT_SIZE = 102400;
    protected static Logger log = LoggerFactory.getLogger(HtmlExporterNG2.class);
    WordprocessingMLPackage wmlPackage;
    HTMLSettings htmlSettings;
    static Templates xslt;

    public void setWmlPackage(WordprocessingMLPackage wmlPackage) {
        this.wmlPackage = wmlPackage;
    }

    public void setHtmlSettings(HTMLSettings htmlSettings) {
        this.htmlSettings = htmlSettings;
    }

    public static void setXslt(Templates xslt) {
        HtmlExporterNG2.xslt = xslt;
    }

    public void output(Result result) throws Docx4JException {
        if (this.wmlPackage == null) {
            throw new Docx4JException("Must setWmlPackage");
        }
        if (this.htmlSettings == null) {
            log.debug("Using empty HtmlSettings");
            this.htmlSettings = new HTMLSettings();
        }
        try {
            this.html(this.wmlPackage, result, this.htmlSettings);
        }
        catch (Exception e) {
            throw new Docx4JException("Failed to create HTML output", e);
        }
    }

    public void html(WordprocessingMLPackage wmlPackage, Result result, HTMLSettings htmlSettings) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(102400);
        Transformer transformer = null;
        if (xslt != null && htmlSettings.getCustomXsltTemplates() == null) {
            htmlSettings.setCustomXsltTemplates(xslt);
        }
        if (wmlPackage != null && htmlSettings.getWmlPackage() == null) {
            htmlSettings.setWmlPackage(wmlPackage);
        }
        Docx4J.toHTML(htmlSettings, outStream, 1);
        try {
            transformer = XmlUtils.getTransformerFactory().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new Docx4JException("Exception creating identity transformer to output result: " + e.getMessage(), e);
        }
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            DocumentBuilder db = dbFactory.newDocumentBuilder();
            db.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            Document doc = null;
            if (log.isDebugEnabled()) {
                byte[] bytes = outStream.toByteArray();
                log.debug(new String(bytes));
                doc = db.parse(new ByteArrayInputStream(bytes));
            } else {
                doc = db.parse(new ByteArrayInputStream(outStream.toByteArray()));
            }
            transformer.transform(new DOMSource(doc.getDocumentElement()), result);
        }
        catch (TransformerException e) {
            throw new Docx4JException("Exception dumping outputstream to output result: " + e.getMessage(), e);
        }
    }
}

