/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.fonts.fop.fonts.Typeface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlyphCheck {
    protected static Logger log = LoggerFactory.getLogger(GlyphCheck.class);
    private static LoadingCache<PhysicalFont, Typeface> cache = CacheBuilder.newBuilder().maximumSize(1000L).build(new CacheLoader<PhysicalFont, Typeface>(){

        @Override
        public Typeface load(PhysicalFont key) {
            return key.getTypeface();
        }
    });

    public static boolean hasChar(PhysicalFont physicalFont, char c) throws ExecutionException {
        boolean exists = cache.get(physicalFont).hasChar(c);
        if (log.isWarnEnabled() && !exists) {
            log.warn("Glyph " + c + " (0x" + Integer.toHexString(c) + ") not available in font " + physicalFont.name);
        }
        return exists;
    }

    public static boolean hasChar(String fontName, char c) throws ExecutionException {
        PhysicalFont pf = PhysicalFonts.get(fontName);
        if (pf == null) {
            log.error("Couldn't get font " + fontName);
            return false;
        }
        return GlyphCheck.hasChar(pf, c);
    }
}

