/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.flatOpcXml.FlatOpcXmlCreator;
import org.docx4j.docProps.core.CoreProperties;
import org.docx4j.docProps.core.dc.elements.ObjectFactory;
import org.docx4j.docProps.extended.Properties;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.openpackaging.URIHelper;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.XmlPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.xmlPackage.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@Deprecated
public class SaveToZipFile {
    private static Logger log = LoggerFactory.getLogger(SaveToZipFile.class);
    public OpcPackage p;
    private HashMap<String, String> handled;

    public SaveToZipFile(OpcPackage p) {
        this.p = p;
    }

    public boolean save(String filepath) throws Docx4JException {
        log.info("SAVING to " + filepath);
        try {
            if (filepath.toLowerCase().endsWith(".xml")) {
                return this.saveFlatOPC(new FileOutputStream(filepath));
            }
            return this.save(new FileOutputStream(filepath));
        }
        catch (FileNotFoundException e) {
            throw new Docx4JException("Failed to save package to path " + filepath, e);
        }
    }

    public boolean save(File docxFile) throws Docx4JException {
        log.info("Saving to" + docxFile.getPath());
        try {
            if (docxFile.getPath().toLowerCase().endsWith(".xml")) {
                return this.saveFlatOPC(new FileOutputStream(docxFile));
            }
            return this.save(new FileOutputStream(docxFile));
        }
        catch (FileNotFoundException e) {
            throw new Docx4JException("Failed to save package to path " + docxFile.getPath(), e);
        }
    }

    public boolean saveFlatOPC(OutputStream realOS) throws Docx4JException {
        try {
            FlatOpcXmlCreator worker = new FlatOpcXmlCreator(this.p);
            Package pkg = worker.get();
            JAXBContext jc = Context.jcXmlPackage;
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
            marshaller.marshal((Object)pkg, realOS);
            return true;
        }
        catch (Exception e) {
            throw new Docx4JException("Failed to save Flat OPC ", e);
        }
    }

    public boolean save(OutputStream realOS) throws Docx4JException {
        this.handled = new HashMap();
        try {
            ZipOutputStream out = new ZipOutputStream(realOS);
            ContentTypeManager ctm = this.p.getContentTypeManager();
            out.putNextEntry(new ZipEntry("[Content_Types].xml"));
            ctm.marshal(out);
            out.closeEntry();
            String partName = "_rels/.rels";
            RelationshipsPart rp = this.p.getRelationshipsPart();
            this.saveRawXmlPart(out, rp, partName);
            this.addPartsFromRelationships(out, rp);
            out.close();
            realOS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof Docx4JException) {
                throw (Docx4JException)e;
            }
            throw new Docx4JException("Failed to save package", e);
        }
        log.info("...Done!");
        return true;
    }

    public void saveRawXmlPart(ZipOutputStream out, Part part) throws Docx4JException {
        String partName = part.getPartName().getName().substring(1);
        this.saveRawXmlPart(out, part, partName);
    }

    public void saveRawXmlPart(ZipOutputStream out, Part part, String zipEntryName) throws Docx4JException {
        try {
            if (part instanceof JaxbXmlPart) {
                boolean appWrite;
                Object cp;
                boolean dcWrite;
                if (part instanceof DocPropsCorePart && (dcWrite = Boolean.parseBoolean(Docx4jProperties.getProperties().getProperty("docx4j.dc.write", "false")))) {
                    cp = (CoreProperties)((DocPropsCorePart)part).getJaxbElement();
                    String creator = Docx4jProperties.getProperties().getProperty("docx4j.dc.creator.value", "docx4j");
                    if (((CoreProperties)cp).getCreator() == null) {
                        ObjectFactory of = new ObjectFactory();
                        ((CoreProperties)cp).setCreator(of.createSimpleLiteral());
                        ((CoreProperties)cp).getCreator().getContent().add(creator);
                    }
                    String modifier = Docx4jProperties.getProperties().getProperty("docx4j.dc.lastModifiedBy.value", "docx4j");
                    ((CoreProperties)cp).setLastModifiedBy(modifier);
                }
                if (part instanceof DocPropsExtendedPart && (appWrite = Boolean.parseBoolean(Docx4jProperties.getProperties().getProperty("docx4j.App.write", "false")))) {
                    cp = (Properties)((DocPropsExtendedPart)part).getJaxbElement();
                    ((Properties)cp).setApplication(Docx4jProperties.getProperties().getProperty("docx4j.Application", "docx4j"));
                    String version = Docx4jProperties.getProperties().getProperty("docx4j.AppVersion");
                    if (version != null) {
                        ((Properties)cp).setAppVersion(version);
                    }
                }
                out.putNextEntry(new ZipEntry(zipEntryName));
                ((JaxbXmlPart)part).marshal(out);
                out.closeEntry();
                log.info("success writing part: " + zipEntryName);
            } else if (part instanceof CustomXmlDataStoragePart) {
                out.putNextEntry(new ZipEntry(zipEntryName));
                ((CustomXmlDataStoragePart)part).getData().writeDocument(out);
                out.closeEntry();
                log.info("success writing part: " + zipEntryName);
            } else if (part instanceof XmlPart) {
                out.putNextEntry(new ZipEntry(zipEntryName));
                Document doc = ((XmlPart)part).getDocument();
                DOMSource source = new DOMSource(doc);
                XmlUtils.getTransformerFactory().newTransformer().transform(source, new StreamResult(out));
                out.closeEntry();
                log.info("success writing part: " + zipEntryName);
            } else {
                log.error("PROBLEM - No suitable part found for: " + zipEntryName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
            throw new Docx4JException("Problem saving part " + zipEntryName, e);
        }
    }

    public void addPartsFromRelationships(ZipOutputStream out, RelationshipsPart rp) throws Docx4JException {
        for (Relationship r : rp.getRelationships().getRelationship()) {
            log.debug("For Relationship Id=" + r.getId() + " Source is " + rp.getSourceP().getPartName() + ", Target is " + r.getTarget());
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink")) continue;
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
                log.warn("Encountered external resource " + r.getTarget() + " of type " + r.getType());
                continue;
            }
            try {
                String resolvedPartUri = URIHelper.resolvePartUri(rp.getSourceURI(), new URI(r.getTarget())).toString();
                resolvedPartUri = resolvedPartUri.substring(1);
                log.debug("Getting part /" + resolvedPartUri);
                Part part = rp.getPart(r);
                if (part == null) {
                    log.error("Part " + resolvedPartUri + " not found!");
                } else {
                    log.debug(part.getClass().getName());
                }
                if (part.getPackage() == null) {
                    log.warn("Packae is not set on Part " + resolvedPartUri);
                } else if (!part.getPackage().equals(this.p)) {
                    log.warn("Part " + resolvedPartUri + " is attached to some other package");
                }
                this.savePart(out, part);
            }
            catch (Exception e) {
                throw new Docx4JException("Failed to add parts from relationships of " + rp.getSourceP().getPartName(), e);
            }
        }
    }

    public void savePart(ZipOutputStream out, Part part) throws Docx4JException, IOException {
        String resolvedPartUri = part.getPartName().getName().substring(1);
        if (this.handled.get(resolvedPartUri) != null) {
            log.debug(".. duplicate save avoided ..");
            return;
        }
        if (part instanceof BinaryPart) {
            log.debug(".. saving binary stuff");
            this.saveRawBinaryPart(out, part);
        } else {
            log.debug(".. saving ");
            this.saveRawXmlPart(out, part);
        }
        this.handled.put(resolvedPartUri, resolvedPartUri);
        RelationshipsPart rrp = part.getRelationshipsPart(false);
        if (rrp != null && rrp.getRelationships().getRelationship().size() > 0) {
            String relPart = PartName.getRelationshipsPartName(resolvedPartUri);
            this.saveRawXmlPart(out, rrp, relPart);
            this.addPartsFromRelationships(out, rrp);
        }
    }

    protected void saveRawBinaryPart(ZipOutputStream out, Part part) throws Docx4JException {
        String resolvedPartUri = part.getPartName().getName().substring(1);
        try {
            out.putNextEntry(new ZipEntry(resolvedPartUri));
            out.write(((BinaryPart)part).getBytes());
            out.closeEntry();
        }
        catch (Exception e) {
            throw new Docx4JException("Failed to put binary part", e);
        }
        log.info("success writing part: " + resolvedPartUri);
    }
}

