/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx;

import java.util.LinkedHashSet;
import java.util.List;
import org.camunda.bpm.dmn.xlsx.BaseAdapter;
import org.camunda.bpm.dmn.xlsx.InputOutputColumns;
import org.camunda.bpm.dmn.xlsx.api.Spreadsheet;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetCell;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetRow;
import org.camunda.bpm.dmn.xlsx.elements.HeaderValuesContainer;
import org.camunda.bpm.model.dmn.HitPolicy;

public class AdvancedSpreadsheetAdapter
extends BaseAdapter {
    @Override
    public InputOutputColumns determineInputOutputs(Spreadsheet context) {
        HeaderValuesContainer hvc;
        LinkedHashSet<String> inputColumns = new LinkedHashSet<String>();
        LinkedHashSet<String> outputColumns = new LinkedHashSet<String>();
        SpreadsheetRow headerRow = context.getRows().get(0);
        List<SpreadsheetCell> cells = headerRow.getCells();
        for (SpreadsheetCell indexedCell : cells) {
            if ("input".equalsIgnoreCase(context.resolveCellContent(indexedCell))) {
                inputColumns.add(indexedCell.getColumn());
            }
            if (!"output".equalsIgnoreCase(context.resolveCellContent(indexedCell))) continue;
            outputColumns.add(indexedCell.getColumn());
        }
        InputOutputColumns columns = new InputOutputColumns();
        int idCounter = 0;
        for (String column : inputColumns) {
            hvc = new HeaderValuesContainer();
            hvc.setId("input" + ++idCounter);
            this.fillHvc(context, column, hvc);
            columns.addInputHeader(hvc);
        }
        idCounter = 0;
        for (String column : outputColumns) {
            hvc = new HeaderValuesContainer();
            hvc.setId("output" + ++idCounter);
            this.fillHvc(context, column, hvc);
            columns.addOutputHeader(hvc);
        }
        return columns;
    }

    @Override
    public HitPolicy determineHitPolicy(Spreadsheet context) {
        if (context.getRows().size() < 4) {
            return null;
        }
        SpreadsheetRow row = context.getRows().get(4);
        if (row.getCell("A") != null) {
            String hitPolicyString = context.resolveCellContent(row.getCell("A")).toUpperCase();
            return HitPolicy.valueOf(hitPolicyString);
        }
        return null;
    }

    @Override
    public List<SpreadsheetRow> determineRuleRows(Spreadsheet context) {
        List<SpreadsheetRow> rows = context.getRows();
        return rows.subList(5, rows.size());
    }

    private void fillHvc(Spreadsheet context, String column, HeaderValuesContainer hvc) {
        SpreadsheetCell cell = context.getRows().get(1).getCell(column);
        hvc.setLabel(context.resolveCellContent(cell));
        cell = context.getRows().get(2).getCell(column);
        hvc.setExpressionLanguage(context.resolveCellContent(cell));
        cell = context.getRows().get(3).getCell(column);
        hvc.setText(context.resolveCellContent(cell));
        cell = context.getRows().get(4).getCell(column);
        hvc.setTypeRef(context.resolveCellContent(cell));
        hvc.setColumn(column);
    }

    public int numberHeaderRows() {
        return 5;
    }
}

