/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx;

import java.util.List;
import org.camunda.bpm.dmn.xlsx.CellContentHandler;
import org.camunda.bpm.dmn.xlsx.DmnConversionContext;
import org.camunda.bpm.dmn.xlsx.DmnValueNumberConverter;
import org.camunda.bpm.dmn.xlsx.DmnValueRangeConverter;
import org.camunda.bpm.dmn.xlsx.DmnValueStringConverter;
import org.camunda.bpm.dmn.xlsx.FeelSimpleUnaryTestConverter;
import org.camunda.bpm.dmn.xlsx.InputOutputColumns;
import org.camunda.bpm.dmn.xlsx.XlsxWorksheetContext;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetAdapter;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetCell;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetRow;
import org.camunda.bpm.dmn.xlsx.elements.HeaderValuesContainer;
import org.camunda.bpm.dmn.xlsx.elements.IndexedDmnColumns;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.HitPolicy;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.Definitions;
import org.camunda.bpm.model.dmn.instance.Description;
import org.camunda.bpm.model.dmn.instance.DmnElement;
import org.camunda.bpm.model.dmn.instance.Input;
import org.camunda.bpm.model.dmn.instance.InputEntry;
import org.camunda.bpm.model.dmn.instance.InputExpression;
import org.camunda.bpm.model.dmn.instance.NamedElement;
import org.camunda.bpm.model.dmn.instance.Output;
import org.camunda.bpm.model.dmn.instance.OutputEntry;
import org.camunda.bpm.model.dmn.instance.Rule;
import org.camunda.bpm.model.dmn.instance.Text;

public class XlsxWorksheetConverter {
    protected XlsxWorksheetContext worksheetContext;
    protected DmnConversionContext dmnConversionContext;
    protected SpreadsheetAdapter spreadsheetAdapter;

    public XlsxWorksheetConverter(XlsxWorksheetContext worksheetContext, SpreadsheetAdapter spreadsheetAdapter) {
        this.worksheetContext = worksheetContext;
        this.dmnConversionContext = new DmnConversionContext(worksheetContext, spreadsheetAdapter.getCellContentHandlers(worksheetContext));
        this.spreadsheetAdapter = spreadsheetAdapter;
    }

    public DmnModelInstance convert() {
        DmnModelInstance dmnModel = this.initializeEmptyDmnModel();
        Decision decision = this.generateElement(dmnModel, Decision.class, this.worksheetContext.getName());
        decision.setName(this.spreadsheetAdapter.determineDecisionName(this.worksheetContext));
        dmnModel.getDefinitions().addChildElement(decision);
        DecisionTable decisionTable = this.generateElement(dmnModel, DecisionTable.class, "decisionTable");
        decision.addChildElement(decisionTable);
        this.setHitPolicy(decisionTable);
        this.convertInputsOutputs(dmnModel, decisionTable);
        this.convertRules(dmnModel, decisionTable, this.spreadsheetAdapter.determineRuleRows(this.worksheetContext));
        return dmnModel;
    }

    protected void setHitPolicy(DecisionTable decisionTable) {
        HitPolicy hitPolicy = this.spreadsheetAdapter.determineHitPolicy(this.worksheetContext);
        if (hitPolicy != null) {
            decisionTable.setHitPolicy(hitPolicy);
        }
    }

    protected void convertInputsOutputs(DmnModelInstance dmnModel, DecisionTable decisionTable) {
        InputOutputColumns inputOutputColumns = this.spreadsheetAdapter.determineInputOutputs(this.worksheetContext);
        for (HeaderValuesContainer hvc : inputOutputColumns.getInputHeaders()) {
            Input input = this.generateElement(dmnModel, Input.class, hvc.getId());
            decisionTable.addChildElement(input);
            InputExpression inputExpression = this.generateElement(dmnModel, InputExpression.class);
            Text text = this.generateText(dmnModel, hvc.getText());
            inputExpression.setText(text);
            input.setInputExpression(inputExpression);
            if (hvc.getLabel() != null) {
                input.setLabel(hvc.getLabel());
            }
            if (hvc.getTypeRef() != null) {
                inputExpression.setTypeRef(hvc.getTypeRef());
            }
            if (hvc.getExpressionLanguage() != null) {
                inputExpression.setExpressionLanguage(hvc.getExpressionLanguage());
            }
            this.dmnConversionContext.getIndexedDmnColumns().addInput(hvc.getColumn(), input);
        }
        for (HeaderValuesContainer hvc : inputOutputColumns.getOutputHeaders()) {
            Output output = this.generateElement(dmnModel, Output.class, hvc.getId());
            decisionTable.addChildElement(output);
            output.setName(hvc.getText());
            if (hvc.getLabel() != null) {
                output.setLabel(hvc.getLabel());
            }
            if (hvc.getTypeRef() != null) {
                output.setTypeRef(hvc.getTypeRef());
            }
            this.dmnConversionContext.getIndexedDmnColumns().addOutput(hvc.getColumn(), output);
        }
    }

    protected void convertRules(DmnModelInstance dmnModel, DecisionTable decisionTable, List<SpreadsheetRow> rulesRows) {
        for (SpreadsheetRow rule : rulesRows) {
            this.convertRule(dmnModel, decisionTable, rule);
        }
    }

    protected void convertRule(DmnModelInstance dmnModel, DecisionTable decisionTable, SpreadsheetRow ruleRow) {
        Text text;
        String textValue;
        String coordinate;
        SpreadsheetCell cell;
        String xlsxColumn;
        Rule rule = this.generateElement(dmnModel, Rule.class, "excelRow" + ruleRow.getRaw().getR());
        decisionTable.addChildElement(rule);
        IndexedDmnColumns dmnColumns = this.dmnConversionContext.getIndexedDmnColumns();
        for (Input input : dmnColumns.getOrderedInputs()) {
            xlsxColumn = dmnColumns.getSpreadsheetColumn(input);
            cell = ruleRow.getCell(xlsxColumn);
            coordinate = xlsxColumn + ruleRow.getRaw().getR();
            InputEntry inputEntry = this.generateElement(dmnModel, InputEntry.class, coordinate);
            textValue = cell != null ? this.dmnConversionContext.resolveCellValue(cell) : this.getDefaultCellContent();
            text = this.generateText(dmnModel, textValue);
            inputEntry.setText(text);
            rule.addChildElement(inputEntry);
        }
        for (Output output : dmnColumns.getOrderedOutputs()) {
            xlsxColumn = dmnColumns.getSpreadsheetColumn(output);
            cell = ruleRow.getCell(xlsxColumn);
            coordinate = xlsxColumn + ruleRow.getRaw().getR();
            OutputEntry outputEntry = this.generateElement(dmnModel, OutputEntry.class, coordinate);
            textValue = cell != null ? this.dmnConversionContext.resolveCellValue(cell) : this.getDefaultCellContent();
            text = this.generateText(dmnModel, textValue);
            outputEntry.setText(text);
            rule.addChildElement(outputEntry);
        }
        SpreadsheetCell annotationCell = ruleRow.getCells().get(ruleRow.getCells().size() - 1);
        Description description = this.generateDescription(dmnModel, this.worksheetContext.resolveCellContent(annotationCell));
        rule.setDescription(description);
    }

    protected String getDefaultCellContent() {
        return "-";
    }

    protected DmnModelInstance initializeEmptyDmnModel() {
        DmnModelInstance dmnModel = Dmn.createEmptyModel();
        Definitions definitions = this.generateNamedElement(dmnModel, Definitions.class, "definitions");
        definitions.setNamespace("http://camunda.org/schema/1.0/dmn");
        dmnModel.setDefinitions(definitions);
        return dmnModel;
    }

    public <E extends NamedElement> E generateNamedElement(DmnModelInstance modelInstance, Class<E> elementClass, String name) {
        NamedElement element = (NamedElement)this.generateElement(modelInstance, elementClass, name);
        element.setName(name);
        return (E)element;
    }

    public <E extends DmnElement> E generateElement(DmnModelInstance modelInstance, Class<E> elementClass, String id) {
        DmnElement element = (DmnElement)modelInstance.newInstance(elementClass);
        element.setId(id);
        return (E)element;
    }

    public <E extends DmnElement> E generateElement(DmnModelInstance modelInstance, Class<E> elementClass) {
        String generatedId = elementClass.getSimpleName() + Integer.toString((int)(2.147483647E9 * Math.random()));
        return this.generateElement(modelInstance, elementClass, generatedId);
    }

    protected Text generateText(DmnModelInstance dmnModel, String content) {
        Text text = dmnModel.newInstance(Text.class);
        text.setTextContent(content);
        return text;
    }

    protected Description generateDescription(DmnModelInstance dmnModel, String content) {
        Description description = dmnModel.newInstance(Description.class);
        description.setTextContent(content);
        return description;
    }

    static {
        CellContentHandler.DEFAULT_HANDLERS.add(new DmnValueRangeConverter());
        CellContentHandler.DEFAULT_HANDLERS.add(new FeelSimpleUnaryTestConverter());
        CellContentHandler.DEFAULT_HANDLERS.add(new DmnValueStringConverter());
        CellContentHandler.DEFAULT_HANDLERS.add(new DmnValueNumberConverter());
    }
}

