/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common;

import java.io.OutputStream;
import org.docx4j.convert.out.AbstractConversionSettings;
import org.docx4j.convert.out.common.AbstractConversionContext;
import org.docx4j.convert.out.common.ConversionSectionWrappers;
import org.docx4j.convert.out.common.Exporter;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExporter<CS extends AbstractConversionSettings, CC extends AbstractConversionContext, PK extends OpcPackage>
implements Exporter<CS> {
    protected static Logger LocalLog = LoggerFactory.getLogger(AbstractExporter.class);

    protected AbstractExporter() {
    }

    @Override
    public void export(CS conversionSettings, OutputStream outputStream) throws Docx4JException {
        long startTime;
        PK preprocessedPackage = null;
        ConversionSectionWrappers sectionWrappers = null;
        AbstractConversionContext conversionContext = null;
        OutputStream intermediateOutputStream = null;
        long currentTime = startTime = System.currentTimeMillis();
        Logger log = LocalLog;
        try {
            FontTablePart ftp;
            log.debug("Start conversion");
            preprocessedPackage = this.preprocess(conversionSettings);
            if (preprocessedPackage instanceof WordprocessingMLPackage) {
                log.debug("Results of preprocess: " + ((WordprocessingMLPackage)preprocessedPackage).getMainDocumentPart().getXML());
            }
            currentTime = this.logDebugStep(log, "Preprocessing", currentTime);
            sectionWrappers = this.createWrappers(conversionSettings, preprocessedPackage);
            currentTime = this.logDebugStep(log, "Create section wrappers", currentTime);
            conversionContext = (AbstractConversionContext)this.createContext(conversionSettings, preprocessedPackage, sectionWrappers);
            currentTime = this.logDebugStep(log, "Create conversion context", currentTime);
            intermediateOutputStream = this.createIntermediateOutputStream(outputStream);
            this.process(conversionSettings, conversionContext, intermediateOutputStream);
            currentTime = this.logDebugStep(log, "Processing", currentTime);
            this.postprocess(conversionSettings, conversionContext, intermediateOutputStream, outputStream);
            currentTime = this.logDebugStep(log, "Postprocessing", currentTime);
            if (((AbstractConversionSettings)conversionSettings).getWmlPackage() != preprocessedPackage && preprocessedPackage instanceof WordprocessingMLPackage && (ftp = ((WordprocessingMLPackage)preprocessedPackage).getMainDocumentPart().getFontTablePart()) != null) {
                ftp.deleteEmbeddedFontTempFiles();
            }
            this.logDebugStep(log, "Conversion done", startTime);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("Only non-null Positions with an index can be checked")) {
                throw new Docx4JException("Exception exporting package; FOP https://issues.apache.org/bugzilla/show_bug.cgi?id=54094 .. try PP_APACHEFOP_DISABLE_PAGEBREAK_LIST_ITEM", e);
            }
            throw new Docx4JException("Exception exporting package", e);
        }
        catch (Exception e) {
            log.error("Exception exporting package", e);
            throw new Docx4JException("Exception exporting package", e);
        }
    }

    protected long logDebugStep(Logger log, String stepLabel, long startTime) {
        long currentTime = 0L;
        if (log.isDebugEnabled()) {
            currentTime = System.currentTimeMillis();
            log.debug(stepLabel + ", " + Long.toString(currentTime - startTime) + "ms");
        }
        return currentTime;
    }

    protected abstract PK preprocess(CS var1) throws Docx4JException;

    protected abstract ConversionSectionWrappers createWrappers(CS var1, PK var2) throws Docx4JException;

    protected abstract CC createContext(CS var1, PK var2, ConversionSectionWrappers var3);

    protected OutputStream createIntermediateOutputStream(OutputStream outputStream) throws Docx4JException {
        return outputStream;
    }

    protected abstract void process(CS var1, CC var2, OutputStream var3) throws Docx4JException;

    protected void postprocess(CS conversionSettings, AbstractConversionContext conversionContext, OutputStream intermediateOutputStream, OutputStream outputStream) throws Docx4JException {
    }
}

