/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.jaxb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import org.docx4j.jaxb.NamespacePrefixMapper;
import org.docx4j.jaxb.NamespacePrefixMapperInterface;
import org.docx4j.jaxb.NamespacePrefixMapperRelationshipsPart;
import org.docx4j.jaxb.NamespacePrefixMappings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class NamespacePrefixMapperUtils {
    private static Logger log = LoggerFactory.getLogger(NamespacePrefixMapperUtils.class);
    private static JAXBContext testContext;
    private static Object prefixMapper;
    private static Object prefixMapperRels;
    private static boolean haveTried;
    private static final String[] EMPTY_STRING;

    public static boolean isJava9orLater() {
        return System.getProperty("java.version").startsWith("9") || System.getProperty("java.version").startsWith("10");
    }

    public static Object getPrefixMapper() throws JAXBException {
        if (prefixMapper != null) {
            return prefixMapper;
        }
        if (haveTried) {
            return null;
        }
        haveTried = true;
        if (testContext == null) {
            ClassLoader classLoader = NamespacePrefixMapperUtils.class.getClassLoader();
            testContext = JAXBContext.newInstance((String)"org.docx4j.relationships", (ClassLoader)classLoader);
        }
        if (testContext == null) {
            throw new JAXBException("Couldn't create context for org.docx4j.relationships.  Everything is broken!");
        }
        Marshaller m = testContext.createMarshaller();
        if (NamespacePrefixMapperUtils.isJava9orLater()) {
            return NamespacePrefixMapperUtils.tryUsingRI(m);
        }
        if (System.getProperty("java.vendor").contains("Android")) {
            log.info("Android .. assuming RI.");
            return NamespacePrefixMapperUtils.tryUsingRI(m);
        }
        try {
            Class<?> c = Class.forName("org.docx4j.jaxb.NamespacePrefixMapperSunInternal");
            m.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", c.newInstance());
            log.info("Using NamespacePrefixMapperSunInternal, which is suitable for Java 6");
            prefixMapper = c.newInstance();
            return prefixMapper;
        }
        catch (NoClassDefFoundError notJava6) {
            log.warn(notJava6.getMessage() + " .. trying RI.");
            return NamespacePrefixMapperUtils.tryUsingRI(m);
        }
        catch (PropertyException notJava6) {
            log.warn(notJava6.getMessage() + " .. trying RI.");
            return NamespacePrefixMapperUtils.tryUsingRI(m);
        }
        catch (ClassNotFoundException notJava6) {
            log.warn(notJava6.getMessage() + " .. trying RI.");
            return NamespacePrefixMapperUtils.tryUsingRI(m);
        }
        catch (InstantiationException notJava6) {
            log.warn(notJava6.getMessage() + " .. trying RI.");
            return NamespacePrefixMapperUtils.tryUsingRI(m);
        }
        catch (IllegalAccessException notJava6) {
            log.warn(notJava6.getMessage() + " .. trying RI.");
            return NamespacePrefixMapperUtils.tryUsingRI(m);
        }
    }

    private static Object tryUsingRI(Marshaller m) throws JAXBException {
        try {
            m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapper());
            log.info("Using NamespacePrefixMapper, which is suitable for the JAXB RI");
            prefixMapper = new NamespacePrefixMapper();
            return prefixMapper;
        }
        catch (NoClassDefFoundError notRIEither) {
            notRIEither.printStackTrace();
            log.error("JAXB: neither Reference Implementation nor Java 6 implementation present?", notRIEither);
            throw new JAXBException("JAXB: neither Reference Implementation nor Java 6 implementation present?");
        }
        catch (PropertyException notRIEither) {
            notRIEither.printStackTrace();
            log.error("JAXB: neither Reference Implementation nor Java 6 implementation present?", notRIEither);
            throw new JAXBException("JAXB: neither Reference Implementation nor Java 6 implementation present?");
        }
    }

    public static Object getPrefixMapperRelationshipsPart() throws JAXBException {
        if (prefixMapperRels != null) {
            return prefixMapperRels;
        }
        if (testContext == null) {
            ClassLoader classLoader = NamespacePrefixMapperUtils.class.getClassLoader();
            testContext = JAXBContext.newInstance((String)"org.docx4j.relationships", (ClassLoader)classLoader);
        }
        Marshaller m = testContext.createMarshaller();
        if (NamespacePrefixMapperUtils.isJava9orLater()) {
            return NamespacePrefixMapperUtils.tryUsingRI(m);
        }
        try {
            Class<?> c = Class.forName("org.docx4j.jaxb.NamespacePrefixMapperRelationshipsPartSunInternal");
            m.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", c.newInstance());
            log.info("Using NamespacePrefixMapperRelationshipsPartSunInternal, which is suitable for Java 6");
            prefixMapperRels = c.newInstance();
            return prefixMapperRels;
        }
        catch (NoClassDefFoundError notJava6) {
            log.warn(notJava6.getMessage() + " .. trying RI.");
            return NamespacePrefixMapperUtils.tryRIforRelationshipsPart(m);
        }
        catch (PropertyException notJava6) {
            log.warn(notJava6.getMessage() + " .. trying RI.");
            return NamespacePrefixMapperUtils.tryRIforRelationshipsPart(m);
        }
        catch (ClassNotFoundException notJava6) {
            log.warn(notJava6.getMessage() + " .. trying RI.");
            return NamespacePrefixMapperUtils.tryRIforRelationshipsPart(m);
        }
        catch (InstantiationException notJava6) {
            log.warn(notJava6.getMessage() + " .. trying RI.");
            return NamespacePrefixMapperUtils.tryRIforRelationshipsPart(m);
        }
        catch (IllegalAccessException notJava6) {
            log.warn(notJava6.getMessage() + " .. trying RI.");
            return NamespacePrefixMapperUtils.tryRIforRelationshipsPart(m);
        }
    }

    private static Object tryRIforRelationshipsPart(Marshaller m) throws JAXBException {
        try {
            m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperRelationshipsPart());
            log.info("Using NamespacePrefixMapperRelationshipsPart, which is suitable for the JAXB RI");
            prefixMapperRels = new NamespacePrefixMapperRelationshipsPart();
            return prefixMapperRels;
        }
        catch (NoClassDefFoundError notRIEither) {
            notRIEither.printStackTrace();
            log.error("JAXB: neither Reference Implementation nor Java 6 implementation present?", notRIEither);
            throw new JAXBException("JAXB: neither Reference Implementation nor Java 6 implementation present?");
        }
        catch (PropertyException notRIEither) {
            notRIEither.printStackTrace();
            log.error("JAXB: neither Reference Implementation nor Java 6 implementation present?", notRIEither);
            throw new JAXBException("JAXB: neither Reference Implementation nor Java 6 implementation present?");
        }
    }

    public static void setProperty(Marshaller marshaller, Object namespacePrefixMapper) throws JAXBException {
        log.debug("attempting to setProperty on marshaller " + marshaller.getClass().getName());
        try {
            if (namespacePrefixMapper.getClass().getName().equals("org.docx4j.jaxb.NamespacePrefixMapper") || namespacePrefixMapper.getClass().getName().equals("org.docx4j.jaxb.NamespacePrefixMapperRelationshipsPart")) {
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", namespacePrefixMapper);
                log.debug("setProperty: com.sun.xml.bind.namespacePrefixMapper");
            } else {
                log.debug("attempting to setProperty: com.sun.xml.INTERNAL.bind.namespacePrefixMapper");
                marshaller.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", namespacePrefixMapper);
            }
        }
        catch (PropertyException e) {
            log.error("Couldn't setProperty on marshaller " + marshaller.getClass().getName());
            log.error(e.getMessage(), e);
            throw e;
        }
    }

    public static String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) throws JAXBException {
        NamespacePrefixMapperInterface namespacePrefixMapper = (NamespacePrefixMapperInterface)NamespacePrefixMapperUtils.getPrefixMapper();
        return namespacePrefixMapper.getPreferredPrefix(namespaceUri, suggestion, requirePrefix);
    }

    public static String[] getPreDeclaredNamespaceUris(String mcIgnorable) {
        if (mcIgnorable == null) {
            return EMPTY_STRING;
        }
        HashSet<String> entries = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(mcIgnorable, " ");
        while (st.hasMoreTokens()) {
            String prefix = st.nextToken();
            String uri = NamespacePrefixMappings.getNamespaceURIStatic(prefix);
            if (uri == null) {
                log.warn("No mapping for prefix '" + prefix + "'");
                continue;
            }
            entries.add(uri);
        }
        return entries.toArray(new String[entries.size()]);
    }

    public static Map<String, String> getPreDeclaredNamespaceMap(String mcIgnorable) {
        HashMap<String, String> entries = new HashMap<String, String>();
        if (mcIgnorable == null) {
            return entries;
        }
        StringTokenizer st = new StringTokenizer(mcIgnorable, " ");
        while (st.hasMoreTokens()) {
            String prefix = st.nextToken();
            String uri = NamespacePrefixMappings.getNamespaceURIStatic(prefix);
            if (uri == null) {
                log.warn("No mapping for prefix '" + prefix + "'");
                continue;
            }
            entries.put(prefix, uri);
        }
        return entries;
    }

    public static void declareNamespaces(String mcIgnorable, Document doc) {
        if (mcIgnorable == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(mcIgnorable, " ");
        while (st.hasMoreTokens()) {
            String prefix = st.nextToken();
            String uri = NamespacePrefixMappings.getNamespaceURIStatic(prefix);
            if (uri == null) {
                log.warn("No mapping for prefix '" + prefix + "'");
                continue;
            }
            doc.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
        }
    }

    static {
        haveTried = false;
        EMPTY_STRING = new String[0];
    }
}

