/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.docx4j.model.datastorage.xpathtracker.Histgram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomToXPathMap {
    private static Logger log = LoggerFactory.getLogger(DomToXPathMap.class);
    private final Stack<Histgram> histgrams = new Stack();
    private Document document;
    private Map<String, String> pathMap = null;
    private Map<String, Integer> countMap = null;
    public static final String PREFIX_ALL_NODES = "_all_";

    public Map<String, String> getPathMap() {
        return this.pathMap;
    }

    public Map<String, Integer> getCountMap() {
        return this.countMap;
    }

    public DomToXPathMap(Document document) {
        this.document = document;
    }

    public void map() {
        this.histgrams.clear();
        this.histgrams.push(new Histgram());
        this.pathMap = new HashMap<String, String>();
        this.countMap = new HashMap<String, Integer>();
        this.walkTree(this.document);
    }

    private String getLocalName(Node sourceNode) {
        if (sourceNode.getLocalName() == null) {
            return sourceNode.getNodeName();
        }
        return sourceNode.getLocalName();
    }

    public void walkTree(Node sourceNode) {
        switch (sourceNode.getNodeType()) {
            case 9: 
            case 11: {
                NodeList nodes = sourceNode.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    log.debug("child " + i + "of DOCUMENT_NODE");
                    this.walkTree(nodes.item(i));
                }
                break;
            }
            case 1: {
                try {
                    this.histgrams.peek().update(sourceNode.getNamespaceURI(), this.getLocalName(sourceNode), sourceNode.getNodeName());
                    this.histgrams.push(new Histgram());
                }
                catch (IllegalArgumentException iae) {
                    log.error(sourceNode.getClass().getName());
                    log.error("sourceNode.getNodeName(): " + sourceNode.getNodeName());
                    log.error("sourceNode.getNamespaceURI(): " + sourceNode.getNamespaceURI());
                    log.error("sourceNode.getLocalName(): " + sourceNode.getLocalName());
                    log.error("sourceNode.getPrefix(): " + sourceNode.getPrefix());
                    log.error("java.vendor=" + System.getProperty("java.vendor"));
                    log.error("java.version=" + System.getProperty("java.version"));
                    throw iae;
                }
                String nxpath = this.getXPath();
                NodeList children = sourceNode.getChildNodes();
                int childrenLength = children.getLength();
                if (children == null || childrenLength == 0) {
                    this.pathMap.put(nxpath, "");
                    this.countMap.put(nxpath, 0);
                } else {
                    String childName = null;
                    boolean singleChild = true;
                    int actualCount = 0;
                    int countOtherElements = 0;
                    int countTextNodes = 0;
                    for (int i = 0; i < childrenLength; ++i) {
                        if (children.item(i).getNodeType() == 3) {
                            ++countTextNodes;
                        } else if (children.item(i).getNodeType() == 1) {
                            if (childName == null) {
                                childName = this.getLocalName(children.item(i));
                            }
                            if (this.getLocalName(children.item(i)).equals(childName)) {
                                ++actualCount;
                            } else {
                                singleChild = false;
                                ++countOtherElements;
                            }
                        }
                        this.walkTree(children.item(i));
                    }
                    if (singleChild) {
                        this.countMap.put(nxpath, actualCount);
                    } else {
                        this.countMap.put(PREFIX_ALL_NODES + nxpath, actualCount + countOtherElements + countTextNodes);
                    }
                }
                this.histgrams.pop();
                break;
            }
            case 3: {
                String xpath = this.getXPath();
                String existing = this.pathMap.get(xpath);
                if (existing == null) {
                    this.pathMap.put(xpath, sourceNode.getNodeValue());
                    break;
                }
                this.pathMap.put(xpath, existing + sourceNode.getNodeValue());
            }
        }
    }

    public String getXPath() {
        StringBuilder buf = new StringBuilder();
        for (Histgram h : this.histgrams) {
            h.appendPath(buf);
        }
        return buf.toString();
    }
}

