/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.docx4j.model.fields.DateFormatInferencer;
import org.docx4j.model.fields.FieldFormattingException;
import org.docx4j.model.fields.FldSimpleModel;
import org.docx4j.model.fields.NumberExtractor;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.NumberFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormattingSwitchHelper {
    private static Logger log = LoggerFactory.getLogger(FormattingSwitchHelper.class);
    protected static final ThreadLocal<Map<String, SimpleDateFormat>> DATE_FORMATS = new ThreadLocal<Map<String, SimpleDateFormat>>(){

        @Override
        protected Map<String, SimpleDateFormat> initialValue() {
            HashMap<String, SimpleDateFormat> hashMap = new HashMap<String, SimpleDateFormat>();
            hashMap.put(null, (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance());
            return hashMap;
        }
    };
    protected static final String DEFAULT_FORMAT_PAGE_TO_FO = "1";
    protected static final String NONE_STRING = new String();
    protected static final Map<String, String> FORMAT_PAGE_TO_FO = new HashMap<String, String>();
    public static final int DECORATION_NONE = 0;
    public static final int DECORATION_DASH = 1;
    protected static final String MERGEFORMAT = "MERGEFORMAT";
    protected static final String FO_PAGENUMBER_DECIMAL = "1";
    protected static final String FO_PAGENUMBER_LOWERALPHA = "a";
    protected static final String FO_PAGENUMBER_UPPERALPHA = "A";
    protected static final String FO_PAGENUMBER_LOWERROMAN = "i";
    protected static final String FO_PAGENUMBER_UPPERROMAN = "I";
    protected static final Map<String, String> DATE_FORMAT_ITEMS_TO_JAVA = new HashMap<String, String>();

    public static String applyFormattingSwitch(WordprocessingMLPackage wmlPackage, FldSimpleModel model, String value) throws Docx4JException {
        return FormattingSwitchHelper.applyFormattingSwitch(wmlPackage, model, value, null);
    }

    public static String applyFormattingSwitch(WordprocessingMLPackage wmlPackage, FldSimpleModel model, String value, String lang) throws Docx4JException {
        String gFormat;
        String nFormat;
        Date date = null;
        try {
            String dtFormat = FormattingSwitchHelper.findFirstSwitchValue("\\@", model.getFldParameters(), true);
            if (dtFormat != null) {
                if (dtFormat.equals("")) {
                    return "Error! Switch argument not specified.";
                }
                log.debug("Applying date format " + dtFormat + " to " + value);
                date = FormattingSwitchHelper.getDate(model, value);
                if (model.fldName.equals("=")) {
                    date = new Date();
                }
                value = FormattingSwitchHelper.formatDate(model, dtFormat, date, lang);
            }
        }
        catch (FieldResultIsNotADateOrTimeException dtFormat) {
            // empty catch block
        }
        double number = -1.0;
        if (date == null && (nFormat = FormattingSwitchHelper.findFirstSwitchValue("\\#", model.getFldParameters(), true)) != null) {
            if (nFormat.equals("")) {
                return "Error! Switch argument not specified.";
            }
            try {
                number = FormattingSwitchHelper.getNumber(wmlPackage, model, value);
            }
            catch (FieldResultIsNotANumberException e) {
                log.debug(e.getMessage());
                return "!Syntax Error";
            }
            value = FormattingSwitchHelper.formatNumber(model, nFormat, number, lang);
        }
        value = (gFormat = FormattingSwitchHelper.findFirstSwitchValue("\\*", model.getFldParameters(), false)) == null ? value : FormattingSwitchHelper.formatGeneral(model, gFormat, value);
        log.debug("Result -> " + value + "\n");
        return value;
    }

    private static Date getDate(FldSimpleModel model, String dateStr) throws FieldResultIsNotADateOrTimeException {
        String inputFormat = DateFormatInferencer.determineDateFormat(dateStr);
        if (inputFormat == null) {
            log.debug("Unrecognised format; Can't parse " + dateStr);
            return null;
        }
        log.debug("Parsing with format: " + inputFormat);
        Object date = null;
        try {
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat(inputFormat);
            return dateTimeFormat.parse(dateStr);
        }
        catch (ParseException e) {
            log.warn("Can't parse " + dateStr + " using format " + inputFormat);
            throw new FieldResultIsNotADateOrTimeException();
        }
    }

    private static double getNumber(WordprocessingMLPackage wmlPackage, FldSimpleModel model, String value) throws FieldResultIsNotANumberException {
        DocumentSettingsPart docSettingsPart;
        WordprocessingMLPackage pkg = wmlPackage;
        String decimalSymbol = null;
        if (pkg != null && pkg.getMainDocumentPart().getDocumentSettingsPart() != null && ((CTSettings)(docSettingsPart = pkg.getMainDocumentPart().getDocumentSettingsPart()).getJaxbElement()).getDecimalSymbol() != null) {
            decimalSymbol = ((CTSettings)docSettingsPart.getJaxbElement()).getDecimalSymbol().getVal();
        }
        if (model.fldName.equals("DOCPROPERTY") || model.fldName.equals("MERGEFIELD")) {
            NumberExtractor nex = new NumberExtractor(decimalSymbol);
            try {
                value = nex.extractNumber(value);
            }
            catch (IllegalStateException noMatch) {
                throw new FieldResultIsNotANumberException("No number in " + value);
            }
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            throw new FieldResultIsNotANumberException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String formatNumber(FldSimpleModel model, String wordNumberPattern, double dub, String lang) throws FieldFormattingException {
        boolean encounteredDecimalPoint = false;
        boolean encounteredX = false;
        char fillerBeforeDecimalPoint = '\u0000';
        char fillerAfterDecimalPoint = '\u0000';
        boolean encounteredNonFiller = false;
        int round = 0;
        int fillerBeforeDecimalPointCount = 0;
        StringBuilder buffer = new StringBuilder(32);
        int valueStart = -1;
        int idx = 0;
        int idx2 = 0;
        char ch = '\u0000';
        boolean lastCh = false;
        boolean inLiteral = false;
        if (wordNumberPattern == null || wordNumberPattern.length() == 0) {
            wordNumberPattern = "#.##########";
        }
        if (wordNumberPattern != null && wordNumberPattern.length() > 0) {
            while (idx < wordNumberPattern.length()) {
                ch = wordNumberPattern.charAt(idx);
                if (ch == '\'') {
                    if (inLiteral) {
                        buffer.append(wordNumberPattern.substring(valueStart, idx));
                        for (idx2 = idx + 1; idx2 < wordNumberPattern.length() && wordNumberPattern.charAt(idx2) == ' '; ++idx2) {
                            buffer.append(' ');
                        }
                        buffer.append('\'');
                        idx = idx2 - 1;
                        inLiteral = false;
                        valueStart = -1;
                    } else {
                        if (valueStart > -1) {
                            FormattingSwitchHelper.appendNumberItem(buffer, wordNumberPattern.substring(valueStart, idx));
                        }
                        inLiteral = true;
                        valueStart = idx;
                        if (fillerBeforeDecimalPoint != '\u0000' || fillerAfterDecimalPoint != '\u0000') {
                            encounteredNonFiller = true;
                        }
                    }
                } else if (!inLiteral) {
                    if (ch == 'x') {
                        if (!encounteredDecimalPoint) throw new FieldFormattingException("TODO implement 'x' digit dropper before decimal point ");
                        encounteredX = true;
                        ++round;
                        if (fillerAfterDecimalPoint == '\u0000') {
                            buffer.append('#');
                            fillerAfterDecimalPoint = '#';
                        } else {
                            buffer.append(fillerAfterDecimalPoint);
                        }
                    } else if (ch == '0' || ch == '#') {
                        if (encounteredNonFiller) {
                            throw new FieldFormattingException("Can't format arbitrary character between [0|#]* ");
                        }
                        if (encounteredDecimalPoint) {
                            ++round;
                            if (fillerAfterDecimalPoint == '\u0000') {
                                fillerAfterDecimalPoint = ch;
                            }
                            buffer.append(fillerAfterDecimalPoint);
                        } else {
                            if (fillerBeforeDecimalPoint == '\u0000') {
                                fillerBeforeDecimalPoint = ch;
                            }
                            buffer.append(fillerBeforeDecimalPoint);
                            ++fillerBeforeDecimalPointCount;
                        }
                    } else if (ch == '%' || ch == '\u2030' || ch == 'E' || ch == '\u00a4') {
                        buffer.append('\'');
                        buffer.append(ch);
                        buffer.append('\'');
                        if (fillerBeforeDecimalPoint != '\u0000' || fillerAfterDecimalPoint != '\u0000') {
                            encounteredNonFiller = true;
                        }
                    } else if (ch != '+' && ch != '-') {
                        buffer.append(ch);
                        if (ch == '.') {
                            encounteredDecimalPoint = true;
                        } else if (ch != ',' && ch != ' ' && (fillerBeforeDecimalPoint != '\u0000' || fillerAfterDecimalPoint != '\u0000')) {
                            encounteredNonFiller = true;
                        }
                    }
                }
                ++idx;
            }
        }
        if (valueStart > -1) {
            FormattingSwitchHelper.appendDateItem(buffer, wordNumberPattern.substring(valueStart));
        }
        if (fillerBeforeDecimalPointCount < 1 && wordNumberPattern != null && wordNumberPattern.length() > 0 && (dub < 0.0 || dub >= 1.0)) {
            throw new FieldFormattingException("Refusing to replicate Word anomolous result. ");
        }
        String javaFormatter = buffer.toString();
        DecimalFormat formatter = null;
        try {
            formatter = lang != null ? new DecimalFormat(javaFormatter, new DecimalFormatSymbols(FormattingSwitchHelper.localeforLanguageTag(lang))) : new DecimalFormat(javaFormatter);
        }
        catch (IllegalArgumentException iae) {
            throw new FieldFormattingException(iae.getMessage() + " from " + wordNumberPattern);
        }
        if (!encounteredX) return formatter.format(dub);
        formatter.setMaximumFractionDigits(round);
        return formatter.format(dub);
    }

    private static Locale localeforLanguageTag(String locale) {
        log.debug(locale + " to Locale");
        String[] parts = locale.split("-", -1);
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        return new Locale(parts[0], parts[1], parts[2]);
    }

    private static void appendNumberItem(StringBuilder buffer, String dateItem) {
        buffer.append(dateItem);
    }

    private static String formatGeneral(FldSimpleModel model, String format, String value) {
        if (format.equals("")) {
            return "Error! Switch argument not specified.";
        }
        log.debug("Applying general format " + format + " to " + value);
        if (format.toUpperCase().contains("CAPS")) {
            String[] bits = value.split(" ");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < bits.length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(FormattingSwitchHelper.firstCap(bits[i]));
            }
            return sb.toString();
        }
        if (format.toUpperCase().contains("FIRSTCAP")) {
            return FormattingSwitchHelper.firstCap(value);
        }
        if (format.toUpperCase().contains("UPPER")) {
            return value.toUpperCase();
        }
        if (format.toUpperCase().contains("LOWER")) {
            return value.toLowerCase();
        }
        log.debug("Ignoring format: " + format);
        return value;
    }

    private static String firstCap(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        if (value.length() == 1) {
            return value.substring(0, 1).toUpperCase();
        }
        if (value.startsWith("\"")) {
            return "\"" + value.substring(1, 2).toUpperCase() + value.substring(2).toLowerCase();
        }
        return value.substring(0, 1).toUpperCase() + value.substring(1).toLowerCase();
    }

    public static String getFoPageNumberFormat(String wordName) {
        String ret = null;
        if (wordName != null && wordName.length() > 0) {
            ret = FORMAT_PAGE_TO_FO.get(wordName);
            if (ret == null) {
                ret = "1";
            } else if (ret == NONE_STRING) {
                ret = null;
            }
        }
        return ret;
    }

    public static int getFoPageNumberDecoration(String wordName) {
        int ret = 0;
        if (wordName != null && wordName.length() > 0 && ("ArabicDash".equals(wordName) || NumberFormat.NUMBER_IN_DASH.value().equals(wordName))) {
            ret = 1;
        }
        return ret;
    }

    public static String getFldSimpleName(String instr) {
        String ret = null;
        int endValue = -1;
        if (instr != null && instr.length() > 0) {
            int startValue;
            for (startValue = 0; startValue < instr.length() && instr.charAt(startValue) == ' '; ++startValue) {
            }
            for (endValue = startValue; endValue < instr.length() && instr.charAt(endValue) != ' '; ++endValue) {
            }
            if (startValue < instr.length()) {
                ret = instr.substring(startValue, endValue).toUpperCase();
            }
        }
        return ret;
    }

    public static String convertDatePattern(String wordDatePattern) {
        StringBuilder buffer = new StringBuilder(32);
        int valueStart = -1;
        int idx2 = 0;
        char ch = '\u0000';
        char lastCh = '\u0000';
        boolean inLiteral = false;
        if (wordDatePattern != null && wordDatePattern.length() > 0) {
            for (int idx = 0; idx < wordDatePattern.length(); ++idx) {
                ch = wordDatePattern.charAt(idx);
                if (ch == '\'') {
                    if (inLiteral) {
                        buffer.append(wordDatePattern.substring(valueStart, idx));
                        for (idx2 = idx + 1; idx2 < wordDatePattern.length() && wordDatePattern.charAt(idx2) == ' '; ++idx2) {
                            buffer.append(' ');
                        }
                        buffer.append('\'');
                        idx = idx2 - 1;
                        inLiteral = false;
                        valueStart = -1;
                        continue;
                    }
                    if (valueStart > -1) {
                        FormattingSwitchHelper.appendDateItem(buffer, wordDatePattern.substring(valueStart, idx));
                    }
                    inLiteral = true;
                    valueStart = idx;
                    continue;
                }
                if (inLiteral) continue;
                if (lastCh != ch) {
                    if (valueStart > -1) {
                        FormattingSwitchHelper.appendDateItem(buffer, wordDatePattern.substring(valueStart, idx));
                    }
                    valueStart = idx;
                    lastCh = ch;
                }
                if (ch != 'a' && ch != 'A' || !FormattingSwitchHelper.isAMPM(wordDatePattern, idx)) continue;
                buffer.append('a');
                idx += 4;
                lastCh = '\u0000';
                valueStart = -1;
            }
        }
        if (valueStart > -1) {
            FormattingSwitchHelper.appendDateItem(buffer, wordDatePattern.substring(valueStart));
        }
        return buffer.toString();
    }

    private static boolean isAMPM(String wordDatePattern, int idx) {
        int i = idx;
        return !(idx + 4 >= wordDatePattern.length() || wordDatePattern.charAt(++i) != 'm' && wordDatePattern.charAt(i) != 'M' || wordDatePattern.charAt(++i) != '/' || wordDatePattern.charAt(++i) != 'p' && wordDatePattern.charAt(i) != 'P' || wordDatePattern.charAt(++i) != 'm' && wordDatePattern.charAt(i) != 'M');
    }

    private static void appendDateItem(StringBuilder buffer, String dateItem) {
        String javaVal = DATE_FORMAT_ITEMS_TO_JAVA.get(dateItem);
        buffer.append(javaVal != null ? javaVal : dateItem);
    }

    public static String formatDate(FldSimpleModel model) {
        return FormattingSwitchHelper.formatDate(model, new Date());
    }

    public static String formatDate(FldSimpleModel model, Date date) {
        String format = FormattingSwitchHelper.findFirstSwitchValue("\\@", model.getFldParameters(), true);
        return FormattingSwitchHelper.formatDate(model, format, date);
    }

    public static String formatDate(FldSimpleModel model, String format, Date date) {
        return FormattingSwitchHelper.formatDate(model, format, date, null);
    }

    private static String formatDate(FldSimpleModel model, String format, Date date, String lang) {
        DateFormat dateFormat = null;
        if (format != null && format.length() > 0) {
            SimpleDateFormat simpleDateFormat = FormattingSwitchHelper.getSimpleDateFormat(lang);
            simpleDateFormat.applyPattern(FormattingSwitchHelper.convertDatePattern(format));
            dateFormat = simpleDateFormat;
        } else {
            dateFormat = model.getFldName().indexOf("DATE") > -1 ? SimpleDateFormat.getDateInstance(3) : SimpleDateFormat.getTimeInstance(3);
        }
        return dateFormat.format(date);
    }

    public static boolean hasSwitch(String switchDef, List<String> fldParameters) {
        return FormattingSwitchHelper.findSwitch(switchDef, 0, fldParameters) > -1;
    }

    public static String findFirstSwitchValue(String switchDef, List<String> fldParameters, boolean ignoreMergeformat) {
        int pos = FormattingSwitchHelper.findSwitch(switchDef, 0, fldParameters);
        String switchValue = null;
        if (pos > -1) {
            switchValue = FormattingSwitchHelper.getSwitchValue(pos + 1, fldParameters);
            if (MERGEFORMAT.equals(switchValue) && ignoreMergeformat) {
                switchValue = null;
                if ((pos = FormattingSwitchHelper.findSwitch(switchDef, pos + 1, fldParameters)) > -1) {
                    switchValue = FormattingSwitchHelper.getSwitchValue(pos + 1, fldParameters);
                }
            }
            switchValue = switchValue == null ? "" : switchValue;
        }
        return switchValue;
    }

    public static String getSwitchValue(int pos, List<String> fldParameters) {
        String ret = null;
        if (fldParameters != null && pos > -1 && pos < fldParameters.size() && (ret = fldParameters.get(pos)).length() > 1 && ret.charAt(0) == '\"' && ret.charAt(ret.length() - 1) == '\"') {
            ret = ret.substring(1, ret.length() - 1);
        }
        if (ret != null && ret.length() > 0 && ret.charAt(0) == '\\') {
            ret = null;
        }
        return ret;
    }

    public static List<String> findAllSwitchValues(String switchDef, List<String> fldParameters) {
        ArrayList<String> ret = null;
        int pos = 0;
        while ((pos = FormattingSwitchHelper.findSwitch(switchDef, pos, fldParameters)) > -1) {
            if (ret == null) {
                ret = new ArrayList<String>();
            }
            ret.add(FormattingSwitchHelper.getSwitchValue(++pos, fldParameters));
        }
        return ret;
    }

    public static int findSwitch(String switchDef, int startPos, List<String> fldParameters) {
        int ret = -1;
        if (fldParameters != null && !fldParameters.isEmpty()) {
            for (int i = startPos; i < fldParameters.size(); ++i) {
                if (!switchDef.equals(fldParameters.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    private static SimpleDateFormat getSimpleDateFormat(String lang) {
        Map<String, SimpleDateFormat> dateFormatsMap = DATE_FORMATS.get();
        SimpleDateFormat dateFormat = dateFormatsMap.get(lang);
        if (dateFormat == null) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 0, FormattingSwitchHelper.localeforLanguageTag(lang));
            dateFormatsMap.put(lang, dateFormat);
        }
        return dateFormat;
    }

    static {
        FORMAT_PAGE_TO_FO.put("Arabic", "1");
        FORMAT_PAGE_TO_FO.put("ArabicDash", "1");
        FORMAT_PAGE_TO_FO.put("alphabetic", FO_PAGENUMBER_LOWERALPHA);
        FORMAT_PAGE_TO_FO.put("ALPHABETIC", FO_PAGENUMBER_UPPERALPHA);
        FORMAT_PAGE_TO_FO.put("roman", FO_PAGENUMBER_LOWERROMAN);
        FORMAT_PAGE_TO_FO.put("ROMAN", FO_PAGENUMBER_UPPERROMAN);
        FORMAT_PAGE_TO_FO.put(NumberFormat.NONE.value(), NONE_STRING);
        FORMAT_PAGE_TO_FO.put(NumberFormat.DECIMAL.value(), "1");
        FORMAT_PAGE_TO_FO.put(NumberFormat.NUMBER_IN_DASH.value(), "1");
        FORMAT_PAGE_TO_FO.put(NumberFormat.LOWER_LETTER.value(), FO_PAGENUMBER_LOWERALPHA);
        FORMAT_PAGE_TO_FO.put(NumberFormat.UPPER_LETTER.value(), FO_PAGENUMBER_UPPERALPHA);
        FORMAT_PAGE_TO_FO.put(NumberFormat.LOWER_ROMAN.value(), FO_PAGENUMBER_LOWERROMAN);
        FORMAT_PAGE_TO_FO.put(NumberFormat.UPPER_ROMAN.value(), FO_PAGENUMBER_UPPERROMAN);
        DATE_FORMAT_ITEMS_TO_JAVA.put("M", "M");
        DATE_FORMAT_ITEMS_TO_JAVA.put("MM", "MM");
        DATE_FORMAT_ITEMS_TO_JAVA.put("MMM", "MMM");
        DATE_FORMAT_ITEMS_TO_JAVA.put("MMMM", "MMMM");
        DATE_FORMAT_ITEMS_TO_JAVA.put("d", "d");
        DATE_FORMAT_ITEMS_TO_JAVA.put("dd", "dd");
        DATE_FORMAT_ITEMS_TO_JAVA.put("ddd", "EEE");
        DATE_FORMAT_ITEMS_TO_JAVA.put("dddd", "EEEE");
        DATE_FORMAT_ITEMS_TO_JAVA.put("yy", "yy");
        DATE_FORMAT_ITEMS_TO_JAVA.put("yyyy", "yyyy");
        DATE_FORMAT_ITEMS_TO_JAVA.put("h", "K");
        DATE_FORMAT_ITEMS_TO_JAVA.put("H", "H");
        DATE_FORMAT_ITEMS_TO_JAVA.put("hh", "KK");
        DATE_FORMAT_ITEMS_TO_JAVA.put("HH", "HH");
        DATE_FORMAT_ITEMS_TO_JAVA.put("m", "m");
        DATE_FORMAT_ITEMS_TO_JAVA.put("mm", "mm");
        DATE_FORMAT_ITEMS_TO_JAVA.put("s", "s");
        DATE_FORMAT_ITEMS_TO_JAVA.put("ss", "ss");
    }

    private static class FieldResultIsNotANumberException
    extends Exception {
        public FieldResultIsNotANumberException() {
        }

        public FieldResultIsNotANumberException(String string) {
            super(string);
        }
    }

    private static class FieldResultIsNotADateOrTimeException
    extends Exception {
        public FieldResultIsNotADateOrTimeException() {
        }

        public FieldResultIsNotADateOrTimeException(String string) {
            super(string);
        }
    }
}

