/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.SpreadsheetML;

import java.util.List;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.SpreadsheetML.JaxbSmlPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.SharedStrings;
import org.docx4j.openpackaging.parts.SpreadsheetML.Styles;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.xlsx4j.exceptions.Xlsx4jException;
import org.xlsx4j.sml.Sheet;
import org.xlsx4j.sml.Workbook;
import org.xlsx4j.sml.WorkbookPr;

public class WorkbookPart
extends JaxbSmlPart<Workbook> {
    protected SharedStrings sharedStrings;
    protected Styles stylesPart;

    public WorkbookPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public WorkbookPart() throws InvalidFormatException {
        super(new PartName("/xl/workbook.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
    }

    public SharedStrings getSharedStrings() {
        return this.sharedStrings;
    }

    public Styles getStylesPart() {
        return this.stylesPart;
    }

    public boolean setPartShortcut(Part part) {
        if (part == null) {
            return false;
        }
        return this.setPartShortcut(part, part.getRelationshipType());
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        if (relationshipType == null) {
            log.warn("trying to set part shortcut against a null relationship type.");
            return false;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings")) {
            this.sharedStrings = (SharedStrings)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles")) {
            this.stylesPart = (Styles)part;
            return true;
        }
        return false;
    }

    public WorksheetPart getWorksheet(int index) throws Xlsx4jException {
        List<Sheet> sheets;
        try {
            sheets = ((Workbook)this.getContents()).getSheets().getSheet();
        }
        catch (Docx4JException e1) {
            throw new Xlsx4jException(e1.getMessage(), e1);
        }
        int zeroBasedCount = sheets.size() - 1;
        if (index < 0 || index > zeroBasedCount) {
            throw new Xlsx4jException("No sheet at index " + index + ".  (There are " + sheets.size() + " sheets) ");
        }
        try {
            Sheet s = sheets.get(index);
            return (WorksheetPart)this.getRelationshipsPart().getPart(s.getId());
        }
        catch (Exception e) {
            throw new Xlsx4jException("Sheet " + index + " not found", e);
        }
    }

    public boolean isDate1904() {
        WorkbookPr workbookPr = ((Workbook)this.jaxbElement).getWorkbookPr();
        return workbookPr != null && workbookPr.isDate1904();
    }
}

