/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx;

import java.util.List;
import java.util.Set;
import org.camunda.bpm.dmn.xlsx.BaseAdapter;
import org.camunda.bpm.dmn.xlsx.InputOutputColumns;
import org.camunda.bpm.dmn.xlsx.api.Spreadsheet;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetCell;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetRow;
import org.camunda.bpm.dmn.xlsx.elements.HeaderValuesContainer;
import org.camunda.bpm.model.dmn.HitPolicy;

public class StaticInputOutputDetectionStrategy
extends BaseAdapter {
    protected Set<String> inputColumns;
    protected Set<String> outputColumns;

    public StaticInputOutputDetectionStrategy(Set<String> inputColumns, Set<String> outputColumns) {
        this.inputColumns = inputColumns;
        this.outputColumns = outputColumns;
    }

    @Override
    public InputOutputColumns determineInputOutputs(Spreadsheet context) {
        SpreadsheetRow headerRow = context.getRows().get(0);
        InputOutputColumns columns = new InputOutputColumns();
        for (SpreadsheetCell cell : headerRow.getCells()) {
            HeaderValuesContainer hvc;
            if (this.inputColumns.contains(cell.getColumn())) {
                hvc = new HeaderValuesContainer();
                this.fillHvc(cell, context, hvc);
                hvc.setId("Input" + cell.getColumn());
                columns.addInputHeader(hvc);
                continue;
            }
            if (!this.outputColumns.contains(cell.getColumn())) continue;
            hvc = new HeaderValuesContainer();
            this.fillHvc(cell, context, hvc);
            hvc.setId("Output" + cell.getColumn());
            columns.addOutputHeader(hvc);
        }
        return columns;
    }

    @Override
    public HitPolicy determineHitPolicy(Spreadsheet context) {
        return null;
    }

    @Override
    public List<SpreadsheetRow> determineRuleRows(Spreadsheet context) {
        List<SpreadsheetRow> rows = context.getRows();
        return rows.subList(1, rows.size());
    }

    private void fillHvc(SpreadsheetCell cell, Spreadsheet context, HeaderValuesContainer hvc) {
        hvc.setText(context.resolveCellContent(cell));
        hvc.setColumn(cell.getColumn());
    }
}

