/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx;

import java.io.InputStream;
import org.camunda.bpm.dmn.xlsx.SimpleInputOutputDetectionStrategy;
import org.camunda.bpm.dmn.xlsx.XlsxWorksheetContext;
import org.camunda.bpm.dmn.xlsx.XlsxWorksheetConverter;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetAdapter;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.docx4j.docProps.extended.Properties;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.SharedStrings;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorkbookPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.xlsx4j.sml.CTSst;
import org.xlsx4j.sml.Worksheet;

public class XlsxConverter {
    public static final String DEFAULT_HISTORY_TIME_TO_LIVE = "P180D";
    protected String historyTimeToLive = "P180D";
    protected SpreadsheetAdapter ioDetectionStrategy = new SimpleInputOutputDetectionStrategy();

    public DmnModelInstance convert(InputStream inputStream) {
        SpreadsheetMLPackage spreadSheetPackage = null;
        try {
            spreadSheetPackage = SpreadsheetMLPackage.load(inputStream);
        }
        catch (Docx4JException e) {
            throw new RuntimeException("cannot load document", e);
        }
        WorkbookPart workbookPart = spreadSheetPackage.getWorkbookPart();
        XlsxWorksheetContext worksheetContext = null;
        try {
            DocPropsExtendedPart docPropsExtendedPart = spreadSheetPackage.getDocPropsExtendedPart();
            String worksheetName = docPropsExtendedPart != null && ((Properties)docPropsExtendedPart.getContents()).getTitlesOfParts() != null ? (String)((Properties)docPropsExtendedPart.getContents()).getTitlesOfParts().getVector().getVariantOrI1OrI2().get(0).getValue() : "default";
            WorksheetPart worksheetPart = workbookPart.getWorksheet(0);
            SharedStrings sharedStrings = workbookPart.getSharedStrings();
            worksheetContext = new XlsxWorksheetContext((CTSst)sharedStrings.getContents(), (Worksheet)worksheetPart.getContents(), worksheetName);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine worksheet", e);
        }
        return new XlsxWorksheetConverter(worksheetContext, this.ioDetectionStrategy, this.historyTimeToLive).convert();
    }

    public SpreadsheetAdapter getIoDetectionStrategy() {
        return this.ioDetectionStrategy;
    }

    public void setIoDetectionStrategy(SpreadsheetAdapter ioDetectionStrategy) {
        this.ioDetectionStrategy = ioDetectionStrategy;
    }

    public String getHistoryTimeToLive() {
        return this.historyTimeToLive;
    }

    public void setHistoryTimeToLive(String historyTimeToLive) {
        this.historyTimeToLive = historyTimeToLive;
    }
}

