/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.dmn.xlsx.CellContentHandler;
import org.camunda.bpm.dmn.xlsx.api.Spreadsheet;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetCell;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetRow;
import org.camunda.bpm.dmn.xlsx.elements.IndexedRow;
import org.xlsx4j.sml.CTRst;
import org.xlsx4j.sml.CTSst;
import org.xlsx4j.sml.Cell;
import org.xlsx4j.sml.Row;
import org.xlsx4j.sml.STCellType;
import org.xlsx4j.sml.Worksheet;

public class XlsxWorksheetContext
implements Spreadsheet {
    protected List<CellContentHandler> cellContentHandlers;
    protected CTSst sharedStrings;
    protected Worksheet worksheet;
    protected String worksheetName;
    protected List<SpreadsheetRow> indexedRows;

    public XlsxWorksheetContext(CTSst sharedStrings, Worksheet worksheet, String worksheetName) {
        this.sharedStrings = sharedStrings;
        this.worksheet = worksheet;
        this.cellContentHandlers = new ArrayList<CellContentHandler>();
        this.worksheetName = worksheetName;
    }

    @Override
    public List<SpreadsheetRow> getRows() {
        if (this.indexedRows == null) {
            this.indexedRows = new ArrayList<SpreadsheetRow>();
            for (Row row : this.worksheet.getSheetData().getRow()) {
                this.indexedRows.add(new IndexedRow(row));
            }
        }
        return this.indexedRows;
    }

    public String resolveSharedString(int index) {
        List<CTRst> siElements = this.sharedStrings.getSi();
        return siElements.get(index).getT().getValue();
    }

    @Override
    public String resolveCellContent(SpreadsheetCell cell) {
        Cell rawCell = cell.getRaw();
        STCellType cellType = rawCell.getT();
        if (STCellType.S.equals((Object)cellType)) {
            int sharedStringIndex = Integer.parseInt(rawCell.getV());
            return this.resolveSharedString(sharedStringIndex);
        }
        return rawCell.getV();
    }

    @Override
    public String getName() {
        return this.worksheetName;
    }
}

