/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.XsltCommonFunctions;
import org.docx4j.convert.out.html.HTMLConversionContext;
import org.docx4j.convert.out.html.HtmlCssHelper;
import org.docx4j.convert.out.html.HtmlScriptHelper;
import org.docx4j.convert.out.html.SdtWriter;
import org.docx4j.convert.out.html.TableWriter;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.model.properties.AdHocProperty;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.paragraph.Indent;
import org.docx4j.model.properties.table.BorderBottom;
import org.docx4j.model.properties.table.BorderLeft;
import org.docx4j.model.properties.table.BorderRight;
import org.docx4j.model.properties.table.BorderTop;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.model.styles.Tree;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblBorders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;

public class XsltHTMLFunctions {
    private static Logger log = LoggerFactory.getLogger(XsltHTMLFunctions.class);

    public static DocumentFragment appendHeadElement(HTMLConversionContext conversionContext) {
        Document document = XmlUtils.getNewDocumentBuilder().newDocument();
        Element headEl = document.createElement("head");
        Element meta = document.createElement("meta");
        Element element = null;
        StringBuilder buffer = new StringBuilder(10240);
        document.appendChild(headEl);
        meta.setAttribute("http-equiv", "Content-Type");
        meta.setAttribute("content", "text/html; charset=utf-8");
        headEl.appendChild(meta);
        element = XsltHTMLFunctions.createStyleElement(conversionContext, document, buffer);
        if (element != null) {
            headEl.appendChild(element);
        }
        buffer.setLength(0);
        element = XsltHTMLFunctions.createScriptElement(conversionContext, document, buffer);
        if (element != null) {
            headEl.appendChild(element);
        }
        DocumentFragment docfrag = document.createDocumentFragment();
        docfrag.appendChild(document.getDocumentElement());
        return docfrag;
    }

    public static DocumentFragment appendStyleElement(HTMLConversionContext conversionContext) {
        StringBuilder buffer;
        Document document = XmlUtils.getNewDocumentBuilder().newDocument();
        Element element = XsltHTMLFunctions.createStyleElement(conversionContext, document, buffer = new StringBuilder(10240));
        if (element == null) {
            return null;
        }
        document.appendChild(element);
        DocumentFragment docfrag = document.createDocumentFragment();
        docfrag.appendChild(document.getDocumentElement());
        return docfrag;
    }

    public static DocumentFragment appendScriptElement(HTMLConversionContext conversionContext) {
        StringBuilder buffer;
        Document document = XmlUtils.getNewDocumentBuilder().newDocument();
        Element element = XsltHTMLFunctions.createScriptElement(conversionContext, document, buffer = new StringBuilder(10240));
        if (element == null) {
            return null;
        }
        document.appendChild(element);
        DocumentFragment docfrag = document.createDocumentFragment();
        docfrag.appendChild(document.getDocumentElement());
        return docfrag;
    }

    private static Element createStyleElement(HTMLConversionContext conversionContext, Document document, StringBuilder buffer) {
        String userCSS = conversionContext.getUserCSS();
        boolean hasDefaultHeader = false;
        boolean hasDefaultFooter = false;
        hasDefaultHeader = XsltCommonFunctions.hasDefaultHeader(conversionContext);
        hasDefaultFooter = XsltCommonFunctions.hasDefaultHeader(conversionContext);
        HtmlCssHelper.createDefaultCss(hasDefaultHeader, hasDefaultFooter, buffer);
        HtmlCssHelper.createCssForStyles(conversionContext.getWmlPackage(), conversionContext.getStyleTree(), buffer);
        if (userCSS != null && userCSS.length() > 0) {
            buffer.append(userCSS);
        }
        return conversionContext.createStyleElement(document, buffer.toString());
    }

    private static Element createScriptElement(HTMLConversionContext conversionContext, Document document, StringBuilder buffer) {
        String userScript = conversionContext.getUserScript();
        HtmlScriptHelper.createDefaultScript(buffer);
        if (userScript != null && userScript.length() > 0) {
            buffer.append(userScript);
        }
        return conversionContext.createScriptElement(document, buffer.toString());
    }

    public static String getNumberXmlNode(HTMLConversionContext context, NodeIterator pPrNodeIt, String pStyleVal, String numId, String levelId) {
        context.getLog().debug("numbering, using style '" + pStyleVal + "'; numId=" + numId + "; ilvl " + levelId);
        try {
            Emulator.ResultTriple triple = Emulator.getNumber(context.getWmlPackage(), pStyleVal, numId, levelId);
            if (triple == null) {
                context.getLog().debug("computed number ResultTriple was null");
                return null;
            }
            String styleVal = "";
            if (triple.getBullet() != null) {
                return "\u2022  ";
            }
            if (triple.getNumString() == null) {
                context.getLog().debug("computed NumString was null (which may be ok)");
                return " ";
            }
            return triple.getNumString() + " ";
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getLog().error(e.getMessage(), e);
            return "?  ";
        }
    }

    public static String getCssForStyles(HTMLConversionContext context) {
        StringBuilder result = new StringBuilder();
        StyleTree styleTree = null;
        try {
            styleTree = context.getWmlPackage().getMainDocumentPart().getStyleTree();
        }
        catch (Exception e) {
            context.getLog().error("Couldn't getStyleTree", e);
            return result.toString();
        }
        HtmlCssHelper.createCssForStyles(context.getWmlPackage(), styleTree, result);
        if (context.getLog().isDebugEnabled()) {
            return result.toString();
        }
        String debug = result.toString();
        return debug;
    }

    public static String getCssForTableCells(HTMLConversionContext context, NodeIterator tables) {
        StringBuffer result = new StringBuffer();
        Element n = (Element)tables.nextNode();
        if (n == null) {
            return "";
        }
        int idx = 0;
        do {
            if (n.getNodeName().equals("w:tbl")) {
                try {
                    Unmarshaller u = Context.jc.createUnmarshaller();
                    u.setEventHandler(new JaxbValidationEventHandler());
                    Object jaxb = u.unmarshal(n);
                    Tbl tbl = (Tbl)jaxb;
                    result.append(XsltHTMLFunctions.getCssForTableCells(context, tbl, idx));
                }
                catch (JAXBException e1) {
                    context.getLog().error("JAXB error", e1);
                }
                catch (ClassCastException e) {
                    context.getLog().error("Couldn't cast to Tbl!");
                }
            } else {
                context.getLog().warn("Expected table but encountered: " + n.getNodeName());
            }
            ++idx;
        } while ((n = (Element)tables.nextNode()) != null);
        return result.toString();
    }

    private static String getCssForTableCells(HTMLConversionContext context, Tbl tbl, int idx) {
        StringBuffer result = new StringBuffer();
        PropertyResolver pr = context.getPropertyResolver();
        Style s2 = pr.getEffectiveTableStyle(tbl.getTblPr());
        result.append("#" + TableWriter.getId(idx) + " td { ");
        ArrayList<Property> properties = new ArrayList<Property>();
        if (s2.getTblPr() != null && s2.getTblPr().getTblBorders() != null) {
            TblBorders tblBorders = s2.getTblPr().getTblBorders();
            if (tblBorders.getInsideH() != null) {
                if (tblBorders.getInsideH().getVal() == STBorder.NONE || tblBorders.getInsideH().getVal() == STBorder.NIL || tblBorders.getInsideH().getSz() == BigInteger.ZERO) {
                    properties.add(new AdHocProperty("border-top-style", "none", null, null));
                    properties.add(new AdHocProperty("border-top-width", "0mm", null, null));
                    properties.add(new AdHocProperty("border-bottom-style", "none", null, null));
                    properties.add(new AdHocProperty("border-bottom-width", "0mm", null, null));
                } else {
                    properties.add(new BorderTop(tblBorders.getTop()));
                    properties.add(new BorderBottom(tblBorders.getBottom()));
                }
            }
            if (tblBorders.getInsideV() != null) {
                if (tblBorders.getInsideV().getVal() == STBorder.NONE || tblBorders.getInsideV().getVal() == STBorder.NIL || tblBorders.getInsideV().getSz() == BigInteger.ZERO) {
                    properties.add(new AdHocProperty("border-left-style", "none", null, null));
                    properties.add(new AdHocProperty("border-left-width", "0mm", null, null));
                    properties.add(new AdHocProperty("border-right-style", "none", null, null));
                    properties.add(new AdHocProperty("border-right-width", "0mm", null, null));
                } else {
                    properties.add(new BorderRight(tblBorders.getRight()));
                    properties.add(new BorderLeft(tblBorders.getLeft()));
                }
            }
        }
        if (s2.getTcPr() != null) {
            PropertyFactory.createProperties(properties, s2.getTcPr());
        }
        properties.add(new AdHocProperty("height", "5mm", null, null));
        for (Property p : properties) {
            if (p == null) continue;
            result.append(p.getCssProperty());
        }
        result.append("}\n");
        return result.toString();
    }

    public static org.w3c.dom.Node toSdtNode(HTMLConversionContext context, NodeIterator sdtPrNodeIt, NodeIterator childResults) throws TransformerException {
        return SdtWriter.toNode(context, sdtPrNodeIt, childResults);
    }

    private static DocumentFragment createBlockForSdt(HTMLConversionContext context, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults, String tag) {
        DocumentFragment docfrag = XsltHTMLFunctions.createBlock(context, pPrNodeIt, pStyleVal, childResults, "div");
        return docfrag;
    }

    public static DocumentFragment createBlockForPPr(HTMLConversionContext context, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults) {
        return XsltHTMLFunctions.createBlock(context, pPrNodeIt, pStyleVal, childResults, "p");
    }

    public static DocumentFragment createListItemBlockForPPr(HTMLConversionContext context, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults) {
        return XsltHTMLFunctions.createBlock(context, pPrNodeIt, pStyleVal, childResults, "li");
    }

    private static DocumentFragment createBlock(HTMLConversionContext context, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults, String htmlElementName) {
        StyleTree styleTree = context.getWmlPackage().getMainDocumentPart().getStyleTree();
        Style defaultParagraphStyle = context.getWmlPackage().getMainDocumentPart().getStyleDefinitionsPart(false) != null ? context.getWmlPackage().getMainDocumentPart().getStyleDefinitionsPart(false).getDefaultParagraphStyle() : null;
        String defaultParagraphStyleId = defaultParagraphStyle == null ? "Normal" : defaultParagraphStyle.getStyleId();
        if (pStyleVal == null || pStyleVal.equals("")) {
            pStyleVal = defaultParagraphStyleId;
        }
        context.getLog().debug("style '" + pStyleVal);
        try {
            org.w3c.dom.Node n;
            PPr pPr = null;
            if (pPrNodeIt != null && (n = pPrNodeIt.nextNode()) != null) {
                Unmarshaller u = Context.jc.createUnmarshaller();
                u.setEventHandler(new JaxbValidationEventHandler());
                Object jaxb = u.unmarshal(n);
                try {
                    pPr = (PPr)jaxb;
                }
                catch (ClassCastException e) {
                    context.getLog().error("Couldn't cast " + jaxb.getClass().getName() + " to PPr!");
                }
            }
            Document document = XmlUtils.getNewDocumentBuilder().newDocument();
            Element xhtmlBlock = document.createElement(htmlElementName);
            document.appendChild(xhtmlBlock);
            if (context.getLog().isDebugEnabled() && pPr != null) {
                context.getLog().debug(XmlUtils.marshaltoString((Object)pPr, true, true));
            }
            context.getLog().debug(pStyleVal);
            Tree<StyleTree.AugmentedStyle> pTree = styleTree.getParagraphStylesTree();
            Node<StyleTree.AugmentedStyle> asn = pTree.get(pStyleVal);
            String classVal = StyleTree.getHtmlClassAttributeValue(pTree, asn);
            xhtmlBlock.setAttribute("class", classVal);
            boolean ignoreBorders = htmlElementName.equals("p");
            if (pPr != null) {
                PPrBase.Ind numInd;
                if (pPr.getNumPr() != null && pPr.getNumPr().getNumId() != null && pPr.getNumPr().getNumId().getVal().longValue() != 0L && (numInd = Emulator.getInd(context.getWmlPackage(), pStyleVal, pPr.getNumPr().getNumId().getVal().toString(), pPr.getNumPr().getIlvl().getVal().toString())) != null) {
                    Indent indent = new Indent(pPr.getInd(), numInd);
                    pPr.setInd((PPrBase.Ind)indent.getObject());
                }
                StringBuilder inlineStyle = new StringBuilder();
                HtmlCssHelper.createCss(context.getWmlPackage(), pPr, inlineStyle, ignoreBorders, xhtmlBlock.getNodeName().equals("li"));
                if (!inlineStyle.toString().equals("")) {
                    xhtmlBlock.setAttribute("style", inlineStyle.toString());
                }
            }
            org.w3c.dom.Node n2 = childResults.nextNode();
            if (xhtmlBlock.getNodeName().equals("p") && context.getBookmarkStart() != null) {
                xhtmlBlock.setAttribute("id", context.getBookmarkStart().getName());
                context.setBookmarkStart(null);
            }
            if (xhtmlBlock.getNodeName().equals("p") && n2.hasChildNodes() && n2.getChildNodes().item(0).getLocalName().equals("span")) {
                XsltHTMLFunctions.mergeSpans(n2.getChildNodes(), document, xhtmlBlock);
            } else {
                do {
                    if (n2.getNodeType() == 9) {
                        context.getLog().debug("handling DOCUMENT_NODE");
                        NodeList nodes = n2.getChildNodes();
                        if (nodes == null) continue;
                        for (int i = 0; i < nodes.getLength(); ++i) {
                            if (nodes.item(i).getLocalName().equals("span") && !nodes.item(i).hasChildNodes()) {
                                context.getLog().debug(".. ignoring <span/> ");
                                continue;
                            }
                            XmlUtils.treeCopy(nodes.item(i), (org.w3c.dom.Node)xhtmlBlock);
                        }
                    } else {
                        XmlUtils.treeCopy(n2, (org.w3c.dom.Node)xhtmlBlock);
                    }
                } while ((n2 = childResults.nextNode()) != null);
            }
            if (xhtmlBlock.getNodeName().equals("p") && !xhtmlBlock.hasChildNodes()) {
                Text t = document.createTextNode("\u00a0");
                xhtmlBlock.appendChild(t);
            }
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            context.getLog().error(e.getMessage(), e);
            return null;
        }
    }

    private static void mergeSpans(NodeList nodes, Document document, Element xhtmlBlock) {
        Element currentEl;
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        int startIndex = 0;
        while (!(currentEl = (Element)nodes.item(startIndex)).getLocalName().equals("span")) {
            XmlUtils.treeCopy(currentEl, (org.w3c.dom.Node)xhtmlBlock);
            if (++startIndex != nodes.getLength()) continue;
            return;
        }
        Element currentSpan = currentEl;
        String currentClass = currentSpan.getAttribute("class");
        String currentStyle = currentSpan.getAttribute("style");
        Element newSpan = document.createElement("span");
        if (currentClass != null) {
            newSpan.setAttribute("class", currentClass);
        }
        if (currentStyle != null) {
            newSpan.setAttribute("style", currentStyle);
        }
        XmlUtils.treeCopy(currentSpan.getChildNodes(), (org.w3c.dom.Node)newSpan);
        xhtmlBlock.appendChild(newSpan);
        for (int i = startIndex + 1; i < nodes.getLength(); ++i) {
            boolean styleSame;
            Element thisSpan = (Element)nodes.item(i);
            if (!thisSpan.getLocalName().equals("span")) {
                XmlUtils.treeCopy(thisSpan, (org.w3c.dom.Node)xhtmlBlock);
                newSpan = document.createElement("span");
                xhtmlBlock.appendChild(newSpan);
                if (currentClass != null) {
                    newSpan.setAttribute("class", currentClass);
                }
                if (currentStyle == null) continue;
                newSpan.setAttribute("style", currentStyle);
                continue;
            }
            if (!thisSpan.hasChildNodes()) continue;
            String thisClass = thisSpan.getAttribute("class");
            String thisStyle = thisSpan.getAttribute("style");
            boolean classSame = currentClass == null && thisClass == null || currentClass != null && currentClass.equals(thisClass);
            boolean bl = styleSame = currentStyle == null && thisStyle == null || currentStyle != null && currentStyle.equals(thisStyle);
            if (classSame && styleSame) {
                XmlUtils.treeCopy(thisSpan.getChildNodes(), (org.w3c.dom.Node)newSpan);
                continue;
            }
            newSpan = document.createElement("span");
            if (thisClass != null) {
                newSpan.setAttribute("class", thisClass);
            }
            if (thisStyle != null) {
                newSpan.setAttribute("style", thisStyle);
            }
            XmlUtils.treeCopy(thisSpan.getChildNodes(), (org.w3c.dom.Node)newSpan);
            xhtmlBlock.appendChild(newSpan);
            currentClass = thisClass;
            currentStyle = thisStyle;
        }
    }

    public static DocumentFragment createBlockForRPr(HTMLConversionContext context, String pStyleVal, NodeIterator rPrNodeIt, NodeIterator childResults) {
        Style defaultRunStyle = context.getWmlPackage().getMainDocumentPart().getStyleDefinitionsPart(false) != null ? context.getWmlPackage().getMainDocumentPart().getStyleDefinitionsPart(false).getDefaultCharacterStyle() : null;
        String defaultCharacterStyleId = defaultRunStyle.getStyleId() == null ? "DefaultParagraphFont" : defaultRunStyle.getStyleId();
        StyleTree styleTree = context.getWmlPackage().getMainDocumentPart().getStyleTree();
        try {
            org.w3c.dom.Node n;
            RPr rPr = null;
            if (rPrNodeIt != null && (n = rPrNodeIt.nextNode()) != null) {
                Unmarshaller u = Context.jc.createUnmarshaller();
                u.setEventHandler(new JaxbValidationEventHandler());
                Object jaxb = u.unmarshal(n);
                try {
                    rPr = (RPr)jaxb;
                }
                catch (ClassCastException e) {
                    context.getLog().error("Couldn't cast " + jaxb.getClass().getName() + " to RPr!");
                }
            }
            n = childResults.nextNode();
            Document document = XmlUtils.getNewDocumentBuilder().newDocument();
            Element span = document.createElement("span");
            document.appendChild(span);
            if (n.hasChildNodes() && n.getChildNodes().getLength() == 1 && n.getChildNodes().item(0).getLocalName().equals("span")) {
                String existingStyle = ((Element)n.getChildNodes().item(0)).getAttribute("style");
                span.setAttribute("style", existingStyle);
                XsltHTMLFunctions.setSpanAttr(context, defaultCharacterStyleId, styleTree, rPr, span);
                XmlUtils.treeCopy(n.getChildNodes().item(0).getChildNodes(), (org.w3c.dom.Node)span);
            } else {
                XsltHTMLFunctions.setSpanAttr(context, defaultCharacterStyleId, styleTree, rPr, span);
                XsltHTMLFunctions.mergeSpans(n.getChildNodes(), document, span);
            }
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            context.getLog().error(e.getMessage(), e);
            return null;
        }
    }

    private static void setSpanAttr(HTMLConversionContext context, String defaultCharacterStyleId, StyleTree styleTree, RPr rPr, Element span) {
        Tree<StyleTree.AugmentedStyle> cTree;
        Node<StyleTree.AugmentedStyle> asn;
        String rStyleVal = defaultCharacterStyleId;
        if (rPr != null && rPr.getRStyle() != null) {
            rStyleVal = rPr.getRStyle().getVal();
        }
        if ((asn = (cTree = styleTree.getCharacterStylesTree()).get(rStyleVal)) == null) {
            context.getLog().warn("Can't set @class; No style node for: " + rStyleVal);
        } else {
            String classVal = StyleTree.getHtmlClassAttributeValue(cTree, asn);
            if (classVal != null && !classVal.equals("")) {
                span.setAttribute("class", classVal);
            }
        }
        if (rPr != null) {
            if (context.getLog().isDebugEnabled()) {
                context.getLog().debug(XmlUtils.marshaltoString((Object)rPr, true, true));
            }
            StringBuilder inlineStyle = new StringBuilder();
            HtmlCssHelper.createCss(context.getWmlPackage(), rPr, inlineStyle);
            if (!inlineStyle.toString().equals("")) {
                String existingStyle = span.getAttribute("style");
                if (existingStyle == null || existingStyle.trim().equals("")) {
                    span.setAttribute("style", inlineStyle.toString());
                } else {
                    span.setAttribute("style", inlineStyle.toString() + ";" + existingStyle);
                }
            }
        }
    }
}

