/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.microsoft;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.fonts.microsoft.MicrosoftFonts;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrosoftFontsRegistry {
    protected static Logger log = LoggerFactory.getLogger(MicrosoftFontsRegistry.class);
    private static HashMap<String, MicrosoftFonts.Font> msFontsByName;

    public static final Map<String, MicrosoftFonts.Font> getMsFonts() {
        return msFontsByName;
    }

    private static final void setupMicrosoftFontsRegistry() throws Exception {
        msFontsByName = new HashMap();
        ClassLoader classLoader = MicrosoftFontsRegistry.class.getClassLoader();
        JAXBContext msFontsContext = JAXBContext.newInstance("org.docx4j.fonts.microsoft", classLoader);
        Unmarshaller u = msFontsContext.createUnmarshaller();
        u.setEventHandler(new JaxbValidationEventHandler());
        InputStream is = ResourceUtils.getResourceViaProperty("docx4j.fonts.microsoft.MicrosoftFonts", "org/docx4j/fonts/microsoft/MicrosoftFonts.xml");
        MicrosoftFonts msFonts = (MicrosoftFonts)u.unmarshal(is);
        List<MicrosoftFonts.Font> msFontsList = msFonts.getFont();
        for (MicrosoftFonts.Font font : msFontsList) {
            msFontsByName.put(font.getName(), font);
        }
    }

    static {
        try {
            MicrosoftFontsRegistry.setupMicrosoftFontsRegistry();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }
}

