/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTLanguage;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.DocDefaults;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.TblPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyResolver {
    private static Logger log = LoggerFactory.getLogger(PropertyResolver.class);
    private PPr documentDefaultPPr;
    private RPr documentDefaultRPr;
    private StyleDefinitionsPart styleDefinitionsPart;
    private WordprocessingMLPackage wordMLPackage;
    private Styles styles;
    private Map<String, Style> liveStyles = null;
    private ThemePart themePart;
    private NumberingDefinitionsPart numberingDefinitionsPart;
    private Map<String, PPr> resolvedStylePPrComponent = new HashMap<String, PPr>();
    private Map<String, RPr> resolvedStyleRPrComponent = new HashMap<String, RPr>();
    CTLanguage themeFontLang = null;
    String defaultParagraphStyleId;
    String defaultCharacterStyleId;
    ObjectFactory factory = new ObjectFactory();
    private static final String HEADING_STYLE = "Heading";

    public RPr getDocumentDefaultRPr() {
        return this.documentDefaultRPr;
    }

    public PPr getDocumentDefaultPPr() {
        return this.documentDefaultPPr;
    }

    public PropertyResolver(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        this.wordMLPackage = wordMLPackage;
        MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();
        this.styleDefinitionsPart = mdp.getStyleDefinitionsPart(true);
        this.themePart = mdp.getThemePart();
        this.numberingDefinitionsPart = mdp.getNumberingDefinitionsPart();
        if (wordMLPackage.getMainDocumentPart().getDocumentSettingsPart() != null && wordMLPackage.getMainDocumentPart().getDocumentSettingsPart().getContents() != null) {
            this.themeFontLang = ((CTSettings)wordMLPackage.getMainDocumentPart().getDocumentSettingsPart().getContents()).getThemeFontLang();
        }
        this.init();
    }

    private void init() throws Docx4JException {
        try {
            this.defaultParagraphStyleId = this.styleDefinitionsPart.getDefaultParagraphStyle().getStyleId();
        }
        catch (NullPointerException npe) {
            log.warn("No default paragraph style!!");
        }
        try {
            this.defaultCharacterStyleId = this.styleDefinitionsPart.getDefaultCharacterStyle().getStyleId();
        }
        catch (NullPointerException npe) {
            log.warn("No default character style!!");
        }
        this.styles = (Styles)this.styleDefinitionsPart.getJaxbElement();
        this.initialiseLiveStyles();
        DocDefaults docDefaults = ((Styles)this.styleDefinitionsPart.getJaxbElement()).getDocDefaults();
        if (log.isDebugEnabled()) {
            log.debug(XmlUtils.marshaltoString((Object)docDefaults, true, true));
        }
        this.documentDefaultPPr = new PPr();
        this.documentDefaultRPr = new RPr();
        if (docDefaults != null && docDefaults.getPPrDefault() != null && docDefaults.getPPrDefault().getPPr() != null) {
            this.documentDefaultPPr = docDefaults.getPPrDefault().getPPr();
        }
        if (docDefaults != null && docDefaults.getRPrDefault() != null && docDefaults.getRPrDefault().getRPr() != null) {
            this.documentDefaultRPr = docDefaults.getRPrDefault().getRPr();
        }
        if (this.documentDefaultRPr.getSz() == null) {
            HpsMeasure sz20 = new HpsMeasure();
            sz20.setVal(BigInteger.valueOf(20L));
            this.documentDefaultRPr.setSz(sz20);
        }
        this.addNormalToResolvedStylePPrComponent();
        this.addDefaultParagraphFontToResolvedStyleRPrComponent();
    }

    private void addNormalToResolvedStylePPrComponent() {
        Stack<PPr> pPrStack = new Stack<PPr>();
        String styleId = this.defaultParagraphStyleId;
        this.fillPPrStack(styleId, pPrStack);
        pPrStack.push(this.documentDefaultPPr);
        PPr effectivePPr = this.factory.createPPr();
        while (!pPrStack.empty()) {
            PPr pPr = pPrStack.pop();
            this.applyPPr(pPr, effectivePPr);
        }
        this.resolvedStylePPrComponent.put(styleId, effectivePPr);
    }

    private void addDefaultParagraphFontToResolvedStyleRPrComponent() {
        Stack<RPr> rPrStack = new Stack<RPr>();
        this.fillRPrStack(this.defaultParagraphStyleId, rPrStack);
        this.fillRPrStack(this.defaultCharacterStyleId, rPrStack);
        rPrStack.push(this.documentDefaultRPr);
        RPr effectiveRPr = this.factory.createRPr();
        while (!rPrStack.empty()) {
            RPr rPr = rPrStack.pop();
            this.applyRPr(rPr, effectiveRPr);
        }
        this.resolvedStyleRPrComponent.put(this.defaultCharacterStyleId, effectiveRPr);
    }

    public Style getEffectiveTableStyle(TblPr tblPr) {
        Style result;
        Stack<Style> tableStyleStack = new Stack<Style>();
        if (tblPr != null && tblPr.getTblStyle() != null) {
            String styleId = tblPr.getTblStyle().getVal();
            log.debug("Table style: " + styleId);
            this.fillTableStyleStack(styleId, tableStyleStack);
        } else {
            log.debug("No table style specified");
        }
        if (tableStyleStack.size() > 0) {
            result = XmlUtils.deepCopy((Style)tableStyleStack.pop());
        } else {
            result = Context.getWmlObjectFactory().createStyle();
            CTTblPrBase emptyPr = Context.getWmlObjectFactory().createCTTblPrBase();
            result.setTblPr(emptyPr);
            if (tblPr == null) {
                log.info("Generated empty tblPr");
                return result;
            }
        }
        while (!tableStyleStack.empty()) {
            StyleUtil.apply(tableStyleStack.pop(), result);
        }
        result.setTblPr(StyleUtil.apply(tblPr, result.getTblPr()));
        if (result.getTblPr() == null) {
            log.error("Null tblPr. FIXME");
        }
        return result;
    }

    private void fillTableStyleStack(String styleId, Stack<Style> tableStyleStack) {
        Style style = this.liveStyles.get(styleId);
        if (style == null) {
            log.error("Style definition not found: " + styleId);
            return;
        }
        tableStyleStack.push(style);
        log.debug("Added " + styleId + " to table style stack");
        if (style.getBasedOn() == null) {
            log.debug("Style " + styleId + " is a root style.");
        } else if (style.getBasedOn().getVal() != null) {
            String basedOnStyleName = style.getBasedOn().getVal();
            this.fillTableStyleStack(basedOnStyleName, tableStyleStack);
        } else {
            log.debug("No basedOn set for: " + style.getStyleId());
        }
    }

    public PPr getEffectivePPr(PPr expressPPr) {
        String styleId;
        PPr effectivePPr = null;
        PPr resolvedPPr = null;
        if (expressPPr == null || expressPPr.getPStyle() == null) {
            styleId = this.defaultParagraphStyleId;
        } else {
            styleId = expressPPr.getPStyle().getVal();
            if (styleId == null) {
                if (log.isWarnEnabled()) {
                    log.warn("Missing style id: " + XmlUtils.marshaltoString(expressPPr));
                }
                if (log.isDebugEnabled()) {
                    Throwable t = new Throwable();
                    log.debug("Null styleId produced by code path", t);
                } else {
                    log.warn("Enable debug level logging to see code path");
                }
                styleId = this.defaultParagraphStyleId;
            }
        }
        resolvedPPr = this.getEffectivePPr(styleId);
        if (this.hasDirectPPrFormatting(expressPPr)) {
            if (resolvedPPr == null) {
                log.warn("resolvedPPr was null. Look into this?");
                effectivePPr = Context.getWmlObjectFactory().createPPr();
            } else {
                effectivePPr = XmlUtils.deepCopy(resolvedPPr);
            }
            this.applyPPr(expressPPr, effectivePPr);
            return effectivePPr;
        }
        return resolvedPPr;
    }

    public PPr getEffectivePPr(String styleId) {
        PPr resolvedPPr = this.resolvedStylePPrComponent.get(styleId);
        if (resolvedPPr != null) {
            return resolvedPPr;
        }
        Style s2 = this.liveStyles.get(styleId);
        if (s2 == null) {
            log.error("Couldn't find style: " + styleId);
            return null;
        }
        Stack<PPr> pPrStack = new Stack<PPr>();
        this.fillPPrStack(styleId, pPrStack);
        pPrStack.push(this.documentDefaultPPr);
        resolvedPPr = this.factory.createPPr();
        while (!pPrStack.empty()) {
            PPr pPr = pPrStack.pop();
            this.applyPPr(pPr, resolvedPPr);
        }
        this.resolvedStylePPrComponent.put(styleId, resolvedPPr);
        return resolvedPPr;
    }

    public RPr getEffectiveRPr(RPr expressRPr, PPr pPr) {
        if (pPr == null) {
            log.debug("pPr was null");
        } else {
            if (pPr.getPStyle() == null) {
                if (log.isDebugEnabled()) {
                    log.debug("No pstyle:");
                    log.debug(XmlUtils.marshaltoString((Object)pPr, true, true));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("pstyle:" + pPr.getPStyle().getVal());
                }
                RPr pPrLevelRunStyle = this.getEffectiveRPr(pPr.getPStyle().getVal());
                if (log.isDebugEnabled()) {
                    log.debug("Resulting pPrLevelRunStyle: " + XmlUtils.marshaltoString(pPrLevelRunStyle));
                }
                return this.getEffectiveRPrUsingPStyleRPr(expressRPr, pPrLevelRunStyle);
            }
            if (expressRPr == null && pPr.getRPr() != null && this.hasDirectRPrFormatting(pPr.getRPr())) {
                log.debug("No express rPr, using p level");
                return this.getEffectiveRPrUsingPStyleRPr(expressRPr, StyleUtil.apply(pPr.getRPr(), Context.getWmlObjectFactory().createRPr()));
            }
            log.debug("pPr not null, but falling through");
        }
        return this.getEffectiveRPrUsingPStyleRPr(expressRPr, null);
    }

    public RPr getEffectiveRPrUsingPStyleRPr(RPr expressRPr, RPr rPrFromPStyle) {
        log.debug("in getEffectiveRPrUsingPStyle");
        RPr effectiveRPr = null;
        if (this.documentDefaultRPr == null) {
            log.warn("documentDefaultRPr null");
            effectiveRPr = Context.getWmlObjectFactory().createRPr();
        } else {
            effectiveRPr = XmlUtils.deepCopy(this.documentDefaultRPr);
        }
        if (rPrFromPStyle != null) {
            effectiveRPr = StyleUtil.apply(rPrFromPStyle, effectiveRPr);
        }
        RPr resolvedRPr = null;
        if (expressRPr != null && expressRPr.getRStyle() != null) {
            String runStyleId = expressRPr.getRStyle().getVal();
            boolean rFontsMissing = effectiveRPr.getRFonts() == null;
            boolean szMissing = effectiveRPr.getSz() == null;
            boolean langMissing = effectiveRPr.getLang() == null;
            resolvedRPr = this.getEffectiveRPr(runStyleId, rFontsMissing, szMissing, langMissing);
            StyleUtil.apply(resolvedRPr, effectiveRPr);
        }
        if (this.hasDirectRPrFormatting(expressRPr)) {
            StyleUtil.apply(expressRPr, effectiveRPr);
        }
        return effectiveRPr;
    }

    public RPr getEffectiveRPr(String styleId) {
        return this.getEffectiveRPr(styleId, true, true, true);
    }

    public RPr getEffectiveRPr(String styleId, boolean applyDocDefaultsRFonts, boolean applyDocDefaultsSz, boolean applyDocDefaultsLang) {
        RPr resolvedRPr = this.resolvedStyleRPrComponent.get(styleId);
        if (resolvedRPr != null) {
            return resolvedRPr;
        }
        Style s2 = this.liveStyles.get(styleId);
        if (s2 == null) {
            log.error("Couldn't find style: " + styleId);
            log.debug("Couldn't find style: " + styleId, new Throwable());
            return null;
        }
        Stack<RPr> rPrStack = new Stack<RPr>();
        this.fillRPrStack(styleId, rPrStack);
        RPr defaultRPr = new RPr();
        if (applyDocDefaultsRFonts) {
            defaultRPr.setRFonts(this.documentDefaultRPr.getRFonts());
        }
        if (applyDocDefaultsSz) {
            defaultRPr.setSz(this.documentDefaultRPr.getSz());
            defaultRPr.setSzCs(this.documentDefaultRPr.getSzCs());
        }
        if (applyDocDefaultsLang) {
            defaultRPr.setLang(this.documentDefaultRPr.getLang());
        }
        rPrStack.push(defaultRPr);
        resolvedRPr = this.factory.createRPr();
        while (!rPrStack.empty()) {
            RPr rPr = rPrStack.pop();
            if (log.isDebugEnabled()) {
                log.debug("applying " + XmlUtils.marshaltoString(rPr));
            }
            this.applyRPr(rPr, resolvedRPr);
        }
        this.resolvedStyleRPrComponent.put(styleId, resolvedRPr);
        return resolvedRPr;
    }

    private BooleanDefaultTrue newBooleanDefaultTrue(boolean val) {
        BooleanDefaultTrue newBooleanDefaultTrue = this.factory.createBooleanDefaultTrue();
        newBooleanDefaultTrue.setVal(val);
        return newBooleanDefaultTrue;
    }

    private boolean hasDirectPPrFormatting(PPr pPrToApply) {
        if (pPrToApply == null) {
            return false;
        }
        if (pPrToApply.getBidi() != null) {
            return true;
        }
        if (pPrToApply.getKeepNext() != null) {
            return true;
        }
        if (pPrToApply.getKeepLines() != null) {
            return true;
        }
        if (pPrToApply.getPageBreakBefore() != null) {
            return true;
        }
        if (pPrToApply.getWidowControl() != null) {
            return true;
        }
        if (pPrToApply.getNumPr() != null) {
            return true;
        }
        if (pPrToApply.getSuppressLineNumbers() != null) {
            return true;
        }
        if (pPrToApply.getPBdr() != null) {
            return true;
        }
        if (pPrToApply.getShd() != null) {
            return true;
        }
        if (pPrToApply.getTabs() != null) {
            return true;
        }
        if (pPrToApply.getSpacing() != null) {
            return true;
        }
        if (pPrToApply.getInd() != null) {
            return true;
        }
        if (pPrToApply.getJc() != null) {
            return true;
        }
        if (pPrToApply.getTextAlignment() != null) {
            return true;
        }
        return pPrToApply.getOutlineLvl() != null;
    }

    protected void applyPPr(PPr pPrToApply, PPr effectivePPr) {
        if (log.isDebugEnabled()) {
            log.debug("apply " + XmlUtils.marshaltoString((Object)pPrToApply, true, true) + "\n\r to " + XmlUtils.marshaltoString((Object)effectivePPr, true, true));
        }
        StyleUtil.apply(pPrToApply, effectivePPr);
        if (log.isDebugEnabled()) {
            log.debug("result " + XmlUtils.marshaltoString((Object)effectivePPr, true, true));
        }
    }

    public boolean hasDirectRPrFormatting(RPr rPrToApply) {
        if (rPrToApply == null) {
            return false;
        }
        if (rPrToApply.getRFonts() != null) {
            return true;
        }
        if (rPrToApply.getB() != null) {
            return true;
        }
        if (rPrToApply.getI() != null) {
            return true;
        }
        if (rPrToApply.getCaps() != null) {
            return true;
        }
        if (rPrToApply.getSmallCaps() != null) {
            return true;
        }
        if (rPrToApply.getStrike() != null) {
            return true;
        }
        if (rPrToApply.getColor() != null) {
            return true;
        }
        if (rPrToApply.getSpacing() != null) {
            return true;
        }
        if (rPrToApply.getSz() != null) {
            return true;
        }
        if (rPrToApply.getHighlight() != null) {
            return true;
        }
        if (rPrToApply.getU() != null) {
            return true;
        }
        if (rPrToApply.getBdr() != null) {
            return true;
        }
        if (rPrToApply.getShd() != null) {
            return true;
        }
        if (rPrToApply.getVertAlign() != null) {
            return true;
        }
        return rPrToApply.getLang() != null;
    }

    private boolean hasDirectRPrFormatting(ParaRPr rPrToApply) {
        if (rPrToApply == null) {
            return false;
        }
        if (rPrToApply.getRFonts() != null) {
            return true;
        }
        if (rPrToApply.getB() != null) {
            return true;
        }
        if (rPrToApply.getI() != null) {
            return true;
        }
        if (rPrToApply.getCaps() != null) {
            return true;
        }
        if (rPrToApply.getSmallCaps() != null) {
            return true;
        }
        if (rPrToApply.getStrike() != null) {
            return true;
        }
        if (rPrToApply.getColor() != null) {
            return true;
        }
        if (rPrToApply.getSz() != null) {
            return true;
        }
        return rPrToApply.getU() != null;
    }

    protected void applyRPr(RPr rPrToApply, RPr effectiveRPr) {
        if (rPrToApply == null) {
            return;
        }
        StyleUtil.apply(rPrToApply, effectiveRPr);
    }

    protected void applyRPr(ParaRPr rPrToApply, RPr effectiveRPr) {
        if (rPrToApply == null) {
            return;
        }
        StyleUtil.apply(rPrToApply, effectiveRPr);
    }

    public int getLvlFromHeadingStyle(String style) {
        int level = -1;
        try {
            level = Integer.parseInt(style.substring(HEADING_STYLE.length(), style.length()).trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return level;
    }

    private void fillPPrStack(String styleId, Stack<PPr> pPrStack) {
        if (styleId == null) {
            if (log.isDebugEnabled()) {
                Throwable t = new Throwable();
                log.debug("Null styleId produced by code path", t);
            } else {
                log.warn("Null styleId; Enable debug level logging to see code path");
            }
            return;
        }
        Style style = this.liveStyles.get(styleId);
        if (style == null) {
            if (styleId == null || !styleId.equals("DocDefaults")) {
                log.error("Style definition not found: " + styleId);
            }
            return;
        }
        if (styleId.startsWith(HEADING_STYLE)) {
            int level = this.getLvlFromHeadingStyle(styleId);
            if (level > 0 && style.getPPr() != null && style.getPPr().getOutlineLvl() != null && style.getPPr().getOutlineLvl().getVal() != null && style.getPPr().getOutlineLvl().getVal().intValue() != level - 1) {
                log.info(styleId + " - reset actual outline level with " + (level - 1));
                style.getPPr().getOutlineLvl().setVal(BigInteger.valueOf(level - 1));
            }
            pPrStack.push(style.getPPr());
        } else {
            pPrStack.push(style.getPPr());
        }
        log.debug("Added " + styleId + " to pPr stack");
        boolean ascertainNumId = false;
        if (style.getPPr() != null && style.getPPr().getNumPr() != null && style.getPPr().getNumPr().getNumId() == null) {
            ascertainNumId = true;
            log.debug(styleId + " ascertainNumId: " + ascertainNumId);
        } else {
            log.debug(styleId + " ascertainNumId: " + ascertainNumId);
        }
        if (style.getBasedOn() == null) {
            log.debug("Style " + styleId + " is a root style.");
        } else if (style.getBasedOn().getVal() != null) {
            String basedOnStyleName = style.getBasedOn().getVal();
            log.debug("Style " + styleId + " is based on " + basedOnStyleName);
            this.fillPPrStack(basedOnStyleName, pPrStack);
            Style basedOnStyle = this.liveStyles.get(basedOnStyleName);
            if (ascertainNumId && basedOnStyle != null && basedOnStyle.getPPr() != null && basedOnStyle.getPPr().getNumPr() != null && basedOnStyle.getPPr().getNumPr().getNumId() != null) {
                PPrBase.NumPr.NumId numId = basedOnStyle.getPPr().getNumPr().getNumId();
                style.getPPr().getNumPr().setNumId(numId);
                log.info("Injected numId " + numId);
            }
        } else {
            log.debug("No basedOn set for: " + style.getStyleId());
        }
    }

    private void fillRPrStack(String styleId, Stack<RPr> rPrStack) {
        Style style = this.liveStyles.get(styleId);
        if (style == null) {
            log.error("Style definition not found: " + styleId);
            return;
        }
        rPrStack.push(style.getRPr());
        log.debug("Added " + styleId + " to rPr stack");
        if (style.getBasedOn() == null) {
            log.debug("Style " + styleId + " is a root style.");
        } else if (style.getBasedOn().getVal() != null) {
            String basedOnStyleName = style.getBasedOn().getVal();
            this.fillRPrStack(basedOnStyleName, rPrStack);
        } else {
            log.debug("No basedOn set for: " + style.getStyleId());
        }
    }

    private void initialiseLiveStyles() {
        log.debug("initialiseLiveStyles()");
        this.liveStyles = new HashMap<String, Style>();
        for (Style s2 : this.styles.getStyle()) {
            this.liveStyles.put(s2.getStyleId(), s2);
            log.debug("live style: " + s2.getStyleId());
        }
    }

    public boolean activateStyle(String styleId) {
        if (this.liveStyles.get(styleId) != null) {
            return true;
        }
        Map<String, Style> knownStyles = StyleDefinitionsPart.getKnownStyles();
        Style s2 = knownStyles.get(styleId);
        if (s2 == null) {
            log.error("Unknown style: " + styleId);
            return false;
        }
        return this.activateStyle(s2, false);
    }

    public boolean activateStyle(Style s2) {
        return this.activateStyle(s2, true);
    }

    private boolean activateStyle(Style s2, boolean replace) {
        boolean result1;
        if (this.liveStyles.get(s2.getStyleId()) != null) {
            if (!replace) {
                return false;
            }
            this.styles.getStyle().remove(this.liveStyles.get(s2.getStyleId()));
        }
        this.styles.getStyle().add(s2);
        this.liveStyles.put(s2.getStyleId(), s2);
        if (s2.getBasedOn() != null) {
            String basedOn = s2.getBasedOn().getVal();
            result1 = this.activateStyle(basedOn);
        } else if (s2.getStyleId().equals(this.defaultParagraphStyleId) || s2.getStyleId().equals(this.defaultCharacterStyleId)) {
            result1 = true;
        } else {
            log.debug(s2.getStyleId() + "  not w:basedOn anything, but that's ok");
            result1 = true;
        }
        boolean result2 = true;
        if (s2.getLink() != null) {
            Style.Link link = s2.getLink();
            result2 = this.activateStyle(link.getVal());
        }
        return result1 & result2;
    }

    public Style getStyle(String styleId) {
        return this.liveStyles.get(styleId);
    }
}

