/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.docx4j.Docx4jProperties;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.BookmarkRenumber;
import org.docx4j.model.datastorage.CustomXmlDataStoragePartSelector;
import org.docx4j.model.datastorage.DomToXPathMap;
import org.docx4j.model.datastorage.InputIntegrityException;
import org.docx4j.model.datastorage.W15RepeatZeroException;
import org.docx4j.model.datastorage.XPathEnhancerParser;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.opendope.JaxbCustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.w15.CTSdtRepeatedSection;
import org.docx4j.wml.CTDataBinding;
import org.docx4j.wml.CTLock;
import org.docx4j.wml.CTSdtCell;
import org.docx4j.wml.CTSdtRow;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Id;
import org.docx4j.wml.P;
import org.docx4j.wml.STLock;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtContent;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.SdtRun;
import org.docx4j.wml.Tag;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.opendope.components.Components;
import org.opendope.conditions.Condition;
import org.opendope.conditions.Conditions;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OpenDoPEHandler {
    private static Logger log = LoggerFactory.getLogger(OpenDoPEHandler.class);
    public static boolean ENABLE_XPATH_CACHE = true;
    private Map<String, Xpaths.Xpath> xpathsMap = null;
    private Map<String, Condition> conditionsMap = null;
    private DomToXPathMap domToXPathMap = null;
    private WordprocessingMLPackage wordMLPackage;
    private ShallowTraversor shallowTraversor;
    private BookmarkRenumber bookmarkRenumber;
    public static final String BINDING_ROLE_XPATH = "od:xpath";
    public static final String BINDING_ROLE_CONDITIONAL = "od:condition";
    public static final String BINDING_RESULT_CONDITION_FALSE = "od:resultConditionFalse";
    public static final String BINDING_ROLE_REPEAT = "od:repeat";
    public static final String BINDING_RESULT_RPTD_ZERO = "od:resultRepeatZero";
    public static final String BINDING_RESULT_RPTD_ZERO_W15 = "w15:resultRepeatZero";
    public static final String BINDING_RESULT_RPTD = "od:rptd";
    public static final String BINDING_ROLE_RPT_POS_CON = "od:RptPosCon";
    public static final String BINDING_ROLE_NARRATIVE = "od:narrative";
    public static final String BINDING_ROLE_COMPONENT = "od:component";
    public static final String BINDING_ROLE_COMPONENT_BEFORE = "od:continuousBefore";
    public static final String BINDING_ROLE_COMPONENT_AFTER = "od:continuousAfter";
    public static final String BINDING_ROLE_COMPONENT_CONTEXT = "od:context";
    public static final String BINDING_ROLE_FINISHER = "od:finish";
    public static final String BINDING_CONTENTTYPE = "od:ContentType";
    public static final String BINDING_HANDLER = "od:Handler";
    public static final String BINDING_PROGID = "od:progid";
    private Components components;
    private StringBuffer conditionTiming = new StringBuffer();
    private long conditionTimingTotal = 0L;
    boolean reverterSupported = Docx4jProperties.getProperty("docx4j.model.datastorage.OpenDoPEReverter.Supported", true);
    public long cloneTime = 0L;
    public long fixBTime = 0L;
    private int DEBUG_REPEAT_CAP = -1;
    private int totalRepeated = 0;

    public OpenDoPEHandler(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        this.wordMLPackage = wordMLPackage;
        if (wordMLPackage.getMainDocumentPart().getXPathsPart() == null) {
            log.info("OpenDoPE XPaths part missing (ok if you are just processing w15 repeatingSection)");
            this.xpathsMap = new HashMap<String, Xpaths.Xpath>();
        } else {
            Xpaths xPaths = (Xpaths)wordMLPackage.getMainDocumentPart().getXPathsPart().getJaxbElement();
            if (log.isDebugEnabled()) {
                log.debug(XmlUtils.marshaltoString((Object)xPaths, true, true));
            }
            this.xpathsMap = new HashMap<String, Xpaths.Xpath>(2 * xPaths.getXpath().size());
            for (Xpaths.Xpath xp : xPaths.getXpath()) {
                if (this.xpathsMap.put(xp.getId(), xp) == null) continue;
                log.error("Duplicates in XPaths part: " + xp.getId());
            }
        }
        if (wordMLPackage.getMainDocumentPart().getConditionsPart() != null) {
            Conditions conditions = (Conditions)wordMLPackage.getMainDocumentPart().getConditionsPart().getJaxbElement();
            if (log.isDebugEnabled()) {
                log.debug(XmlUtils.marshaltoString((Object)conditions, true, true));
            }
            this.conditionsMap = new HashMap<String, Condition>(2 * conditions.getCondition().size());
            for (Condition c : conditions.getCondition()) {
                if (this.conditionsMap.put(c.getId(), c) == null) continue;
                log.error("Duplicates in Conditions part: " + c.getId());
            }
        }
        if (wordMLPackage.getMainDocumentPart().getComponentsPart() != null) {
            this.components = (Components)wordMLPackage.getMainDocumentPart().getComponentsPart().getJaxbElement();
            if (log.isDebugEnabled()) {
                log.debug(XmlUtils.marshaltoString((Object)this.components, true, true));
            }
        }
        if (ENABLE_XPATH_CACHE) {
            CustomXmlPart cxp = CustomXmlDataStoragePartSelector.getCustomXmlDataStoragePart(wordMLPackage);
            if (cxp == null) {
                log.warn("No CustomXmlDataStoragePart found; can't cache.");
            } else if (cxp instanceof CustomXmlDataStoragePart) {
                CustomXmlDataStoragePart cdsp = (CustomXmlDataStoragePart)cxp;
                long start = System.currentTimeMillis();
                Document data = cdsp.getData().getDocument();
                this.domToXPathMap = new DomToXPathMap(data);
                this.domToXPathMap.map();
                long end = System.currentTimeMillis();
                long time = end - start;
                log.debug("Mapped " + this.domToXPathMap.getCountMap().size() + " in " + time + "ms");
            } else if (cxp instanceof JaxbCustomXmlDataStoragePart) {
                Document data = XmlUtils.neww3cDomDocument();
                try {
                    ((JaxbCustomXmlDataStoragePart)cxp).marshal(data);
                }
                catch (JAXBException e) {
                    throw new Docx4JException("Problem caching JaxbCustomXmlDataStoragePart", e);
                }
                this.domToXPathMap = new DomToXPathMap(data);
                this.domToXPathMap.map();
                log.debug("Mapped " + this.domToXPathMap.getCountMap().size());
            } else {
                log.warn("TODO: cache " + cxp.getClass().getName());
            }
        }
        this.shallowTraversor = new ShallowTraversor();
        this.shallowTraversor.wordMLPackage = wordMLPackage;
        this.bookmarkRenumber = new BookmarkRenumber(wordMLPackage);
    }

    public DomToXPathMap getDomToXPathMap() {
        return this.domToXPathMap;
    }

    public AtomicInteger getNextBookmarkId() {
        return this.bookmarkRenumber.getBookmarkId();
    }

    public WordprocessingMLPackage preprocess() throws Docx4JException {
        Set<ContentAccessor> partList = OpenDoPEHandler.getParts(this.wordMLPackage);
        try {
            for (ContentAccessor part : partList) {
                new TraversalUtil(part, this.shallowTraversor);
            }
        }
        catch (InputIntegrityException iie) {
            throw new Docx4JException(iie.getMessage(), iie);
        }
        if (this.wordMLPackage.getMainDocumentPart().getXPathsPart() == null) {
            log.info("No XPaths part; ok if you are just processing w15 repeatingSection");
        } else {
            ((Xpaths)this.wordMLPackage.getMainDocumentPart().getXPathsPart().getContents()).getXpath().clear();
            ((Xpaths)this.wordMLPackage.getMainDocumentPart().getXPathsPart().getContents()).getXpath().addAll(this.xpathsMap.values());
        }
        if (this.wordMLPackage.getMainDocumentPart().getConditionsPart() != null) {
            ((Conditions)this.wordMLPackage.getMainDocumentPart().getConditionsPart().getContents()).getCondition().clear();
            ((Conditions)this.wordMLPackage.getMainDocumentPart().getConditionsPart().getContents()).getCondition().addAll(this.conditionsMap.values());
        }
        log.debug(this.conditionTiming.toString());
        log.debug("conditions in total: " + this.conditionTimingTotal / 1000L);
        return this.wordMLPackage;
    }

    protected static Set<ContentAccessor> getParts(WordprocessingMLPackage srcPackage) {
        HashSet<ContentAccessor> partList = new HashSet<ContentAccessor>();
        partList.add(srcPackage.getMainDocumentPart());
        RelationshipsPart rp = srcPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                partList.add((HeaderPart)rp.getPart(r));
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            partList.add((FooterPart)rp.getPart(r));
        }
        return partList;
    }

    private CTSdtRepeatedSection getW15RepeatingSection(SdtPr sdtPr) {
        return (CTSdtRepeatedSection)sdtPr.getByClass(CTSdtRepeatedSection.class);
    }

    private List<Object> processBindingRoleIfAny(WordprocessingMLPackage wordMLPackage, Object sdt) {
        Tag tag;
        Id id = OpenDoPEHandler.getSdtPr(sdt).getId();
        if (id != null) {
            log.debug("Processing " + id.getVal());
        }
        if ((tag = OpenDoPEHandler.getSdtPr(sdt).getTag()) == null) {
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(sdt);
            return newContent;
        }
        log.info(tag.getVal());
        HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
        String conditionId = map.get(BINDING_ROLE_CONDITIONAL);
        String repeatId = map.get(BINDING_ROLE_REPEAT);
        String xp = map.get(BINDING_ROLE_XPATH);
        if (conditionId == null && repeatId == null && xp == null) {
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(sdt);
            return newContent;
        }
        HashMap<String, CustomXmlPart> customXmlDataStorageParts = wordMLPackage.getCustomXmlDataStorageParts();
        if (conditionId != null) {
            log.info("Processing Conditional: " + tag.getVal());
            Condition c = this.conditionsMap.get(conditionId);
            if (c == null) {
                log.error("Missing condition " + conditionId);
            }
            long startTime = System.currentTimeMillis();
            c.setDomToXPathMap(this.domToXPathMap);
            boolean cResult = c.evaluate(wordMLPackage, customXmlDataStorageParts, this.conditionsMap, this.xpathsMap);
            long duration = System.currentTimeMillis() - startTime;
            this.conditionTimingTotal += duration;
            if (log.isDebugEnabled() && duration > 750L) {
                this.conditionTiming.append(c.toString(this.conditionsMap, this.xpathsMap) + "," + duration + "\n");
            }
            if (cResult) {
                log.debug("so keeping");
                ArrayList<Object> newContent = new ArrayList<Object>();
                newContent.add(sdt);
                return newContent;
            }
            if (this.reverterSupported) {
                log.debug("false");
                return this.conditionFalse(sdt);
            }
            log.debug("false");
            return new ArrayList<Object>();
        }
        if (repeatId != null) {
            log.info("Processing OpenDoPE Repeat: " + tag.getVal());
            return this.processOpenDopeRepeat(sdt, customXmlDataStorageParts);
        }
        if (xp != null) {
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(sdt);
            return newContent;
        }
        return null;
    }

    private List<Object> conditionFalse(Object sdt) {
        ArrayList<Object> newContent = new ArrayList<Object>();
        newContent.add(sdt);
        SdtPr sdtPr = OpenDoPEHandler.getSdtPr(sdt);
        CTDataBinding binding = sdtPr.getDataBinding();
        if (binding != null) {
            sdtPr.getRPrOrAliasOrLock().remove(binding);
        }
        Tag tag = sdtPr.getTag();
        String tagVal = tag.getVal();
        Pattern stripConditionArgPattern = Pattern.compile("(.*od:condition=)([^&]*)(.*)");
        Matcher stripPatternMatcher = stripConditionArgPattern.matcher(tagVal);
        if (!stripPatternMatcher.matches()) {
            log.error("Cannot find condition tag in sdtPr/tag while setting conditionFalse; something is wrong with " + tagVal);
            return newContent;
        }
        String emptyConditionValue = "od:resultConditionFalse=" + stripPatternMatcher.group(2) + stripPatternMatcher.group(3);
        tag.setVal(emptyConditionValue);
        CTLock lock = Context.getWmlObjectFactory().createCTLock();
        lock.setVal(STLock.SDT_CONTENT_LOCKED);
        JAXBElement<CTLock> lockWrapped = Context.getWmlObjectFactory().createSdtPrLock(lock);
        sdtPr.getRPrOrAliasOrLock().add(lockWrapped);
        TableObjectFinder tableObjectFinder = new TableObjectFinder();
        new TraversalUtil(((SdtElement)sdt).getSdtContent().getContent(), tableObjectFinder);
        if (tableObjectFinder.result == null) {
            ((SdtElement)sdt).getSdtContent().getContent().clear();
        } else if (tableObjectFinder.result instanceof Tbl) {
            ((SdtElement)sdt).getSdtContent().getContent().clear();
        } else if (tableObjectFinder.result instanceof Tr) {
            ((SdtElement)sdt).getSdtContent().getContent().clear();
        } else if (tableObjectFinder.result instanceof Tc) {
            Tc tc = (Tc)tableObjectFinder.result;
            tc.getContent().clear();
            P p = Context.getWmlObjectFactory().createP();
            tc.getContent().add(p);
            ((SdtElement)sdt).getSdtContent().getContent().clear();
            ((SdtElement)sdt).getSdtContent().getContent().add(tc);
        } else {
            log.error("unexpected encountered " + tableObjectFinder.result.getClass().getName());
        }
        return newContent;
    }

    private List<Object> processOpenDopeRepeat(Object sdt, Map<String, CustomXmlPart> customXmlDataStorageParts) {
        Tag tag = OpenDoPEHandler.getSdtPr(sdt).getTag();
        HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
        String repeatId = map.get(BINDING_ROLE_REPEAT);
        if (StringUtils.isEmpty(repeatId)) {
            return new ArrayList<Object>();
        }
        Xpaths.Xpath xpathObj = this.xpathsMap.get(repeatId);
        if (xpathObj == null) {
            log.error("repeat " + repeatId + " is missing from xpaths");
            throw new RuntimeException("repeat " + repeatId + " is missing from xpaths");
        }
        String storeItemId = xpathObj.getDataBinding().getStoreItemID();
        String xpath = xpathObj.getDataBinding().getXpath();
        String prefixMappings = xpathObj.getDataBinding().getPrefixMappings();
        try {
            return this.processRepeat(sdt, customXmlDataStorageParts, storeItemId, xpath, prefixMappings, false);
        }
        catch (W15RepeatZeroException w15) {
            return null;
        }
    }

    private List<Object> processW15Repeat(Object repeatingSectionSdt, Map<String, CustomXmlPart> customXmlDataStorageParts) {
        CTDataBinding w15Databinding = OpenDoPEHandler.getSdtPr(repeatingSectionSdt).getDataBinding();
        String storeItemId = w15Databinding.getStoreItemID();
        String xpath = w15Databinding.getXpath();
        String prefixMappings = w15Databinding.getPrefixMappings();
        SdtContent ca = ((SdtElement)repeatingSectionSdt).getSdtContent();
        SdtElement repeatingItem = (SdtElement)XmlUtils.unwrap(ca.getContent().get(0));
        try {
            List<Object> repeatingSectionItems = this.processRepeat(repeatingItem, customXmlDataStorageParts, storeItemId, xpath, prefixMappings, true);
            ca.getContent().clear();
            ca.getContent().addAll(repeatingSectionItems);
        }
        catch (W15RepeatZeroException w15) {
            log.warn(w15.getMessage());
            SdtPr sdtPr = OpenDoPEHandler.getSdtPr(repeatingSectionSdt);
            Tag tag = new Tag();
            tag.setVal("w15:resultRepeatZero=true");
            sdtPr.setTag(tag);
        }
        ArrayList<Object> newContent = new ArrayList<Object>();
        newContent.add(repeatingSectionSdt);
        return newContent;
    }

    protected static String getRepeatXpathBase(String xpath) {
        String xpathBase = xpath.endsWith("/") ? xpath.substring(0, xpath.length() - 1) : (xpath.endsWith("[1]") ? xpath.substring(0, xpath.length() - 3) : xpath);
        if (log.isDebugEnabled()) {
            log.debug("-> " + xpathBase);
        }
        return xpathBase;
    }

    private List<Object> processRepeat(Object sdt, Map<String, CustomXmlPart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, boolean isW15RepeatingSection) throws W15RepeatZeroException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug("/n/n Repeat: " + xpath);
            log.debug("   " + xpath);
        }
        long startTime = System.currentTimeMillis();
        String xpathBase = OpenDoPEHandler.getRepeatXpathBase(xpath);
        String countPath = null;
        Integer numRepeats = null;
        if (this.domToXPathMap != null) {
            countPath = xpathBase.replace("][1]", "]");
            if (log.isDebugEnabled()) {
                log.debug("-> " + countPath);
            }
            if (countPath.endsWith("*")) {
                log.debug("ends with * in " + countPath);
                String tmpPath2 = countPath.substring(0, countPath.lastIndexOf("/"));
                log.debug("so lookup " + tmpPath2);
                numRepeats = this.domToXPathMap.getCountMap().get("_all_" + tmpPath2);
                log.debug(" .. result " + numRepeats);
            } else if (countPath.contains("*")) {
                log.debug("skipping domToXPathMap.getCountMap() for " + countPath);
            } else {
                log.debug("skipping domToXPathMap.getCountMap() for " + countPath);
            }
        }
        if (numRepeats == null || log.isDebugEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("debug enabled, so instead of countMap for {}, query {} ", (Object)countPath, (Object)xpathBase);
            } else {
                log.info("countMap null for {}, so query {} ", (Object)countPath, (Object)xpathBase);
            }
            List<Node> repeatedSiblings = this.xpathGetNodes(customXmlDataStorageParts, storeItemId, xpathBase, prefixMappings);
            if (numRepeats != null && numRepeats.intValue() != repeatedSiblings.size()) {
                String message = "For " + xpathBase + ", " + numRepeats + "!=" + repeatedSiblings.size();
                log.error(message);
                throw new RuntimeException(message);
            }
            numRepeats = repeatedSiblings.size();
        }
        if (log.isDebugEnabled()) {
            log.debug("yields REPEATS: " + xpathBase + ":" + numRepeats);
        }
        if (numRepeats == 0) {
            if (isW15RepeatingSection) {
                throw new W15RepeatZeroException("Zero repeats found for " + xpathBase + "; leaving existing content (as Word does)!");
            }
            if (this.reverterSupported) {
                return this.repeatZero(sdt);
            }
            return new ArrayList<Object>();
        }
        List<Object> repeated = this.cloneRepeatSdt(sdt, xpathBase, numRepeats);
        this.cloneTime += System.currentTimeMillis() - startTime;
        startTime = System.currentTimeMillis();
        DeepTraversor dt = new DeepTraversor();
        dt.xpathBase = xpathBase;
        for (i = 0; i < repeated.size(); ++i) {
            log.info("\n Traversing clone " + i);
            dt.index = i;
            new TraversalUtil(repeated.get(i), dt);
        }
        log.info(".. deep traversals done \n\n");
        this.fixBTime += System.currentTimeMillis() - startTime;
        for (i = 0; i < repeated.size(); ++i) {
            try {
                Id id = ((SdtElement)repeated.get(i)).getSdtPr().getId();
                if (id == null) {
                    ((SdtElement)repeated.get(i)).getSdtPr().setId();
                    id = ((SdtElement)repeated.get(i)).getSdtPr().getId();
                }
                long global = id.getVal().longValue();
                this.bookmarkRenumber.fixRange(((SdtElement)repeated.get(i)).getSdtContent().getContent(), "CTBookmark", "CTMarkupRange", null, global, i);
                continue;
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
        return repeated;
    }

    private List<Object> repeatZero(Object sdt) {
        ArrayList<Object> newContent = new ArrayList<Object>();
        newContent.add(sdt);
        SdtPr sdtPr = OpenDoPEHandler.getSdtPr(sdt);
        CTDataBinding binding = sdtPr.getDataBinding();
        if (binding != null) {
            sdtPr.getRPrOrAliasOrLock().remove(binding);
        }
        Tag tag = sdtPr.getTag();
        String tagVal = tag.getVal();
        Pattern stripRepeatArgPattern = Pattern.compile("(.*od:repeat=)([^&]*)(.*)");
        Matcher stripPatternMatcher = stripRepeatArgPattern.matcher(tagVal);
        if (!stripPatternMatcher.matches()) {
            log.error("Cannot find repeat tag in sdtPr/tag while processing repeat; something is wrong with " + tagVal);
            return newContent;
        }
        String emptyRepeatValue = "od:resultRepeatZero=" + stripPatternMatcher.group(2) + stripPatternMatcher.group(3);
        tag.setVal(emptyRepeatValue);
        CTLock lock = Context.getWmlObjectFactory().createCTLock();
        lock.setVal(STLock.SDT_CONTENT_LOCKED);
        JAXBElement<CTLock> lockWrapped = Context.getWmlObjectFactory().createSdtPrLock(lock);
        sdtPr.getRPrOrAliasOrLock().add(lockWrapped);
        TableObjectFinder tableObjectFinder = new TableObjectFinder();
        new TraversalUtil(((SdtElement)sdt).getSdtContent().getContent(), tableObjectFinder);
        if (tableObjectFinder.result == null) {
            ((SdtElement)sdt).getSdtContent().getContent().clear();
        } else if (tableObjectFinder.result instanceof Tbl) {
            ((SdtElement)sdt).getSdtContent().getContent().clear();
        } else if (tableObjectFinder.result instanceof Tr) {
            ((SdtElement)sdt).getSdtContent().getContent().clear();
        } else if (tableObjectFinder.result instanceof Tc) {
            Tc tc = (Tc)tableObjectFinder.result;
            tc.getContent().clear();
            P p = Context.getWmlObjectFactory().createP();
            tc.getContent().add(p);
            ((SdtElement)sdt).getSdtContent().getContent().clear();
            ((SdtElement)sdt).getSdtContent().getContent().add(tc);
        } else {
            log.error("unexpected encountered " + tableObjectFinder.result.getClass().getName());
        }
        return newContent;
    }

    private List<Object> cloneRepeatSdt(Object sdt, String xpathBase, int numRepeats) {
        CTDataBinding binding;
        ArrayList<Object> newContent = new ArrayList<Object>();
        SdtPr sdtPr = OpenDoPEHandler.getSdtPr(sdt);
        if (log.isDebugEnabled()) {
            log.debug(XmlUtils.marshaltoString((Object)sdtPr, true, true));
        }
        if ((binding = sdtPr.getDataBinding()) != null) {
            sdtPr.getRPrOrAliasOrLock().remove(binding);
        }
        this.emptyRepeatTagValue(sdtPr.getTag());
        if (this.DEBUG_REPEAT_CAP > 0 && this.DEBUG_REPEAT_CAP < numRepeats) {
            log.warn("Capping repeats at " + this.DEBUG_REPEAT_CAP + "(down from " + numRepeats);
            numRepeats = this.DEBUG_REPEAT_CAP;
        }
        for (int i = 0; i < numRepeats; ++i) {
            if (i > 0) {
                sdtPr.setId();
            }
            newContent.add(XmlUtils.deepCopy(sdt));
            ++this.totalRepeated;
        }
        if (log.isDebugEnabled()) {
            log.debug("Repeated in total so far: " + this.totalRepeated);
        }
        return newContent;
    }

    private void emptyRepeatTagValue(Tag tag) {
        if (tag == null) {
            log.warn("No tag");
            return;
        }
        String tagVal = tag.getVal();
        Pattern stripRepeatArgPattern = Pattern.compile("(.*od:repeat=)([^&]*)(.*)");
        Matcher stripPatternMatcher = stripRepeatArgPattern.matcher(tagVal);
        if (!stripPatternMatcher.matches()) {
            log.error("Cannot find repeat tag in sdtPr/tag while processing repeat; something is wrong with " + tagVal);
            return;
        }
        String emptyRepeatValue = "od:rptd=" + stripPatternMatcher.group(2) + stripPatternMatcher.group(3);
        tag.setVal(emptyRepeatValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processDescendantBindings(Object sdt, String xpathBase, int index) {
        SdtPr sdtPr = OpenDoPEHandler.getSdtPr(sdt);
        sdtPr.setId();
        CTDataBinding binding = sdtPr.getDataBinding();
        String thisXPath = null;
        String conditionId = null;
        String repeatId = null;
        String bindingId = null;
        Xpaths.Xpath xpathObj = null;
        HashMap<Object, Object> map = null;
        Tag tag = sdtPr.getTag();
        map = tag == null ? new HashMap() : QueryString.parseQueryString(tag.getVal(), true);
        if (binding == null) {
            conditionId = (String)map.get(BINDING_ROLE_CONDITIONAL);
            repeatId = (String)map.get(BINDING_ROLE_REPEAT);
            if (conditionId != null) {
                this.processDescendantCondition(sdt, xpathBase, index, tag);
                return;
            }
            if (repeatId != null) {
                xpathObj = this.xpathsMap.get(repeatId);
                if (xpathObj == null) {
                    log.warn("couldn't find repeat " + repeatId);
                }
                thisXPath = xpathObj.getDataBinding().getXpath();
            } else {
                if (!(map.containsKey(BINDING_CONTENTTYPE) || map.containsKey(BINDING_HANDLER) || map.containsKey(BINDING_PROGID))) {
                    log.warn("couldn't find binding or bindingrole!");
                    return;
                }
                xpathObj = this.xpathsMap.get(map.get(BINDING_ROLE_XPATH));
                if (xpathObj == null) {
                    log.warn("couldn't find xpath " + (String)map.get(BINDING_ROLE_XPATH));
                }
                thisXPath = xpathObj.getDataBinding().getXpath();
            }
        } else {
            thisXPath = binding.getXpath();
            bindingId = (String)map.get(BINDING_ROLE_XPATH);
            try {
                xpathObj = this.xpathsMap.get(bindingId);
            }
            catch (InputIntegrityException iie) {
                log.warn(iie.getMessage());
            }
            if (xpathObj == null) {
                log.warn("No XPaths part object for " + binding.getXpath());
            } else if (!thisXPath.equals(xpathObj.getDataBinding().getXpath())) {
                log.error("XPaths didn't match for id " + bindingId + ": \n\r    " + thisXPath + "\n\rcf. " + xpathObj.getDataBinding().getXpath());
            }
        }
        String newPath = XPathEnhancerParser.enhanceXPath(xpathBase, index + 1, thisXPath);
        if (log.isDebugEnabled() && !thisXPath.equals(newPath)) {
            log.debug("xpath prefix enhanced " + thisXPath + " to " + newPath);
        }
        if (binding == null) {
            if (repeatId != null) {
                Xpaths.Xpath newXPathObj = this.createNewXPathObject(newPath, xpathObj, index);
                map.put(BINDING_ROLE_REPEAT, newXPathObj.getId());
                tag.setVal(QueryString.create(map));
                return;
            }
            if (!map.containsKey(BINDING_CONTENTTYPE) && !map.containsKey(BINDING_HANDLER)) {
                if (!map.containsKey(BINDING_PROGID)) return;
            }
            Xpaths.Xpath newXPathObj = this.createNewXPathObject(newPath, xpathObj, index);
            map.put(BINDING_ROLE_XPATH, newXPathObj.getId());
            tag.setVal(QueryString.create(map));
            return;
        }
        binding.setXpath(newPath);
        if (xpathObj == null) {
            log.debug("Not setting tag");
            return;
        }
        Xpaths.Xpath newXPathObj = this.createNewXPathObject(newPath, xpathObj, index);
        map.put(BINDING_ROLE_XPATH, newXPathObj.getId());
        tag.setVal(QueryString.create(map));
    }

    private void processDescendantCondition(Object sdt, String xpathBase, int index, Tag tag) {
        Condition c = null;
        HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
        String conditionId = map.get(BINDING_ROLE_CONDITIONAL);
        if (conditionId != null) {
            c = this.conditionsMap.get(conditionId);
            if (c == null) {
                log.error("Missing condition " + conditionId);
                throw new InputIntegrityException("Required condition '" + conditionId + "' is missing");
            }
            if (log.isDebugEnabled()) {
                log.debug("Using condition" + XmlUtils.marshaltoString((Object)c, true, true));
            }
            Condition newCondition = c.repeat(xpathBase, index, this.conditionsMap, this.xpathsMap);
            map.put(BINDING_ROLE_CONDITIONAL, newCondition.getId());
            tag.setVal(QueryString.create(map));
        }
    }

    private Xpaths.Xpath createNewXPathObject(String newPath, Xpaths.Xpath xpathObj, int index) {
        Xpaths.Xpath newXPathObj = new Xpaths.Xpath();
        String newXPathId = xpathObj.getId() + "_" + index;
        newXPathObj.setId(newXPathId);
        Xpaths.Xpath.DataBinding dataBinding = new Xpaths.Xpath.DataBinding();
        newXPathObj.setDataBinding(dataBinding);
        dataBinding.setXpath(newPath);
        dataBinding.setStoreItemID(xpathObj.getDataBinding().getStoreItemID());
        dataBinding.setPrefixMappings(xpathObj.getDataBinding().getPrefixMappings());
        Xpaths.Xpath oldKey = this.xpathsMap.put(newXPathId, newXPathObj);
        if (oldKey != null) {
            if (oldKey.getDataBinding().getXpath().equals(newPath)) {
                if (log.isDebugEnabled()) {
                    log.debug("New xpath entry overwrites existing identical xpath " + newXPathId);
                }
            } else {
                log.warn("New xpath entry overwrites existing different xpath " + newXPathId);
                log.warn("Old: " + oldKey.getDataBinding().getXpath());
                log.warn("New: " + newPath);
            }
        }
        return newXPathObj;
    }

    public static SdtPr getSdtPr(Object o) {
        if (o instanceof SdtBlock) {
            return ((SdtBlock)o).getSdtPr();
        }
        if (o instanceof SdtRun) {
            return ((SdtRun)o).getSdtPr();
        }
        if (o instanceof CTSdtRow) {
            return ((CTSdtRow)o).getSdtPr();
        }
        if (o instanceof CTSdtCell) {
            return ((CTSdtCell)o).getSdtPr();
        }
        log.warn("TODO: Handle " + o.getClass().getName());
        return null;
    }

    private List<Node> xpathGetNodes(Map<String, CustomXmlPart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings) {
        CustomXmlPart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
        if (part == null) {
            log.error("Couldn't locate part by storeItemId " + storeItemId);
            return null;
        }
        try {
            return part.xpathGetNodes(xpath, prefixMappings);
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    private class ShallowTraversor
    implements TraversalUtil.Callback {
        WordprocessingMLPackage wordMLPackage;

        private ShallowTraversor() {
        }

        @Override
        public List<Object> apply(Object wrapped) throws RuntimeException {
            Object o = XmlUtils.unwrap(wrapped);
            if (o instanceof SdtBlock || o instanceof SdtRun || o instanceof CTSdtRow || o instanceof CTSdtCell) {
                SdtPr sdtPr = OpenDoPEHandler.getSdtPr(o);
                if (sdtPr.getDataBinding() == null) {
                    return OpenDoPEHandler.this.processBindingRoleIfAny(this.wordMLPackage, o);
                }
                if (OpenDoPEHandler.this.getW15RepeatingSection(sdtPr) != null) {
                    return OpenDoPEHandler.this.processW15Repeat(o, this.wordMLPackage.getCustomXmlDataStorageParts());
                }
            }
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(wrapped);
            return newContent;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return true;
        }

        @Override
        public List<Object> getChildren(Object o) {
            return TraversalUtil.getChildrenImpl(o);
        }

        @Override
        public void walkJAXBElements(Object parent) {
            ArrayList<Object> newChildren = new ArrayList<Object>();
            Object parentUnwrapped = XmlUtils.unwrap(parent);
            List<Object> children = this.getChildren(parentUnwrapped);
            if (children == null) {
                return;
            }
            for (Object o : children) {
                newChildren.addAll(this.apply(o));
            }
            TraversalUtil.replaceChildren(parentUnwrapped, newChildren);
            children = this.getChildren(parentUnwrapped);
            if (children == null) {
                log.debug("no children: " + parentUnwrapped.getClass().getName());
            } else {
                for (Object o : children) {
                    if (!this.shouldTraverse(o)) continue;
                    this.walkJAXBElements(o);
                }
            }
        }
    }

    private static class TableObjectFinder
    extends TraversalUtil.CallbackImpl {
        public Object result;

        private TableObjectFinder() {
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof Tbl || o instanceof Tr || o instanceof Tc) {
                this.result = o;
            }
            return null;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return this.result == null;
        }
    }

    class DeepTraversor
    extends TraversalUtil.CallbackImpl {
        int index = 0;
        String xpathBase = null;

        DeepTraversor() {
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof SdtBlock || o instanceof SdtRun || o instanceof CTSdtRow || o instanceof CTSdtCell) {
                OpenDoPEHandler.this.processDescendantBindings(o, this.xpathBase, this.index);
            }
            return null;
        }
    }
}

