/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.table;

import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.table.TableModel;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableModelCell {
    private static final Logger logger = LoggerFactory.getLogger(TableModelCell.class);
    private TableModel table;
    private int row;
    private int col;
    protected int rowspan = 0;
    private int colspan = 0;
    protected boolean dummy = false;
    protected boolean dummyBefore = false;
    protected boolean dummyAfter = false;
    protected TcPr tcPr;

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    public boolean isDummyBefore() {
        return this.dummyBefore;
    }

    public boolean isDummyAfter() {
        return this.dummyAfter;
    }

    public TcPr getTcPr() {
        return this.tcPr;
    }

    public TableModelCell(TableModel table, int row, int col) {
        this.table = table;
        this.row = row;
        this.col = col;
        this.dummy = true;
    }

    public TableModelCell(TableModel table, int row, int col, Tc tc) {
        this(table, row, col);
        this.dummy = false;
        this.tcPr = tc.getTcPr();
        if (this.tcPr != null && logger.isDebugEnabled()) {
            logger.debug("Cell props for row " + row + ", col " + col + "\n" + XmlUtils.marshaltoString(this.tcPr, true, true, Context.jc, "http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tcPr", TcPr.class));
        }
        try {
            String vm = tc.getTcPr().getVMerge().getVal();
            if (vm == null || vm.equals("continue")) {
                this.dummy = true;
            }
            this.incrementRowSpan();
        }
        catch (NullPointerException vm) {
            // empty catch block
        }
        if (this.dummy) {
            try {
                this.colspan = table.getCell((int)(row - 1), (int)col).colspan;
            }
            catch (NullPointerException ne) {
                logger.warn("Problem at row " + row + " -1, col " + col);
                logger.warn("model so far: \n" + this.table.debugStr());
                logger.warn("and this cell: " + this.debugStr());
                logger.warn(ne.getMessage(), ne);
                logger.warn("Problems with table " + XmlUtils.marshaltoString(table.tbl));
            }
        } else {
            try {
                int gridSpan;
                this.colspan = gridSpan = tc.getTcPr().getGridSpan().getVal().intValue();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public int getExtraCols() {
        if (this.getColspan() < 2) {
            return 0;
        }
        return this.getColspan() - 1;
    }

    public int getExtraRows() {
        if (this.rowspan > 1) {
            return this.rowspan - 1;
        }
        return 0;
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public int getColumn() {
        return this.col;
    }

    protected void incrementRowSpan() {
        if (this.dummy) {
            logger.debug("dummy=true for row " + this.row + ", col " + this.col + " so propogate to r-1");
            if (this.row > 0) {
                this.table.getCell(this.row - 1, this.col).incrementRowSpan();
            } else {
                logger.debug(".. but already at row 0; using rowspan=" + this.rowspan);
            }
        } else {
            logger.debug("incremented rowspan for row " + this.row + ", col " + this.col);
            ++this.rowspan;
        }
    }

    public String debugStr() {
        Object s2 = null;
        s2 = this.dummy ? "d" : "r";
        s2 = (String)s2 + "(" + this.row + "," + this.col + ")";
        s2 = (String)s2 + this.getColspan();
        s2 = (String)s2 + this.rowspan;
        return (String)s2 + " ";
    }

    public boolean isVMerged() {
        return this.tcPr != null && this.tcPr.getVMerge() != null;
    }
}

