/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.packages;

import jakarta.xml.bind.JAXBElement;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.HashMap;
import org.docx4j.TextUtils;
import org.docx4j.convert.in.FlatOpcXmlImporter;
import org.docx4j.convert.out.flatOpcXml.FlatOpcXmlCreator;
import org.docx4j.docProps.core.CoreProperties;
import org.docx4j.docProps.core.dc.elements.ObjectFactory;
import org.docx4j.docProps.core.dc.elements.SimpleLiteral;
import org.docx4j.docProps.extended.Properties;
import org.docx4j.events.EventFinished;
import org.docx4j.events.PackageIdentifier;
import org.docx4j.events.PackageIdentifierTransient;
import org.docx4j.events.StartEvent;
import org.docx4j.events.WellKnownProcessSteps;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.PackageRelsUtil;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.io3.Load3;
import org.docx4j.openpackaging.io3.Save;
import org.docx4j.openpackaging.io3.stores.PartStore;
import org.docx4j.openpackaging.io3.stores.ZipPartStore;
import org.docx4j.openpackaging.packages.Filetype;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.ExternalTarget;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.Parts;
import org.docx4j.openpackaging.parts.WordprocessingML.DrawingPropsIdTracker;
import org.docx4j.org.apache.poi.poifs.crypt.Decryptor;
import org.docx4j.org.apache.poi.poifs.crypt.EncryptionInfo;
import org.docx4j.org.apache.poi.poifs.crypt.EncryptionMode;
import org.docx4j.org.apache.poi.poifs.crypt.Encryptor;
import org.docx4j.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OpcPackage
extends Base
implements PackageIdentifier {
    private static Logger log = LoggerFactory.getLogger(OpcPackage.class);
    public HashMap<String, String> handled = new HashMap();
    protected Parts parts = new Parts();
    private DrawingPropsIdTracker drawingPropsIdTracker = null;
    protected HashMap<ExternalTarget, Part> externalResources = new HashMap();
    protected HashMap<String, CustomXmlPart> customXmlDataStorageParts = new HashMap();
    protected ContentTypeManager contentTypeManager;
    private PartStore sourcePartStore;
    private PartStore targetPartStore;
    protected DocPropsCorePart docPropsCorePart;
    protected DocPropsExtendedPart docPropsExtendedPart;
    protected DocPropsCustomPart docPropsCustomPart;
    boolean isNew = true;
    private String name;

    public Parts getParts() {
        return this.parts;
    }

    public DrawingPropsIdTracker getDrawingPropsIdTracker() {
        if (this.drawingPropsIdTracker == null) {
            this.drawingPropsIdTracker = new DrawingPropsIdTracker();
        }
        return this.drawingPropsIdTracker;
    }

    public HashMap<ExternalTarget, Part> getExternalResources() {
        return this.externalResources;
    }

    public HashMap<String, CustomXmlPart> getCustomXmlDataStorageParts() {
        return this.customXmlDataStorageParts;
    }

    public ContentTypeManager getContentTypeManager() {
        return this.contentTypeManager;
    }

    public void setContentTypeManager(ContentTypeManager contentTypeManager) {
        this.contentTypeManager = contentTypeManager;
    }

    public PartStore getSourcePartStore() {
        return this.sourcePartStore;
    }

    public void setSourcePartStore(PartStore partStore) {
        this.sourcePartStore = partStore;
    }

    public PartStore getTargetPartStore() {
        return this.targetPartStore;
    }

    public void setTargetPartStore(PartStore partStore) {
        this.targetPartStore = partStore;
    }

    public OpcPackage() {
        try {
            this.setPartName(new PartName("/", false));
            this.contentTypeManager = new ContentTypeManager();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public OpcPackage(ContentTypeManager contentTypeManager) {
        try {
            this.setPartName(new PartName("/", false));
            this.contentTypeManager = contentTypeManager;
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public OpcPackage getPackage() {
        return this;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public static OpcPackage load(PackageIdentifier pkgIdentifier, File docxFile) throws Docx4JException {
        return OpcPackage.load(pkgIdentifier, docxFile, null);
    }

    public static OpcPackage load(File docxFile) throws Docx4JException {
        return OpcPackage.load(docxFile, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpcPackage load(File docxFile, String password) throws Docx4JException {
        OpcPackage opcPackage;
        PackageIdentifierTransient name = new PackageIdentifierTransient(docxFile.getName());
        FileInputStream fileInputStream = new FileInputStream(docxFile);
        try {
            opcPackage = OpcPackage.load((PackageIdentifier)name, fileInputStream, password);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.warn("Could not close fileInputStream of file {}: {}", (Object)docxFile.toString(), (Object)e.getMessage());
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new Docx4JException("Couldn't load file from " + docxFile.getAbsolutePath(), e);
            }
        }
        try {
            fileInputStream.close();
        }
        catch (IOException e) {
            log.warn("Could not close fileInputStream of file {}: {}", (Object)docxFile.toString(), (Object)e.getMessage());
        }
        return opcPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpcPackage load(PackageIdentifier pkgIdentifier, File docxFile, String password) throws Docx4JException {
        OpcPackage opcPackage;
        FileInputStream fileInputStream = new FileInputStream(docxFile);
        try {
            opcPackage = OpcPackage.load(pkgIdentifier, fileInputStream, password);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.warn("Could not close fileInputStream of file {}: {}", (Object)docxFile.toString(), (Object)e.getMessage());
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new Docx4JException("Couldn't load file from " + docxFile.getAbsolutePath(), e);
            }
        }
        try {
            fileInputStream.close();
        }
        catch (IOException e) {
            log.warn("Could not close fileInputStream of file {}: {}", (Object)docxFile.toString(), (Object)e.getMessage());
        }
        return opcPackage;
    }

    public static OpcPackage load(InputStream inputStream) throws Docx4JException {
        return OpcPackage.load(inputStream, "");
    }

    public static OpcPackage load(PackageIdentifier pkgIdentifier, InputStream inputStream) throws Docx4JException {
        return OpcPackage.load(pkgIdentifier, inputStream, "");
    }

    public static OpcPackage load(InputStream inputStream, String password) throws Docx4JException {
        return OpcPackage.load(null, inputStream, password);
    }

    private static OpcPackage load(PackageIdentifier pkgIdentifier, InputStream inputStream, String password) throws Docx4JException {
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        bis.mark(0);
        byte[] firstTwobytes = new byte[2];
        int read = 0;
        try {
            read = bis.read(firstTwobytes);
            bis.reset();
        }
        catch (IOException e) {
            throw new Docx4JException("Error reading from the stream", e);
        }
        if (read != 2) {
            throw new Docx4JException("Error reading from the stream (no bytes available)");
        }
        if (firstTwobytes[0] == 80 && firstTwobytes[1] == 75) {
            return OpcPackage.load(pkgIdentifier, bis, Filetype.ZippedPackage, null);
        }
        if (firstTwobytes[0] == -48 && firstTwobytes[1] == -49) {
            log.info("Detected compound file");
            return OpcPackage.load(pkgIdentifier, bis, Filetype.Compound, password);
        }
        log.info("Assuming Flat OPC XML");
        return OpcPackage.load(pkgIdentifier, bis, Filetype.FlatOPC, null);
    }

    @Deprecated
    public static OpcPackage load(InputStream is, boolean docxFormat) throws Docx4JException {
        return OpcPackage.load(is);
    }

    public static OpcPackage load(InputStream is, Filetype type) throws Docx4JException {
        return OpcPackage.load(is, type, null);
    }

    public static OpcPackage load(InputStream is, Filetype type, String password) throws Docx4JException {
        return OpcPackage.load(null, is, type, password);
    }

    public static OpcPackage load(File file, Filetype type) throws Docx4JException {
        return OpcPackage.load(file, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpcPackage load(File file, Filetype type, String password) throws Docx4JException {
        OpcPackage opcPackage;
        PackageIdentifierTransient pkgIdentifier = new PackageIdentifierTransient(file.getName());
        if (type.equals((Object)Filetype.ZippedPackage)) {
            StartEvent startEvent = new StartEvent(pkgIdentifier, WellKnownProcessSteps.PKG_LOAD);
            startEvent.publish();
            ZipPartStore partLoader = new ZipPartStore(file);
            Load3 loader = new Load3(partLoader);
            OpcPackage opcPackage2 = loader.get();
            opcPackage2.setNew(false);
            if (pkgIdentifier != null) {
                opcPackage2.setName(pkgIdentifier.name());
            }
            new EventFinished(startEvent).publish();
            return opcPackage2;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            opcPackage = OpcPackage.load(pkgIdentifier, fileInputStream, type, password);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.warn("Could not close fileInputStream of file {}: {}", (Object)file.toString(), (Object)e.getMessage());
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new Docx4JException("Couldn't load file from " + file.getAbsolutePath(), e);
            }
        }
        try {
            fileInputStream.close();
        }
        catch (IOException e) {
            log.warn("Could not close fileInputStream of file {}: {}", (Object)file.toString(), (Object)e.getMessage());
        }
        return opcPackage;
    }

    private static OpcPackage load(PackageIdentifier pkgIdentifier, InputStream is, Filetype type, String password) throws Docx4JException {
        if (pkgIdentifier == null) {
            pkgIdentifier = new PackageIdentifierTransient("pkg_" + System.currentTimeMillis());
        }
        StartEvent startEvent = new StartEvent(pkgIdentifier, WellKnownProcessSteps.PKG_LOAD);
        startEvent.publish();
        if (type.equals((Object)Filetype.ZippedPackage)) {
            ZipPartStore partLoader = new ZipPartStore(is);
            Load3 loader = new Load3(partLoader);
            OpcPackage opcPackage = loader.get();
            opcPackage.setNew(false);
            if (pkgIdentifier != null) {
                opcPackage.setName(pkgIdentifier.name());
            }
            new EventFinished(startEvent).publish();
            return opcPackage;
        }
        if (type.equals((Object)Filetype.Compound)) {
            try {
                POIFSFileSystem fs = new POIFSFileSystem(is);
                InputStream is2 = null;
                try {
                    EncryptionInfo info = new EncryptionInfo(fs);
                    Decryptor d = Decryptor.getInstance(info);
                    log.debug("Decrypting with " + d.getClass().getName());
                    if (!d.verifyPassword(password)) {
                        throw new Docx4JException("Problem reading encrypted document: wrong password?");
                    }
                    log.debug("Password works");
                    is2 = d.getDataStream(fs);
                }
                catch (FileNotFoundException fnf) {
                    throw new Docx4JException("This file seems to be a binary doc/ppt/xls, not an encrypted OLE2 file containing a doc/pptx/xlsx");
                }
                ZipPartStore partLoader = new ZipPartStore(is2);
                Load3 loader = new Load3(partLoader);
                OpcPackage opcPackage = loader.get();
                opcPackage.setNew(false);
                if (pkgIdentifier != null) {
                    opcPackage.setName(pkgIdentifier.name());
                }
                OpcPackage opcPackage2 = opcPackage;
                return opcPackage2;
            }
            catch (Docx4JException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Docx4JException("Problem reading encrypted document", e);
            }
            finally {
                new EventFinished(startEvent).publish();
            }
        }
        try {
            FlatOpcXmlImporter xmlPackage = new FlatOpcXmlImporter(is);
            OpcPackage opcPackage = xmlPackage.get();
            return opcPackage;
        }
        catch (Exception e) {
            throw new Docx4JException("Couldn't load xml from stream ", e);
        }
        finally {
            new EventFinished(startEvent).publish();
        }
    }

    public void save(File file) throws Docx4JException {
        if (file.getName().endsWith(".xml")) {
            this.save(file, 2);
        } else {
            this.save(file, 1);
        }
    }

    public void save(File outFile, int flags) throws Docx4JException {
        this.save(outFile, flags, null);
    }

    public void save(File outFile, int flags, String password) throws Docx4JException {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(outFile);
            this.save(outStream, flags, password);
        }
        catch (FileNotFoundException e) {
            throw new Docx4JException("Exception creating output stream: " + e.getMessage(), e);
        }
        finally {
            if (outStream != null) {
                try {
                    ((OutputStream)outStream).close();
                }
                catch (IOException iOException) {}
                outStream = null;
            }
        }
    }

    public void save(OutputStream outStream) throws Docx4JException {
        this.save(outStream, 1);
    }

    public void save(OutputStream outStream, int flags) throws Docx4JException {
        this.save(outStream, flags, null);
    }

    public void save(OutputStream outStream, int flags, String password) throws Docx4JException {
        StartEvent startEvent = new StartEvent(this, WellKnownProcessSteps.PKG_SAVE);
        startEvent.publish();
        if (flags == 2) {
            FlatOpcXmlCreator opcXmlCreator = new FlatOpcXmlCreator(this);
            opcXmlCreator.populate();
            opcXmlCreator.marshal(outStream);
        } else if (flags == 3 || flags == 4 || flags == 5) {
            if (password == null || password.trim().length() == 0) {
                throw new Docx4JException("Encryption requested, but a new password not provided.");
            }
            EncryptionInfo info = null;
            if (flags == 3) {
                info = new EncryptionInfo(EncryptionMode.binaryRC4);
            } else if (flags == 4) {
                info = new EncryptionInfo(EncryptionMode.standard);
            } else if (flags == 5) {
                info = new EncryptionInfo(EncryptionMode.agile);
            }
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(password);
            try {
                POIFSFileSystem fs = new POIFSFileSystem();
                OutputStream os = enc.getDataStream(fs);
                Save saver = new Save(this);
                saver.save(os);
                fs.writeFilesystem(outStream);
            }
            catch (Exception e) {
                throw new Docx4JException("Error encrypting as OLE compound file", e);
            }
        } else {
            Save saver = new Save(this);
            saver.save(outStream);
        }
        new EventFinished(startEvent).publish();
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        if (relationshipType.equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties")) {
            this.docPropsCorePart = (DocPropsCorePart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties")) {
            this.docPropsCustomPart = (DocPropsCustomPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties")) {
            this.docPropsExtendedPart = (DocPropsExtendedPart)part;
            return true;
        }
        return false;
    }

    public DocPropsCorePart getDocPropsCorePart() {
        return this.docPropsCorePart;
    }

    public void addDocPropsCorePart() {
        if (this.docPropsCorePart == null) {
            try {
                this.docPropsCorePart = new DocPropsCorePart();
                this.addTargetPart(this.docPropsCorePart);
                this.docPropsCorePart.setJaxbElement(new CoreProperties());
            }
            catch (InvalidFormatException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public DocPropsExtendedPart getDocPropsExtendedPart() {
        return this.docPropsExtendedPart;
    }

    public void addDocPropsExtendedPart() {
        if (this.docPropsExtendedPart == null) {
            try {
                this.docPropsExtendedPart = new DocPropsExtendedPart();
                this.addTargetPart(this.docPropsExtendedPart);
                this.docPropsExtendedPart.setJaxbElement(new Properties());
            }
            catch (InvalidFormatException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public DocPropsCustomPart getDocPropsCustomPart() {
        return this.docPropsCustomPart;
    }

    public void addDocPropsCustomPart() {
        if (this.docPropsCustomPart == null) {
            try {
                this.docPropsCustomPart = new DocPropsCustomPart();
                this.docPropsCustomPart.setJaxbElement(new org.docx4j.docProps.custom.Properties());
                this.addTargetPart(this.docPropsCustomPart);
            }
            catch (InvalidFormatException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public void setTitle(String title) {
        if (this.getDocPropsCorePart() == null) {
            try {
                DocPropsCorePart core = new DocPropsCorePart();
                org.docx4j.docProps.core.ObjectFactory coreFactory = new org.docx4j.docProps.core.ObjectFactory();
                core.setJaxbElement(coreFactory.createCoreProperties());
                this.addTargetPart(core);
            }
            catch (InvalidFormatException e) {
                log.error(e.getMessage(), e);
            }
        }
        ObjectFactory of = new ObjectFactory();
        SimpleLiteral literal = of.createSimpleLiteral();
        literal.getContent().add(title);
        ((CoreProperties)this.getDocPropsCorePart().getJaxbElement()).setTitle(of.createTitle(literal));
    }

    public String getTitle() {
        if (this.getDocPropsCorePart() == null) {
            return null;
        }
        JAXBElement<SimpleLiteral> sl = ((CoreProperties)this.getDocPropsCorePart().getJaxbElement()).getTitle();
        if (sl == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        try {
            TextUtils.extractText(sl, sw, Context.jcDocPropsCore);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return sw.toString();
    }

    public OpcPackage clone() {
        OpcPackage result = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Save saver = new Save(this);
        try {
            saver.save(baos);
            result = OpcPackage.load(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), e);
        }
        return result;
    }

    public OpcPackage cloneAs(String targetContentType) throws Docx4JException {
        if (targetContentType.equals(this.getContentType())) {
            log.debug("No change to content type " + this.getContentType());
            return this.clone();
        }
        String mainPartNameString = PackageRelsUtil.getNameOfMainPart(this.getRelationshipsPart());
        PartName mainPartName = new PartName("/" + mainPartNameString);
        this.contentTypeManager.removeOverrideContentType(mainPartName);
        this.contentTypeManager.addOverrideContentType(mainPartName.getURI(), targetContentType);
        OpcPackage clone = this.clone();
        this.contentTypeManager.removeOverrideContentType(mainPartName);
        this.contentTypeManager.addOverrideContentType(mainPartName.getURI(), this.getContentType());
        return clone;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void reset() {
        super.reset();
        this.handled = new HashMap();
        this.parts = new Parts();
        this.externalResources = new HashMap();
        this.customXmlDataStorageParts = new HashMap();
        this.sourcePartStore = null;
        this.targetPartStore = null;
        this.docPropsCorePart = null;
        this.docPropsExtendedPart = null;
        this.docPropsCustomPart = null;
        this.name = null;
        log.info("reset complete");
    }
}

