/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.packages;

import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.docx4j.Docx4jProperties;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.io3.SaveSlides;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.ProtectPresentation;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.MainPresentationPart;
import org.docx4j.openpackaging.parts.PresentationML.NotesSlidePart;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.Style;
import org.pptx4j.model.ShapeWrapper;
import org.pptx4j.model.SlideSizesWellKnown;
import org.pptx4j.model.TextStyles;
import org.pptx4j.pml.SldLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresentationMLPackage
extends OpcPackage {
    protected static Logger log = LoggerFactory.getLogger(PresentationMLPackage.class);
    private ProtectPresentation presentationProtectionSettings = new ProtectPresentation(this);
    private MainPresentationPart mainPresentationPart;
    private static String SAMPLE_SHAPE = "<p:sp   xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"><p:nvSpPr><p:cNvPr id=\"4\" name=\"Title 3\" /><p:cNvSpPr><a:spLocks noGrp=\"1\" /></p:cNvSpPr><p:nvPr><p:ph type=\"title\" /></p:nvPr></p:nvSpPr><p:spPr /><p:txBody><a:bodyPr /><a:lstStyle /><a:p><a:r><a:rPr lang=\"en-US\" smtClean=\"0\" /><a:t>Hello World</a:t></a:r><a:endParaRPr lang=\"en-US\" /></a:p></p:txBody></p:sp>";
    Map<String, ShapeWrapper> globalPlaceHolders;
    private StyleTree styleTree;

    public PresentationMLPackage() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml"));
    }

    public PresentationMLPackage(ContentTypeManager contentTypeManager) {
        super(contentTypeManager);
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml"));
    }

    public ProtectPresentation getProtectionSettings() {
        return this.presentationProtectionSettings;
    }

    public static PresentationMLPackage load(File pptxFile) throws Docx4JException {
        return (PresentationMLPackage)OpcPackage.load(pptxFile);
    }

    public static PresentationMLPackage load(InputStream pptxInputStream) throws Docx4JException {
        return (PresentationMLPackage)OpcPackage.load(pptxInputStream);
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        if (relationshipType.equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties")) {
            this.docPropsCorePart = (DocPropsCorePart)part;
            log.info("Set shortcut for docPropsCorePart");
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties")) {
            this.docPropsExtendedPart = (DocPropsExtendedPart)part;
            log.info("Set shortcut for docPropsExtendedPart");
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties")) {
            this.docPropsCustomPart = (DocPropsCustomPart)part;
            log.info("Set shortcut for docPropsCustomPart");
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument")) {
            this.mainPresentationPart = (MainPresentationPart)part;
            log.info("Set shortcut for mainPresentationPart");
            return true;
        }
        return false;
    }

    public MainPresentationPart getMainPresentationPart() {
        return this.mainPresentationPart;
    }

    public static PresentationMLPackage createPackage() throws InvalidFormatException {
        String slideSize = Docx4jProperties.getProperties().getProperty("pptx4j.PageSize", "A4");
        log.info("Using paper size: " + slideSize);
        boolean landscape = Docx4jProperties.getProperty("pptx4j.PageOrientationLandscape", true);
        log.info("Landscape orientation: " + landscape);
        return PresentationMLPackage.createPackage(SlideSizesWellKnown.valueOf(slideSize), landscape);
    }

    public static PresentationMLPackage createPackage(SlideSizesWellKnown sz, boolean landscape) throws InvalidFormatException {
        PresentationMLPackage pmlPack = new PresentationMLPackage();
        try {
            MainPresentationPart pp = new MainPresentationPart();
            pp.setJaxbElement(MainPresentationPart.createJaxbPresentationElement(sz, landscape));
            pmlPack.addTargetPart(pp);
            SlideLayoutPart layoutPart = new SlideLayoutPart();
            layoutPart.setJaxbElement(SlideLayoutPart.createSldLayout());
            SlideMasterPart masterPart = new SlideMasterPart();
            pp.addSlideMasterIdListEntry(masterPart);
            masterPart.setJaxbElement(masterPart.createSldMaster());
            masterPart.addSlideLayoutIdListEntry(layoutPart);
            layoutPart.addTargetPart(masterPart);
            ThemePart themePart = new ThemePart(new PartName("/ppt/theme/theme1.xml"));
            InputStream is = ResourceUtils.getResourceViaProperty("pptx4j.openpackaging.packages.PresentationMLPackage.DefaultTheme", "org/docx4j/openpackaging/parts/PresentationML/theme.xml");
            themePart.unmarshal(is);
            masterPart.addTargetPart(themePart);
            pp.addTargetPart(themePart);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidFormatException("Couldn't create package", e);
        }
        return pmlPack;
    }

    @Deprecated
    public static SlidePart createSlidePart(MainPresentationPart pp, SlideLayoutPart layoutPart, PartName partName) throws InvalidFormatException, JAXBException {
        SlidePart slidePart = new SlidePart(partName);
        pp.addSlideIdListEntry(slidePart);
        slidePart.setJaxbElement(SlidePart.createSld());
        slidePart.addTargetPart(layoutPart);
        return slidePart;
    }

    @Deprecated
    public static NotesSlidePart createNotesSlidePart(Part sourcePart, PartName partName) throws Exception {
        String proposedRelId = sourcePart.getRelationshipsPart().getNextId();
        NotesSlidePart notesSlidePart = new NotesSlidePart(partName);
        notesSlidePart.getSourceRelationships().add(sourcePart.addTargetPart((Part)notesSlidePart, proposedRelId));
        notesSlidePart.setJaxbElement(NotesSlidePart.createNotes());
        return notesSlidePart;
    }

    public Map<String, ShapeWrapper> getPlaceHoldersFromAcrossLayouts() {
        if (this.globalPlaceHolders != null) {
            return this.globalPlaceHolders;
        }
        this.globalPlaceHolders = new HashMap<String, ShapeWrapper>();
        for (Map.Entry<PartName, Part> pairs : this.getParts().getParts().entrySet()) {
            Part p = pairs.getValue();
            if (!(p instanceof SlideLayoutPart)) continue;
            SldLayout sldLayout = (SldLayout)((SlideLayoutPart)p).getJaxbElement();
            this.globalPlaceHolders.putAll(((SlideLayoutPart)p).getIndexedPlaceHolders());
        }
        return this.globalPlaceHolders;
    }

    public StyleTree getStyleTree() throws InvalidFormatException {
        if (this.styleTree == null) {
            List<Style> styles = TextStyles.generateStyles(this);
            HashSet<String> list = new HashSet<String>();
            HashMap<String, Style> map = new HashMap<String, Style>();
            for (Style s2 : styles) {
                map.put(s2.getStyleId(), s2);
                list.add(s2.getStyleId());
            }
            this.styleTree = new StyleTree(list, map, TextStyles.generateDocDefaults(), null);
        }
        return this.styleTree;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("reset of pptx package not implemented yet");
    }

    public PresentationMLPackage partialClone(int[] slideNumbers) {
        PresentationMLPackage result = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SaveSlides saver = new SaveSlides(this, slideNumbers);
        try {
            saver.save(baos);
            result = PresentationMLPackage.load(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), e);
        }
        return result;
    }
}

