/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLStreamWriterWrapper
implements XMLStreamWriter {
    protected static Logger log = LoggerFactory.getLogger(XMLStreamWriterWrapper.class);
    XMLStreamWriter underlying;
    JaxbXmlPart part;
    private List<Event> queue = new ArrayList<Event>();

    public XMLStreamWriterWrapper(JaxbXmlPart part, XMLStreamWriter underlying) {
        this.part = part;
        this.underlying = underlying;
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.d(this.e(this.m("writeStartElement", String.class), new Object[0]), localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.d(this.e(this.m("writeStartElement", String.class, String.class), new Object[0]), namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.d(this.e(this.m("writeStartElement", String.class, String.class, String.class), new Object[0]), prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.underlying.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.underlying.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.underlying.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.d(this.e(this.m("writeEndElement", new Class[0]), new Object[0]), new Object[0]);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.fq();
        this.underlying.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.fq();
        this.underlying.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        if (this.queue.isEmpty()) {
            this.underlying.flush();
        }
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.d(this.e(this.m("writeAttribute", String.class, String.class), new Object[0]), localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (prefix == null && namespaceURI.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            log.info("added prefix for xsi");
            prefix = "xsi";
        }
        if (prefix == null || prefix.length() == 0) {
            if (ExceptionUtils.getStackFrames(new Throwable())[3].contains("writeXsiTypeAttribute")) {
                log.info("suppressed xsi:type");
                return;
            }
            log.error("prefix null for " + namespaceURI + " localname " + localName, new Throwable());
        }
        this.d(this.e(this.m("writeAttribute", String.class, String.class, String.class, String.class), new Object[0]), prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.d(this.e(this.m("writeAttribute", String.class, String.class, String.class), new Object[0]), namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (namespaceURI == null) {
            log.debug("Dropping null for prefix '" + prefix + "'");
        } else if (namespaceURI.trim().isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Dropping empty for prefix '" + prefix + "'");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Writing {}={}", (Object)prefix, (Object)namespaceURI);
            }
            this.d(this.e(this.m("writeNamespace", String.class, String.class), new Object[0]), prefix, namespaceURI);
        }
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        if (namespaceURI == null) {
            log.debug("Dropping null ");
        } else if (namespaceURI.trim().isEmpty()) {
            log.debug("Dropping empty ");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Writing {}", (Object)namespaceURI);
            }
            this.underlying.writeDefaultNamespace(namespaceURI);
        }
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.fq();
        this.underlying.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.fq();
        this.underlying.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.fq();
        this.underlying.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.fq();
        this.underlying.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.fq();
        this.underlying.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.underlying.writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        log.debug("writeStartDocument ");
        this.writeStartDocument("UTF-8", "1.0");
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        log.debug("writeStartDocument " + version);
        this.writeStartDocument("UTF-8", version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        log.debug("writeStartDocument " + encoding);
        this.underlying.writeStartDocument(encoding, version);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.fq();
        this.underlying.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.fq();
        this.underlying.writeCharacters(text, start, len);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.underlying.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.d(this.e(this.m("setPrefix", String.class, String.class), new Object[0]), prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.d(this.e(this.m("setDefaultNamespace", String.class), new Object[0]), uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.underlying.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.underlying.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.underlying.getProperty(name);
    }

    void d(Event e, Object ... args) throws XMLStreamException {
        e.args = args;
        switch (EventEnum.valueOf(e.m.getName())) {
            case writeStartElement: {
                this.fq();
                this.queue.add(e);
                break;
            }
            case writeAttribute: 
            case writeNamespace: 
            case setPrefix: 
            case setDefaultNamespace: {
                if (!this.queue.isEmpty()) {
                    this.queue.add(e);
                    break;
                }
                this.ex(e, args);
                break;
            }
            case writeEndElement: {
                if (!this.queue.isEmpty()) {
                    Event e1 = this.queue.get(0);
                    e1.m = this.m("writeEmptyElement", e1.m.getParameterTypes());
                    this.fq();
                    break;
                }
                this.ex(e, args);
            }
        }
    }

    Event e(Method m3, Object ... params) {
        Event e = new Event();
        e.m = m3;
        e.args = params;
        return e;
    }

    Method m(String methodName, Class<?> ... args) throws XMLStreamException {
        try {
            return XMLStreamWriter.class.getMethod(methodName, args);
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    void fq() throws XMLStreamException {
        for (int i = 0; i < this.queue.size(); ++i) {
            Event e = this.queue.get(i);
            this.ex(e, e.args);
        }
        this.queue.clear();
    }

    void ex(Event e, Object ... args) throws XMLStreamException {
        try {
            e.m.invoke((Object)this.underlying, e.args);
        }
        catch (Exception ex) {
            throw new XMLStreamException(ex);
        }
    }

    class Event {
        Method m;
        Object[] args;

        Event() {
        }
    }

    static enum EventEnum {
        writeStartElement,
        writeAttribute,
        writeNamespace,
        writeEndElement,
        setPrefix,
        setDefaultNamespace;

    }
}

