/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.org.apache.xalan.transformer.TransformerIdentityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSerializerUtil {
    private static Logger log = LoggerFactory.getLogger(XmlSerializerUtil.class);

    public static void serialize(Source source, Result result, boolean omit_xml_declaration, boolean method_xml) throws Docx4JException {
        XmlSerializerUtil.serialize(source, result, omit_xml_declaration, method_xml, false);
    }

    public static void serialize(Source source, Result result, boolean omit_xml_declaration, boolean method_xml, boolean indent) throws Docx4JException {
        try {
            TransformerIdentityImpl serializer = new TransformerIdentityImpl();
            if (omit_xml_declaration) {
                ((Transformer)serializer).setOutputProperty("omit-xml-declaration", "yes");
            }
            if (method_xml) {
                ((Transformer)serializer).setOutputProperty("method", "xml");
            }
            if (indent) {
                ((Transformer)serializer).setOutputProperty("indent", "yes");
            }
            ((Transformer)serializer).transform(source, result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new Docx4JException("Exception writing Document to OutputStream: " + e.getMessage(), e);
        }
    }
}

