/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx;

import java.util.List;
import org.camunda.bpm.dmn.xlsx.BaseAdapter;
import org.camunda.bpm.dmn.xlsx.InputOutputColumns;
import org.camunda.bpm.dmn.xlsx.api.Spreadsheet;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetCell;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetRow;
import org.camunda.bpm.dmn.xlsx.elements.HeaderValuesContainer;
import org.camunda.bpm.model.dmn.HitPolicy;

public class SimpleInputOutputDetectionStrategy
extends BaseAdapter {
    @Override
    public InputOutputColumns determineInputOutputs(Spreadsheet context) {
        SpreadsheetRow headerRow = context.getRows().get(0);
        if (!headerRow.hasCells()) {
            throw new RuntimeException("A dmn table requires at least one output; the header row contains no entries");
        }
        InputOutputColumns ioColumns = new InputOutputColumns();
        List<SpreadsheetCell> cells = headerRow.getCells();
        HeaderValuesContainer hvc = new HeaderValuesContainer();
        SpreadsheetCell outputCell = cells.get(cells.size() - 1);
        this.fillHvc(outputCell, context, hvc);
        hvc.setId("Output" + outputCell.getColumn());
        ioColumns.addOutputHeader(hvc);
        for (SpreadsheetCell inputCell : cells.subList(0, cells.size() - 1)) {
            hvc = new HeaderValuesContainer();
            this.fillHvc(inputCell, context, hvc);
            hvc.setId("Input" + inputCell.getColumn());
            ioColumns.addInputHeader(hvc);
        }
        return ioColumns;
    }

    @Override
    public HitPolicy determineHitPolicy(Spreadsheet context) {
        return null;
    }

    private void fillHvc(SpreadsheetCell cell, Spreadsheet context, HeaderValuesContainer hvc) {
        hvc.setText(context.resolveCellContent(cell));
        hvc.setColumn(cell.getColumn());
    }

    @Override
    public List<SpreadsheetRow> determineRuleRows(Spreadsheet context) {
        List<SpreadsheetRow> rows = context.getRows();
        return rows.subList(1, rows.size());
    }
}

