/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.dmn.xlsx.CellContentHandler;
import org.camunda.bpm.dmn.xlsx.XlsxWorksheetContext;
import org.camunda.bpm.dmn.xlsx.elements.IndexedDmnColumns;
import org.xlsx4j.sml.Cell;

public class DmnConversionContext {
    protected List<CellContentHandler> cellContentHandlers = new ArrayList<CellContentHandler>();
    protected XlsxWorksheetContext worksheetContext;
    protected IndexedDmnColumns indexedDmnColumns = new IndexedDmnColumns();

    public DmnConversionContext(XlsxWorksheetContext worksheetContext) {
        this.worksheetContext = worksheetContext;
    }

    public String resolveCellValue(Cell cell) {
        for (CellContentHandler contentHandler : this.cellContentHandlers) {
            if (!contentHandler.canConvert(cell, this.worksheetContext)) continue;
            return contentHandler.convert(cell, this.worksheetContext);
        }
        throw new RuntimeException("cannot parse cell content, unsupported format");
    }

    public void addCellContentHandler(CellContentHandler cellContentHandler) {
        this.cellContentHandlers.add(cellContentHandler);
    }

    public IndexedDmnColumns getIndexedDmnColumns() {
        return this.indexedDmnColumns;
    }
}

