/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.docx4j.docProps.custom.ObjectFactory;
import org.docx4j.docProps.custom.Properties;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.PartName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocPropsCustomPart
extends JaxbXmlPart<Properties> {
    private static Logger log = LoggerFactory.getLogger(DocPropsCustomPart.class);
    public static final String fmtidValLpwstr = "{D5CDD505-2E9C-101B-9397-08002B2CF9AE}";
    private Map<String, String> props = null;

    public DocPropsCustomPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public DocPropsCustomPart() throws InvalidFormatException {
        super(new PartName("/docProps/custom.xml"));
        this.init();
    }

    public void init() {
        this.setJAXBContext(Context.jcDocPropsCustom);
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.custom-properties+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties");
    }

    @Override
    public Properties unmarshal(InputStream is) throws JAXBException {
        try {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xsr = xif.createXMLStreamReader(is);
            this.setJAXBContext(Context.jcDocPropsCustom);
            Unmarshaller u = this.jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            log.info("unmarshalling " + this.getClass().getName());
            this.jaxbElement = (Properties)u.unmarshal(xsr);
            log.info("\n\n" + this.getClass().getName() + " unmarshalled \n\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (Properties)this.jaxbElement;
    }

    public String getProperty(String propName) {
        if (this.props == null) {
            this.initMap();
        }
        return this.props.get(propName);
    }

    private void initMap() {
        this.props = new HashMap<String, String>();
        Properties customProps = (Properties)this.getJaxbElement();
        for (Properties.Property prop : customProps.getProperty()) {
            this.props.put(prop.getName(), prop.getLpwstr());
        }
    }

    public void setProperty(String propName, String propValue) {
        Properties.Property newProp = null;
        Properties customProps = (Properties)this.getJaxbElement();
        for (Properties.Property prop : customProps.getProperty()) {
            if (!prop.getName().equals(propName)) continue;
            log.warn("Replacing existing property: " + propName);
            newProp = prop;
            if (newProp.getFmtid().equals(fmtidValLpwstr)) break;
            log.warn("Wrong fmtid?  This might not work...");
            break;
        }
        if (newProp == null) {
            ObjectFactory factory = new ObjectFactory();
            newProp = factory.createPropertiesProperty();
            newProp.setName(propName);
            newProp.setFmtid(fmtidValLpwstr);
            newProp.setPid(this.getNextPid());
            customProps.getProperty().add(newProp);
        }
        newProp.setLpwstr(propValue);
        if (this.props == null) {
            this.initMap();
        }
        this.props.put(propName, propValue);
    }

    public int getNextPid() {
        int highestSeen = 1;
        Properties customProps = (Properties)this.getJaxbElement();
        for (Properties.Property prop : customProps.getProperty()) {
            if (prop.getPid() <= highestSeen) continue;
            highestSeen = prop.getPid();
        }
        log.debug("Returning " + highestSeen + 1);
        return highestSeen + 1;
    }
}

