/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.utils.AbstractTraversalUtilVisitorCallback;
import org.docx4j.utils.TraversalUtilVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleTraversalUtilVisitorCallback
extends AbstractTraversalUtilVisitorCallback {
    protected static Logger log = LoggerFactory.getLogger(SingleTraversalUtilVisitorCallback.class);
    protected TraversalUtilVisitor visitor = null;
    protected Class visitorClass = null;

    public SingleTraversalUtilVisitorCallback(TraversalUtilVisitor visitor) {
        this.visitor = visitor;
        this.visitorClass = this.findClassParameter(visitor.getClass());
        if (this.visitorClass == null) {
            throw new IllegalArgumentException("Can't identify the parameter class of the visitor " + visitor.getClass().getName());
        }
    }

    @Override
    protected List<Object> apply(Object child, Object parent, List siblings) {
        if (this.visitorClass == null) {
            log.warn("visitorClass==null for some element with parent " + parent.getClass().getName());
        } else if (child == null) {
            log.warn("child==null for some element with parent " + parent.getClass().getName());
            log.warn(XmlUtils.marshaltoString(parent));
        } else if (this.visitorClass.isAssignableFrom(child.getClass())) {
            this.visitor.apply(child, parent, siblings);
        }
        return null;
    }
}

