/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.event.impl.EventFactory;
import com.topologi.diffx.event.impl.ProcessingInstructionEvent;
import com.topologi.diffx.load.LoadingException;
import com.topologi.diffx.load.XMLRecorder;
import com.topologi.diffx.load.text.TextTokenizer;
import com.topologi.diffx.load.text.TokenizerFactory;
import com.topologi.diffx.sequence.EventSequence;
import com.topologi.diffx.sequence.PrefixMapping;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.docx4j.XmlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public final class DOMRecorder
implements XMLRecorder {
    private DiffXConfig config = new DiffXConfig();
    private transient EventFactory efactory;
    private transient TextTokenizer tokenizer;
    private transient EventSequence sequence;
    private transient PrefixMapping mapping;
    private transient int currentWeight = -1;
    private transient List<Integer> weights = new ArrayList<Integer>();
    private transient boolean isFragment = true;

    public DiffXConfig getConfig() {
        return this.config;
    }

    public void setConfig(DiffXConfig config) {
        this.config = config;
    }

    public EventSequence process(File file) throws LoadingException, IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        return this.process(new InputSource(in));
    }

    public EventSequence process(String xml) throws LoadingException {
        return this.process(new InputSource(new StringReader(xml)));
    }

    public EventSequence process(InputSource is) throws LoadingException {
        this.isFragment = false;
        try {
            DocumentBuilder builder = XmlUtils.getNewDocumentBuilder();
            Document document = builder.parse(is);
            return this.process(document);
        }
        catch (Exception ex) {
            throw new LoadingException(ex);
        }
    }

    public EventSequence process(Node node) throws LoadingException {
        this.efactory = new EventFactory(this.config.isNamespaceAware());
        this.tokenizer = TokenizerFactory.get(this.config);
        this.sequence = new EventSequence();
        this.mapping = this.sequence.getPrefixMapping();
        this.loadNode(node);
        this.isFragment = true;
        return this.sequence;
    }

    public EventSequence process(NodeList node) throws LoadingException {
        if (node.getLength() == 0) {
            return new EventSequence();
        }
        return this.process(node.item(0));
    }

    private void loadNode(Node node) throws LoadingException {
        if (node instanceof Element) {
            this.load((Element)node);
        }
        if (node instanceof Text) {
            this.load((Text)node);
        } else if (node instanceof Attr) {
            this.load((Attr)node);
        } else if (node instanceof Document) {
            this.load((Document)node);
        } else if (node instanceof ProcessingInstruction) {
            this.load((ProcessingInstruction)node);
        }
    }

    private void load(Document document) throws LoadingException {
        this.load(document.getDocumentElement());
    }

    private void load(Element element) throws LoadingException {
        if (this.currentWeight > 0) {
            this.weights.add(this.currentWeight);
        }
        this.currentWeight = 1;
        OpenElementEvent open = null;
        if (this.config.isNamespaceAware()) {
            String uri = element.getNamespaceURI() == null ? "" : element.getNamespaceURI();
            String name = element.getLocalName();
            this.handlePrefixMapping(uri, element.getPrefix());
            open = this.efactory.makeOpenElement(uri, name);
        } else {
            open = this.efactory.makeOpenElement(null, element.getNodeName());
        }
        this.sequence.addEvent(open);
        NamedNodeMap atts = element.getAttributes();
        if (atts.getLength() == 1) {
            this.load((Attr)atts.item(0));
        } else if (atts.getLength() > 1) {
            Object[] names = new String[atts.getLength()];
            for (int i = 0; i < atts.getLength(); ++i) {
                Attr attr = (Attr)atts.item(i);
                names[i] = attr.getName();
            }
            Arrays.sort(names);
            for (Object name : names) {
                this.load((Attr)atts.getNamedItem((String)name));
            }
        }
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            this.loadNode(list.item(i));
        }
        CloseElementEvent close = this.efactory.makeCloseElement(open);
        this.sequence.addEvent(close);
        close.setWeight(this.currentWeight);
        open.setWeight(this.currentWeight);
        this.currentWeight += this.popWeight();
    }

    private void load(Text text) throws LoadingException {
        List<TextEvent> events = this.tokenizer.tokenize(text.getData());
        for (TextEvent e : events) {
            this.sequence.addEvent(e);
        }
        this.currentWeight += events.size();
    }

    private void load(ProcessingInstruction pi) throws LoadingException {
        this.sequence.addEvent(new ProcessingInstructionEvent(pi.getTarget(), pi.getData()));
        ++this.currentWeight;
    }

    private int popWeight() {
        if (this.weights.size() > 0) {
            return this.weights.remove(this.weights.size() - 1);
        }
        return 0;
    }

    private void load(Attr attr) {
        this.handlePrefixMapping(attr.getNamespaceURI(), attr.getPrefix());
        this.load(this.efactory.makeAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getNodeName(), attr.getValue()));
    }

    private void load(AttributeEvent e) {
        if ("http://www.w3.org/2000/xmlns/".equals(e.getURI())) {
            this.sequence.mapPrefix(e.getValue(), e.getName());
        } else {
            e.setWeight(2);
            this.currentWeight += 2;
            this.sequence.addEvent(e);
        }
    }

    private void handlePrefixMapping(String uri, String prefix) {
        if (this.isFragment) {
            if (this.mapping.getPrefix(uri) != null) {
                return;
            }
            if (prefix == null && !"".equals(uri)) {
                this.mapping.add(uri, "");
            } else if (prefix != null && !"xmlns".equals(prefix)) {
                this.mapping.add(uri, prefix);
            }
        }
    }
}

