/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.svg;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.arnx.wmf2svg.gdi.Gdi;
import net.arnx.wmf2svg.gdi.GdiBrush;
import net.arnx.wmf2svg.gdi.GdiFont;
import net.arnx.wmf2svg.gdi.GdiObject;
import net.arnx.wmf2svg.gdi.GdiPalette;
import net.arnx.wmf2svg.gdi.GdiPatternBrush;
import net.arnx.wmf2svg.gdi.GdiPen;
import net.arnx.wmf2svg.gdi.GdiRegion;
import net.arnx.wmf2svg.gdi.GdiUtils;
import net.arnx.wmf2svg.gdi.Point;
import net.arnx.wmf2svg.gdi.Size;
import net.arnx.wmf2svg.gdi.svg.SvgBrush;
import net.arnx.wmf2svg.gdi.svg.SvgDc;
import net.arnx.wmf2svg.gdi.svg.SvgFont;
import net.arnx.wmf2svg.gdi.svg.SvgGdiException;
import net.arnx.wmf2svg.gdi.svg.SvgObject;
import net.arnx.wmf2svg.gdi.svg.SvgPalette;
import net.arnx.wmf2svg.gdi.svg.SvgPatternBrush;
import net.arnx.wmf2svg.gdi.svg.SvgPen;
import net.arnx.wmf2svg.gdi.svg.SvgRectRegion;
import net.arnx.wmf2svg.util.Base64;
import net.arnx.wmf2svg.util.ImageUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgGdi
implements Gdi {
    private static Logger log = Logger.getLogger(SvgGdi.class.getName());
    private boolean compatible;
    private Map props = new HashMap();
    private SvgDc dc;
    private LinkedList saveDC = new LinkedList();
    private Document doc = null;
    private Element parentNode = null;
    private Element styleNode = null;
    private Element defsNode = null;
    private int brushNo = 0;
    private int fontNo = 0;
    private int penNo = 0;
    private int patternNo = 0;
    private int rgnNo = 0;
    private int clipPathNo = 0;
    private int maskNo = 0;
    private Map nameMap = new HashMap();
    private StringBuffer buffer = new StringBuffer();
    private SvgBrush defaultBrush;
    private SvgPen defaultPen;
    private SvgFont defaultFont;

    public SvgGdi() throws SvgGdiException {
        this(false);
    }

    public SvgGdi(boolean bl) throws SvgGdiException {
        this.compatible = bl;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SvgGdiException(parserConfigurationException);
        }
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        this.doc = dOMImplementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream("SvgGdi.properties");
            Properties properties = new Properties();
            properties.load(inputStream);
        }
        catch (Exception exception) {
            throw new SvgGdiException("properties format error: SvgGDI.properties");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public SvgDc getDC() {
        return this.dc;
    }

    public Object getProperty(String string) {
        return this.props.get(string);
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element getDefsElement() {
        return this.defsNode;
    }

    public Element getStyleElement() {
        return this.styleNode;
    }

    public void placeableHeader(int n, int n2, int n3, int n4, int n5) {
        if (this.parentNode == null) {
            this.init();
        }
        this.dc.setWindowExtEx(Math.abs(n3 - n), Math.abs(n4 - n2), null);
        this.dc.setDpi(n5);
        Element element = this.doc.getDocumentElement();
        element.setAttribute("width", "" + (double)Math.abs(n3 - n) / (double)this.dc.getDpi() + "in");
        element.setAttribute("height", "" + (double)Math.abs(n4 - n2) / (double)this.dc.getDpi() + "in");
    }

    public void header() {
        if (this.parentNode == null) {
            this.init();
        }
    }

    private void init() {
        this.dc = new SvgDc(this);
        Element element = this.doc.getDocumentElement();
        element.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        element.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.defsNode = this.doc.createElement("defs");
        element.appendChild(this.defsNode);
        this.styleNode = this.doc.createElement("style");
        this.styleNode.setAttribute("type", "text/css");
        element.appendChild(this.styleNode);
        this.parentNode = this.doc.createElement("g");
        this.doc.getDocumentElement().appendChild(this.parentNode);
        this.defaultBrush = (SvgBrush)this.createBrushIndirect(0, 0xFFFFFF, 0);
        this.defaultPen = (SvgPen)this.createPenIndirect(0, 1, 0);
        this.defaultFont = null;
        this.dc.setBrush(this.defaultBrush);
        this.dc.setPen(this.defaultPen);
        this.dc.setFont(this.defaultFont);
    }

    public void animatePalette(GdiPalette gdiPalette, int n, int[] nArray) {
        log.fine("not implemented: animatePalette");
    }

    public void arc(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        double d = (double)Math.abs(n3 - n) / 2.0;
        double d2 = (double)Math.abs(n4 - n2) / 2.0;
        if (d <= 0.0 || d2 <= 0.0) {
            return;
        }
        double d3 = (double)Math.min(n, n3) + d;
        double d4 = (double)Math.min(n2, n4) + d2;
        Element element = null;
        if (n5 == n7 && n6 == n8) {
            if (d == d2) {
                element = this.doc.createElement("circle");
                element.setAttribute("cx", "" + this.dc.toAbsoluteX((int)d3));
                element.setAttribute("cy", "" + this.dc.toAbsoluteY((int)d4));
                element.setAttribute("r", "" + this.dc.toRelativeX((int)d));
            } else {
                element = this.doc.createElement("ellipse");
                element.setAttribute("cx", "" + this.dc.toAbsoluteX((int)d3));
                element.setAttribute("cy", "" + this.dc.toAbsoluteY((int)d4));
                element.setAttribute("rx", "" + this.dc.toRelativeX((int)d));
                element.setAttribute("ry", "" + this.dc.toRelativeY((int)d2));
            }
        } else {
            double d5 = Math.atan2(((double)n6 - d4) * d, ((double)n5 - d3) * d2);
            double d6 = d * Math.cos(d5);
            double d7 = d2 * Math.sin(d5);
            double d8 = Math.atan2(((double)n8 - d4) * d, ((double)n7 - d3) * d2);
            double d9 = d * Math.cos(d8);
            double d10 = d2 * Math.sin(d8);
            double d11 = Math.atan2((d9 - d6) * -d7 - (d10 - d7) * -d6, (d9 - d6) * -d6 + (d10 - d7) * -d7);
            element = this.doc.createElement("path");
            element.setAttribute("d", "M " + this.dc.toAbsoluteX(Math.round(d6 + d3)) + "," + this.dc.toAbsoluteY(Math.round(d7 + d4)) + " A " + this.dc.toRelativeX((int)d) + "," + this.dc.toRelativeY((int)d2) + " 0 " + (d11 > 0.0 ? "1" : "0") + " 0" + " " + this.dc.toAbsoluteX(Math.round(d9 + d3)) + "," + this.dc.toAbsoluteY(Math.round(d10 + d4)));
        }
        if (this.dc.getPen() != null) {
            element.setAttribute("class", this.getClassString(this.dc.getPen()));
        }
        element.setAttribute("fill", "none");
        this.parentNode.appendChild(element);
    }

    public void bitBlt(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, long l) {
        this.bmpToSvg(byArray, n, n2, n3, n4, n5, n6, n3, n4, 0, l);
    }

    public void chord(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        double d = (double)(Math.abs(n3 - n) - 1) / 2.0;
        double d2 = (double)(Math.abs(n4 - n2) - 1) / 2.0;
        if (d <= 0.0 || d2 <= 0.0) {
            return;
        }
        double d3 = (double)Math.min(n, n3) + d;
        double d4 = (double)Math.min(n2, n4) + d2;
        Element element = null;
        if (n5 == n7 && n6 == n8) {
            if (d == d2) {
                element = this.doc.createElement("circle");
                element.setAttribute("cx", "" + this.dc.toAbsoluteX((int)d3));
                element.setAttribute("cy", "" + this.dc.toAbsoluteY((int)d4));
                element.setAttribute("r", "" + this.dc.toRelativeX((int)d));
            } else {
                element = this.doc.createElement("ellipse");
                element.setAttribute("cx", "" + this.dc.toAbsoluteX((int)d3));
                element.setAttribute("cy", "" + this.dc.toAbsoluteY((int)d4));
                element.setAttribute("rx", "" + this.dc.toRelativeX((int)d));
                element.setAttribute("ry", "" + this.dc.toRelativeY((int)d2));
            }
        } else {
            double d5 = Math.atan2(((double)n6 - d4) * d, ((double)n5 - d3) * d2);
            double d6 = d * Math.cos(d5);
            double d7 = d2 * Math.sin(d5);
            double d8 = Math.atan2(((double)n8 - d4) * d, ((double)n7 - d3) * d2);
            double d9 = d * Math.cos(d8);
            double d10 = d2 * Math.sin(d8);
            double d11 = Math.atan2((d9 - d6) * -d7 - (d10 - d7) * -d6, (d9 - d6) * -d6 + (d10 - d7) * -d7);
            element = this.doc.createElement("path");
            element.setAttribute("d", "M " + this.dc.toAbsoluteX(Math.round(d6 + d3)) + "," + this.dc.toAbsoluteY(Math.round(d7 + d4)) + " A " + this.dc.toRelativeX((int)d) + "," + this.dc.toRelativeY((int)d2) + " 0 " + (d11 > 0.0 ? "1" : "0") + " 0" + " " + this.dc.toAbsoluteX(Math.round(d9 + d3)) + "," + this.dc.toAbsoluteY(Math.round(d10 + d4)) + " z");
        }
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            element.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String string = "pattern" + this.patternNo++;
                element.setAttribute("fill", "url(#" + string + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(string));
            }
        }
        this.parentNode.appendChild(element);
    }

    public GdiBrush createBrushIndirect(int n, int n2, int n3) {
        SvgBrush svgBrush = new SvgBrush(this, n, n2, n3);
        if (!this.nameMap.containsKey(svgBrush)) {
            String string = "brush" + this.brushNo++;
            this.nameMap.put(svgBrush, string);
            this.styleNode.appendChild(svgBrush.createTextNode(string));
        }
        return svgBrush;
    }

    public GdiFont createFontIndirect(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, int n6, int n7, int n8, int n9, int n10, byte[] byArray) {
        SvgFont svgFont = new SvgFont(this, n, n2, n3, n4, n5, bl, bl2, bl3, n6, n7, n8, n9, n10, byArray);
        if (!this.nameMap.containsKey(svgFont)) {
            String string = "font" + this.fontNo++;
            this.nameMap.put(svgFont, string);
            this.styleNode.appendChild(svgFont.createTextNode(string));
        }
        return svgFont;
    }

    public GdiPalette createPalette(int n, int[] nArray) {
        return new SvgPalette(this, n, nArray);
    }

    public GdiPatternBrush createPatternBrush(byte[] byArray) {
        return new SvgPatternBrush(this, byArray);
    }

    public GdiPen createPenIndirect(int n, int n2, int n3) {
        SvgPen svgPen = new SvgPen(this, n, n2, n3);
        if (!this.nameMap.containsKey(svgPen)) {
            String string = "pen" + this.penNo++;
            this.nameMap.put(svgPen, string);
            this.styleNode.appendChild(svgPen.createTextNode(string));
        }
        return svgPen;
    }

    public GdiRegion createRectRgn(int n, int n2, int n3, int n4) {
        SvgRectRegion svgRectRegion = new SvgRectRegion(this, n, n2, n3, n4);
        if (!this.nameMap.containsKey(svgRectRegion)) {
            this.nameMap.put(svgRectRegion, "rgn" + this.rgnNo++);
            this.defsNode.appendChild(svgRectRegion.createElement());
        }
        return svgRectRegion;
    }

    public void deleteObject(GdiObject gdiObject) {
        if (this.dc.getBrush() == gdiObject) {
            this.dc.setBrush(this.defaultBrush);
        } else if (this.dc.getFont() == gdiObject) {
            this.dc.setFont(this.defaultFont);
        } else if (this.dc.getPen() == gdiObject) {
            this.dc.setPen(this.defaultPen);
        }
    }

    public void dibBitBlt(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, long l) {
        this.bitBlt(byArray, n, n2, n3, n4, n5, n6, l);
    }

    public GdiPatternBrush dibCreatePatternBrush(byte[] byArray, int n) {
        return new SvgPatternBrush(this, byArray);
    }

    public void dibStretchBlt(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l) {
        this.stretchDIBits(n, n2, n3, n4, n5, n6, n7, n8, byArray, 0, l);
    }

    public void ellipse(int n, int n2, int n3, int n4) {
        Element element = this.doc.createElement("ellipse");
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            element.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String string = "pattern" + this.patternNo++;
                element.setAttribute("fill", "url(#" + string + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(string));
            }
        }
        element.setAttribute("cx", "" + this.dc.toAbsoluteX((n + n3) / 2));
        element.setAttribute("cy", "" + this.dc.toAbsoluteY((n2 + n4) / 2));
        element.setAttribute("rx", "" + this.dc.toRelativeX((n3 - n) / 2));
        element.setAttribute("ry", "" + this.dc.toRelativeY((n4 - n2) / 2));
        this.parentNode.appendChild(element);
    }

    public void escape(byte[] byArray) {
    }

    public int excludeClipRect(int n, int n2, int n3, int n4) {
        Element element = this.dc.getMask();
        if (element != null) {
            element = (Element)element.cloneNode(true);
            String string = "mask" + this.maskNo++;
            element.setAttribute("id", string);
            this.defsNode.appendChild(element);
            Element element2 = this.doc.createElement("rect");
            element2.setAttribute("x", "" + this.dc.toAbsoluteX(n));
            element2.setAttribute("y", "" + this.dc.toAbsoluteY(n2));
            element2.setAttribute("width", "" + this.dc.toRelativeX(n3 - n));
            element2.setAttribute("height", "" + this.dc.toRelativeY(n4 - n2));
            element2.setAttribute("fill", "black");
            element.appendChild(element2);
            this.dc.setMask(element);
            return 3;
        }
        return 1;
    }

    public void extFloodFill(int n, int n2, int n3, int n4) {
        log.fine("not implemented: extFloodFill");
    }

    public void extTextOut(int n, int n2, int n3, int[] nArray, byte[] byArray, int[] nArray2) {
        Element element;
        String string;
        int n4;
        int n5;
        Element element2 = this.doc.createElement("text");
        int n6 = 0;
        boolean bl = false;
        if (this.dc.getFont() != null) {
            element2.setAttribute("class", this.getClassString(this.dc.getFont()));
            if (this.dc.getFont().getFaceName().startsWith("@")) {
                bl = true;
                n6 = this.dc.getFont().getEscapement() - 2700;
            } else {
                n6 = this.dc.getFont().getEscapement();
            }
        }
        element2.setAttribute("fill", SvgObject.toColor(this.dc.getTextColor()));
        this.buffer.setLength(0);
        int n7 = this.dc.getTextAlign();
        if ((n7 & 6) == 2) {
            this.buffer.append("text-anchor: end; ");
        } else if ((n7 & 6) == 6) {
            this.buffer.append("text-anchor: middle; ");
        }
        if (this.compatible) {
            this.buffer.append("dominant-baseline: baseline; ");
        } else if (bl) {
            element2.setAttribute("writing-mode", "tb");
        } else if ((n7 & 0x18) == 24) {
            this.buffer.append("dominant-baseline: baseline; ");
        } else {
            this.buffer.append("dominant-baseline: text-before-edge; ");
        }
        if ((n7 & 0x100) == 256 || (n3 & 0x80) > 0) {
            this.buffer.append("unicode-bidi: bidi-override; direction: rtl; ");
        }
        if (this.dc.getTextSpace() > 0) {
            this.buffer.append("word-spacing: ").append(this.dc.getTextSpace()).append("; ");
        }
        if (this.buffer.length() > 0) {
            this.buffer.setLength(this.buffer.length() - 1);
            element2.setAttribute("style", this.buffer.toString());
        }
        element2.setAttribute("stroke", "none");
        if ((n7 & 1) == 1) {
            n = this.dc.getCurrentX();
            n2 = this.dc.getCurrentY();
        }
        int n8 = this.dc.toAbsoluteX(n);
        int n9 = 0;
        if (bl) {
            element2.setAttribute("x", Integer.toString(n8));
            if (this.dc.getFont() != null) {
                n9 = this.dc.getFont().getFontSize();
            }
        } else {
            if (this.dc.getFont() != null) {
                nArray2 = this.dc.getFont().validateDx(byArray, nArray2);
            }
            if (nArray2 != null && nArray2.length > 0) {
                for (n5 = 0; n5 < nArray2.length; ++n5) {
                    n9 += nArray2[n5];
                }
                n5 = n;
                if ((n7 & 6) == 2) {
                    n5 -= n9 - nArray2[nArray2.length - 1];
                } else if ((n7 & 6) == 6) {
                    n5 -= (n9 - nArray2[nArray2.length - 1]) / 2;
                }
                this.buffer.setLength(0);
                for (n4 = 0; n4 < nArray2.length; ++n4) {
                    if (n4 > 0) {
                        this.buffer.append(" ");
                    }
                    this.buffer.append(this.dc.toAbsoluteX(n5));
                    n5 += nArray2[n4];
                }
                if ((n7 & 1) == 1) {
                    this.dc.moveToEx(n5, n2, null);
                }
                element2.setAttribute("x", this.buffer.toString());
            } else {
                if (this.dc.getFont() != null) {
                    n9 = this.dc.getFont().getFontSize() * byArray.length / 2;
                }
                element2.setAttribute("x", Integer.toString(n8));
            }
        }
        n5 = this.dc.toAbsoluteY(n2);
        n4 = 0;
        if (bl) {
            if (this.dc.getFont() != null) {
                nArray2 = this.dc.getFont().validateDx(byArray, nArray2);
            }
            this.buffer.setLength(0);
            if (n7 == 0) {
                this.buffer.append(n5 + Math.abs(this.dc.toRelativeY(this.dc.getFont().getHeight())));
            } else {
                this.buffer.append(n5);
            }
            if (nArray2 != null && nArray2.length > 0) {
                int n10;
                for (n10 = 0; n10 < nArray2.length - 1; ++n10) {
                    n4 += nArray2[n10];
                }
                n10 = n2;
                if ((n7 & 6) == 2) {
                    n10 -= n4 - nArray2[nArray2.length - 1];
                } else if ((n7 & 6) == 6) {
                    n10 -= (n4 - nArray2[nArray2.length - 1]) / 2;
                }
                for (int i = 0; i < nArray2.length; ++i) {
                    this.buffer.append(" ");
                    this.buffer.append(this.dc.toAbsoluteY(n10));
                    n10 += nArray2[i];
                }
                if ((n7 & 1) == 1) {
                    this.dc.moveToEx(n, n10, null);
                }
            } else if (this.dc.getFont() != null) {
                n4 = this.dc.getFont().getFontSize() * byArray.length / 2;
            }
            element2.setAttribute("y", this.buffer.toString());
        } else {
            if (this.dc.getFont() != null) {
                n4 = this.dc.getFont().getFontSize();
            }
            if (this.compatible) {
                if ((n7 & 0x18) == 0) {
                    element2.setAttribute("y", Integer.toString(n5 + Math.abs(this.dc.toRelativeY((double)n4 * 0.88))));
                } else if ((n7 & 0x18) == 8) {
                    element2.setAttribute("y", Integer.toString(n5 + nArray[3] - nArray[1] + Math.abs(this.dc.toRelativeY((double)n4 * 0.88))));
                } else {
                    element2.setAttribute("y", Integer.toString(n5));
                }
            } else if ((n7 & 0x18) == 8 && nArray != null) {
                element2.setAttribute("y", Integer.toString(n5 + nArray[3] - nArray[1] - Math.abs(this.dc.toRelativeY(n4))));
            } else {
                element2.setAttribute("y", Integer.toString(n5));
            }
        }
        Element element3 = null;
        if (this.dc.getBkMode() == 2 || (n3 & 2) > 0) {
            if (nArray == null && this.dc.getFont() != null) {
                nArray = new int[4];
                if (bl) {
                    nArray[0] = n - (int)((double)n9 * 0.85);
                    nArray[0] = (n7 & 6) == 2 ? n2 - n4 : ((n7 & 6) == 6 ? n2 - n4 / 2 : n2);
                } else {
                    nArray[0] = (n7 & 6) == 2 ? n - n9 : ((n7 & 6) == 6 ? n - n9 / 2 : n);
                    nArray[1] = n2 - (int)((double)n4 * 0.85);
                }
                nArray[2] = n9;
                nArray[3] = n4;
            }
            element3 = this.doc.createElement("rect");
            element3.setAttribute("x", Integer.toString(this.dc.toAbsoluteX(nArray[0])));
            element3.setAttribute("y", Integer.toString(this.dc.toAbsoluteY(nArray[1])));
            element3.setAttribute("width", Integer.toString(this.dc.toRelativeX(nArray[2] - nArray[0])));
            element3.setAttribute("height", Integer.toString(this.dc.toRelativeY(nArray[3] - nArray[1])));
            element3.setAttribute("fill", SvgObject.toColor(this.dc.getBkColor()));
        }
        Element element4 = null;
        if ((n3 & 4) > 0) {
            string = "clipPath" + this.clipPathNo++;
            element4 = this.doc.createElement("clipPath");
            element4.setAttribute("id", string);
            element4.setIdAttribute("id", true);
            element = this.doc.createElement("rect");
            element.setAttribute("x", Integer.toString(this.dc.toAbsoluteX(nArray[0])));
            element.setAttribute("y", Integer.toString(this.dc.toAbsoluteY(nArray[1])));
            element.setAttribute("width", Integer.toString(this.dc.toRelativeX(nArray[2] - nArray[0])));
            element.setAttribute("height", Integer.toString(this.dc.toRelativeY(nArray[3] - nArray[1])));
            element4.appendChild(element);
            element2.setAttribute("clip-path", "url(#" + string + ")");
        }
        string = null;
        string = this.dc.getFont() != null ? GdiUtils.convertString(byArray, this.dc.getFont().getCharset()) : GdiUtils.convertString(byArray, 1);
        if (this.dc.getFont() != null && this.dc.getFont().getLang() != null) {
            element2.setAttribute("xml:lang", this.dc.getFont().getLang());
        }
        element2.setAttribute("xml:space", "preserve");
        if (this.compatible) {
            string = string.replaceAll("\\r\\n|[\\t\\r\\n ]", "\u00a0");
        }
        element2.appendChild(this.doc.createTextNode(string));
        if (element3 != null || element4 != null) {
            element = this.doc.createElement("g");
            if (element3 != null) {
                element.appendChild(element3);
            }
            if (element4 != null) {
                element.appendChild(element4);
            }
            element.appendChild(element2);
            element2 = element;
        }
        if (n6 != 0) {
            element2.setAttribute("transform", "rotate(" + (double)(-n6) / 10.0 + ", " + n8 + ", " + n5 + ")");
        }
        this.parentNode.appendChild(element2);
    }

    public void fillRgn(GdiRegion gdiRegion, GdiBrush gdiBrush) {
        if (gdiRegion == null) {
            return;
        }
        Element element = this.doc.createElement("use");
        element.setAttribute("xlink:href", "url(#" + this.nameMap.get(gdiRegion) + ")");
        element.setAttribute("class", this.getClassString(gdiBrush));
        SvgBrush svgBrush = (SvgBrush)gdiBrush;
        if (svgBrush.getStyle() == 2) {
            String string = "pattern" + this.patternNo++;
            element.setAttribute("fill", "url(#" + string + ")");
            this.defsNode.appendChild(svgBrush.createFillPattern(string));
        }
        this.parentNode.appendChild(element);
    }

    public void floodFill(int n, int n2, int n3) {
        log.fine("not implemented: floodFill");
    }

    public void frameRgn(GdiRegion gdiRegion, GdiBrush gdiBrush, int n, int n2) {
        log.fine("not implemented: frameRgn");
    }

    public void intersectClipRect(int n, int n2, int n3, int n4) {
        log.fine("not implemented: intersectClipRect");
    }

    public void invertRgn(GdiRegion gdiRegion) {
        if (gdiRegion == null) {
            return;
        }
        Element element = this.doc.createElement("use");
        element.setAttribute("xlink:href", "url(#" + this.nameMap.get(gdiRegion) + ")");
        String string = this.dc.getRopFilter(0x550009L);
        if (string != null) {
            element.setAttribute("filter", string);
        }
        this.parentNode.appendChild(element);
    }

    public void lineTo(int n, int n2) {
        Element element = this.doc.createElement("line");
        if (this.dc.getPen() != null) {
            element.setAttribute("class", this.getClassString(this.dc.getPen()));
        }
        element.setAttribute("fill", "none");
        element.setAttribute("x1", "" + this.dc.toAbsoluteX(this.dc.getCurrentX()));
        element.setAttribute("y1", "" + this.dc.toAbsoluteY(this.dc.getCurrentY()));
        element.setAttribute("x2", "" + this.dc.toAbsoluteX(n));
        element.setAttribute("y2", "" + this.dc.toAbsoluteY(n2));
        this.parentNode.appendChild(element);
        this.dc.moveToEx(n, n2, null);
    }

    public void moveToEx(int n, int n2, Point point) {
        this.dc.moveToEx(n, n2, point);
    }

    public void offsetClipRgn(int n, int n2) {
        this.dc.offsetClipRgn(n, n2);
        Element element = this.dc.getMask();
        if (element != null) {
            element = (Element)element.cloneNode(true);
            String string = "mask" + this.maskNo++;
            element.setAttribute("id", string);
            if (this.dc.getOffsetClipX() != 0 || this.dc.getOffsetClipY() != 0) {
                element.setAttribute("transform", "translate(" + this.dc.getOffsetClipX() + "," + this.dc.getOffsetClipY() + ")");
            }
            this.defsNode.appendChild(element);
            if (!this.parentNode.hasChildNodes()) {
                this.doc.getDocumentElement().removeChild(this.parentNode);
            }
            this.parentNode = this.doc.createElement("g");
            this.parentNode.setAttribute("mask", string);
            this.doc.getDocumentElement().appendChild(this.parentNode);
            this.dc.setMask(element);
        }
    }

    public void offsetViewportOrgEx(int n, int n2, Point point) {
        this.dc.offsetViewportOrgEx(n, n2, point);
    }

    public void offsetWindowOrgEx(int n, int n2, Point point) {
        this.dc.offsetWindowOrgEx(n, n2, point);
    }

    public void paintRgn(GdiRegion gdiRegion) {
        this.fillRgn(gdiRegion, this.dc.getBrush());
    }

    public void patBlt(int n, int n2, int n3, int n4, long l) {
        log.fine("not implemented: patBlt");
    }

    public void pie(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        double d = (double)(Math.abs(n3 - n) - 1) / 2.0;
        double d2 = (double)(Math.abs(n4 - n2) - 1) / 2.0;
        if (d <= 0.0 || d2 <= 0.0) {
            return;
        }
        double d3 = (double)Math.min(n, n3) + d;
        double d4 = (double)Math.min(n2, n4) + d2;
        Element element = null;
        if (n5 == n7 && n6 == n8) {
            if (d == d2) {
                element = this.doc.createElement("circle");
                element.setAttribute("cx", "" + this.dc.toAbsoluteX((int)d3));
                element.setAttribute("cy", "" + this.dc.toAbsoluteY((int)d4));
                element.setAttribute("r", "" + this.dc.toRelativeX((int)d));
            } else {
                element = this.doc.createElement("ellipse");
                element.setAttribute("cx", "" + this.dc.toAbsoluteX((int)d3));
                element.setAttribute("cy", "" + this.dc.toAbsoluteY((int)d4));
                element.setAttribute("rx", "" + this.dc.toRelativeX((int)d));
                element.setAttribute("ry", "" + this.dc.toRelativeY((int)d2));
            }
        } else {
            double d5 = Math.atan2(((double)n6 - d4) * d, ((double)n5 - d3) * d2);
            double d6 = d * Math.cos(d5);
            double d7 = d2 * Math.sin(d5);
            double d8 = Math.atan2(((double)n8 - d4) * d, ((double)n7 - d3) * d2);
            double d9 = d * Math.cos(d8);
            double d10 = d2 * Math.sin(d8);
            double d11 = Math.atan2((d9 - d6) * -d7 - (d10 - d7) * -d6, (d9 - d6) * -d6 + (d10 - d7) * -d7);
            element = this.doc.createElement("path");
            element.setAttribute("d", "M " + this.dc.toAbsoluteX(Math.round(d6 + d3)) + "," + this.dc.toAbsoluteY(Math.round(d7 + d4)) + " L " + this.dc.toAbsoluteX(Math.round(d6 + d3)) + "," + this.dc.toAbsoluteY(Math.round(d7 + d4)) + " A " + this.dc.toRelativeX((int)d) + "," + this.dc.toRelativeY((int)d2) + " 0 " + (d11 > 0.0 ? "1" : "0") + " 0" + " " + this.dc.toAbsoluteX(Math.round(d9 + d3)) + "," + this.dc.toAbsoluteY(Math.round(d10 + d4)) + " z");
        }
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            element.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String string = "pattern" + this.patternNo++;
                element.setAttribute("fill", "url(#" + string + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(string));
            }
        }
        this.parentNode.appendChild(element);
    }

    public void polygon(Point[] pointArray) {
        Element element = this.doc.createElement("polygon");
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            element.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String string = "pattern" + this.patternNo++;
                element.setAttribute("fill", "url(#" + string + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(string));
            }
            if (this.dc.getPolyFillMode() == 2) {
                element.setAttribute("fill-rule", "nonzero");
            }
        }
        this.buffer.setLength(0);
        for (int i = 0; i < pointArray.length; ++i) {
            if (i != 0) {
                this.buffer.append(" ");
            }
            this.buffer.append(this.dc.toAbsoluteX(pointArray[i].x)).append(",");
            this.buffer.append(this.dc.toAbsoluteY(pointArray[i].y));
        }
        element.setAttribute("points", this.buffer.toString());
        this.parentNode.appendChild(element);
    }

    public void polyline(Point[] pointArray) {
        Element element = this.doc.createElement("polyline");
        if (this.dc.getPen() != null) {
            element.setAttribute("class", this.getClassString(this.dc.getPen()));
        }
        element.setAttribute("fill", "none");
        this.buffer.setLength(0);
        for (int i = 0; i < pointArray.length; ++i) {
            if (i != 0) {
                this.buffer.append(" ");
            }
            this.buffer.append(this.dc.toAbsoluteX(pointArray[i].x)).append(",");
            this.buffer.append(this.dc.toAbsoluteY(pointArray[i].y));
        }
        element.setAttribute("points", this.buffer.toString());
        this.parentNode.appendChild(element);
    }

    public void polyPolygon(Point[][] pointArray) {
        Element element = this.doc.createElement("path");
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            element.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String string = "pattern" + this.patternNo++;
                element.setAttribute("fill", "url(#" + string + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(string));
            }
            if (this.dc.getPolyFillMode() == 2) {
                element.setAttribute("fill-rule", "nonzero");
            }
        }
        this.buffer.setLength(0);
        for (int i = 0; i < pointArray.length; ++i) {
            if (i != 0) {
                this.buffer.append(" ");
            }
            for (int j = 0; j < pointArray[i].length; ++j) {
                if (j == 0) {
                    this.buffer.append("M ");
                } else if (j == 1) {
                    this.buffer.append(" L ");
                }
                this.buffer.append(this.dc.toAbsoluteX(pointArray[i][j].x)).append(",");
                this.buffer.append(this.dc.toAbsoluteY(pointArray[i][j].y)).append(" ");
                if (j != pointArray[i].length - 1) continue;
                this.buffer.append("z");
            }
        }
        element.setAttribute("d", this.buffer.toString());
        this.parentNode.appendChild(element);
    }

    public void realizePalette() {
        log.fine("not implemented: realizePalette");
    }

    public void restoreDC(int n) {
        int n2 = n < 0 ? -n : this.saveDC.size() - n;
        for (int i = 0; i < n2; ++i) {
            this.dc = (SvgDc)this.saveDC.removeLast();
        }
        if (!this.parentNode.hasChildNodes()) {
            this.doc.getDocumentElement().removeChild(this.parentNode);
        }
        this.parentNode = this.doc.createElement("g");
        Element element = this.dc.getMask();
        if (element != null) {
            this.parentNode.setAttribute("mask", "url(#" + element.getAttribute("id") + ")");
        }
        this.doc.getDocumentElement().appendChild(this.parentNode);
    }

    public void rectangle(int n, int n2, int n3, int n4) {
        Element element = this.doc.createElement("rect");
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            element.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String string = "pattern" + this.patternNo++;
                element.setAttribute("fill", "url(#" + string + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(string));
            }
        }
        element.setAttribute("x", "" + this.dc.toAbsoluteX(n));
        element.setAttribute("y", "" + this.dc.toAbsoluteY(n2));
        element.setAttribute("width", "" + this.dc.toRelativeX(n3 - n));
        element.setAttribute("height", "" + this.dc.toRelativeY(n4 - n2));
        this.parentNode.appendChild(element);
    }

    public void resizePalette(GdiPalette gdiPalette) {
        log.fine("not implemented: ResizePalette");
    }

    public void roundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        Element element = this.doc.createElement("rect");
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            element.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String string = "pattern" + this.patternNo++;
                element.setAttribute("fill", "url(#" + string + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(string));
            }
        }
        element.setAttribute("x", "" + this.dc.toAbsoluteX(n));
        element.setAttribute("y", "" + this.dc.toAbsoluteY(n2));
        element.setAttribute("width", "" + this.dc.toRelativeX(n3 - n));
        element.setAttribute("height", "" + this.dc.toRelativeY(n4 - n2));
        element.setAttribute("rx", "" + this.dc.toRelativeX(n5));
        element.setAttribute("ry", "" + this.dc.toRelativeY(n6));
        this.parentNode.appendChild(element);
    }

    public void seveDC() {
        this.saveDC.add(this.dc.clone());
    }

    public void scaleViewportExtEx(int n, int n2, int n3, int n4, Size size) {
        this.dc.scaleViewportExtEx(n, n2, n3, n4, size);
    }

    public void scaleWindowExtEx(int n, int n2, int n3, int n4, Size size) {
        this.dc.scaleWindowExtEx(n, n2, n3, n4, size);
    }

    public void selectClipRgn(GdiRegion gdiRegion) {
        if (!this.parentNode.hasChildNodes()) {
            this.doc.getDocumentElement().removeChild(this.parentNode);
        }
        this.parentNode = this.doc.createElement("g");
        if (gdiRegion != null) {
            Element element = this.doc.createElement("mask");
            element.setAttribute("id", "mask" + this.maskNo++);
            element.setIdAttribute("id", true);
            if (this.dc.getOffsetClipX() != 0 || this.dc.getOffsetClipY() != 0) {
                element.setAttribute("transform", "translate(" + this.dc.getOffsetClipX() + "," + this.dc.getOffsetClipY() + ")");
            }
            this.defsNode.appendChild(element);
            Element element2 = this.doc.createElement("use");
            element2.setAttribute("xlink:href", "url(#" + this.nameMap.get(gdiRegion) + ")");
            element2.setAttribute("fill", "white");
            element.appendChild(element2);
            this.parentNode.setAttribute("mask", "url(#" + element.getAttribute("id") + ")");
        }
        this.doc.getDocumentElement().appendChild(this.parentNode);
    }

    public void selectObject(GdiObject gdiObject) {
        if (gdiObject instanceof SvgBrush) {
            this.dc.setBrush((SvgBrush)gdiObject);
        } else if (gdiObject instanceof SvgFont) {
            this.dc.setFont((SvgFont)gdiObject);
        } else if (gdiObject instanceof SvgPen) {
            this.dc.setPen((SvgPen)gdiObject);
        }
    }

    public void selectPalette(GdiPalette gdiPalette, boolean bl) {
        log.fine("not implemented: selectPalette");
    }

    public void setBkColor(int n) {
        this.dc.setBkColor(n);
    }

    public void setBkMode(int n) {
        this.dc.setBkMode(n);
    }

    public void setDIBitsToDevice(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray, int n9) {
        this.stretchDIBits(n, n2, n3, n4, n5, n6, n3, n4, byArray, n9, 0xCC0020L);
    }

    public void setLayout(long l) {
        this.dc.setLayout(l);
    }

    public void setMapMode(int n) {
        this.dc.setMapMode(n);
    }

    public void setMapperFlags(long l) {
        this.dc.setMapperFlags(l);
    }

    public void setPaletteEntries(GdiPalette gdiPalette, int n, int[] nArray) {
        log.fine("not implemented: setPaletteEntries");
    }

    public void setPixel(int n, int n2, int n3) {
        Element element = this.doc.createElement("rect");
        element.setAttribute("stroke", "none");
        element.setAttribute("fill", SvgPen.toColor(n3));
        element.setAttribute("x", "" + this.dc.toAbsoluteX(n));
        element.setAttribute("y", "" + this.dc.toAbsoluteY(n2));
        element.setAttribute("width", "" + this.dc.toRelativeX(1.0));
        element.setAttribute("height", "" + this.dc.toRelativeY(1.0));
        this.parentNode.appendChild(element);
    }

    public void setPolyFillMode(int n) {
        this.dc.setPolyFillMode(n);
    }

    public void setRelAbs(int n) {
        this.dc.setRelAbs(n);
    }

    public void setROP2(int n) {
        this.dc.setROP2(n);
    }

    public void setStretchBltMode(int n) {
        this.dc.setStretchBltMode(n);
    }

    public void setTextAlign(int n) {
        this.dc.setTextAlign(n);
    }

    public void setTextCharacterExtra(int n) {
        this.dc.setTextCharacterExtra(n);
    }

    public void setTextColor(int n) {
        this.dc.setTextColor(n);
    }

    public void setTextJustification(int n, int n2) {
        if (n2 > 0) {
            this.dc.setTextSpace(Math.abs(this.dc.toRelativeX(n)) / n2);
        }
    }

    public void setViewportExtEx(int n, int n2, Size size) {
        this.dc.setViewportExtEx(n, n2, size);
    }

    public void setViewportOrgEx(int n, int n2, Point point) {
        this.dc.setViewportOrgEx(n, n2, point);
    }

    public void setWindowExtEx(int n, int n2, Size size) {
        this.dc.setWindowExtEx(n, n2, size);
    }

    public void setWindowOrgEx(int n, int n2, Point point) {
        this.dc.setWindowOrgEx(n, n2, point);
    }

    public void stretchBlt(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l) {
        this.dibStretchBlt(byArray, n, n2, n3, n4, n5, n6, n7, n8, l);
    }

    public void stretchDIBits(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray, int n9, long l) {
        this.bmpToSvg(byArray, n, n2, n3, n4, n5, n6, n7, n8, n9, l);
    }

    public void textOut(int n, int n2, byte[] byArray) {
        Element element = this.doc.createElement("text");
        int n3 = 0;
        boolean bl = false;
        if (this.dc.getFont() != null) {
            element.setAttribute("class", this.getClassString(this.dc.getFont()));
            if (this.dc.getFont().getFaceName().startsWith("@")) {
                bl = true;
                n3 = this.dc.getFont().getEscapement() - 2700;
            } else {
                n3 = this.dc.getFont().getEscapement();
            }
        }
        element.setAttribute("fill", SvgObject.toColor(this.dc.getTextColor()));
        this.buffer.setLength(0);
        int n4 = this.dc.getTextAlign();
        if ((n4 & 6) == 2) {
            this.buffer.append("text-anchor: end; ");
        } else if ((n4 & 6) == 6) {
            this.buffer.append("text-anchor: middle; ");
        }
        if (bl) {
            element.setAttribute("writing-mode", "tb");
            this.buffer.append("dominant-baseline: ideographic; ");
        } else if ((n4 & 0x18) == 24) {
            this.buffer.append("dominant-baseline: baseline; ");
        } else {
            this.buffer.append("dominant-baseline: text-before-edge; ");
        }
        if ((n4 & 0x100) == 256) {
            this.buffer.append("unicode-bidi: bidi-override; direction: rtl; ");
        }
        if (this.dc.getTextSpace() > 0) {
            this.buffer.append("word-spacing: " + this.dc.getTextSpace() + "; ");
        }
        if (this.buffer.length() > 0) {
            this.buffer.setLength(this.buffer.length() - 1);
            element.setAttribute("style", this.buffer.toString());
        }
        element.setAttribute("stroke", "none");
        int n5 = this.dc.toAbsoluteX(n);
        int n6 = this.dc.toAbsoluteY(n2);
        element.setAttribute("x", Integer.toString(n5));
        element.setAttribute("y", Integer.toString(n6));
        if (n3 != 0) {
            element.setAttribute("transform", "rotate(" + (double)(-n3) / 10.0 + ", " + n5 + ", " + n6 + ")");
        }
        String string = null;
        string = this.dc.getFont() != null ? GdiUtils.convertString(byArray, this.dc.getFont().getCharset()) : GdiUtils.convertString(byArray, 1);
        if (this.dc.getTextCharacterExtra() != 0) {
            this.buffer.setLength(0);
            for (int i = 0; i < string.length() - 1; ++i) {
                if (i != 0) {
                    this.buffer.append(" ");
                }
                this.buffer.append(this.dc.toRelativeX(this.dc.getTextCharacterExtra()));
            }
            element.setAttribute("dx", this.buffer.toString());
        }
        if (this.dc.getFont() != null && this.dc.getFont().getLang() != null) {
            element.setAttribute("xml:lang", this.dc.getFont().getLang());
        }
        element.setAttribute("xml:space", "preserve");
        if (this.compatible) {
            string = string.replaceAll("\\r\\n|[\\t\\r\\n ]", "\u00a0");
        }
        element.appendChild(this.doc.createTextNode(string));
        this.parentNode.appendChild(element);
    }

    public void footer() {
        Element element = this.doc.getDocumentElement();
        if (!element.hasAttribute("width") && this.dc.getWindowWidth() != 0) {
            element.setAttribute("width", "" + Math.abs(this.dc.getWindowWidth()));
        }
        if (!element.hasAttribute("height") && this.dc.getWindowHeight() != 0) {
            element.setAttribute("height", "" + Math.abs(this.dc.getWindowHeight()));
        }
        if (this.dc.getWindowWidth() != 0 && this.dc.getWindowHeight() != 0) {
            element.setAttribute("viewBox", "0 0 " + Math.abs(this.dc.getWindowWidth()) + " " + Math.abs(this.dc.getWindowHeight()));
            element.setAttribute("preserveAspectRatio", "none");
        }
        element.setAttribute("stroke-linecap", "round");
        element.setAttribute("fill-rule", "evenodd");
        if (!this.styleNode.hasChildNodes()) {
            element.removeChild(this.styleNode);
        } else {
            this.styleNode.insertBefore(this.doc.createTextNode("\n"), this.styleNode.getFirstChild());
        }
        if (!this.defsNode.hasChildNodes()) {
            element.removeChild(this.defsNode);
        }
    }

    private String getClassString(GdiObject gdiObject, GdiObject gdiObject2) {
        String string = this.getClassString(gdiObject);
        String string2 = this.getClassString(gdiObject2);
        if (string != null && string2 != null) {
            return string + " " + string2;
        }
        if (string != null) {
            return string;
        }
        if (string2 != null) {
            return string2;
        }
        return "";
    }

    private String getClassString(GdiObject gdiObject) {
        if (gdiObject == null) {
            return "";
        }
        return (String)this.nameMap.get(gdiObject);
    }

    private void bmpToSvg(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l) {
        String string;
        if (byArray == null) {
            return;
        }
        byArray = ImageUtil.convert(this.dibToBmp(byArray), "png", n4 < 0);
        StringBuffer stringBuffer = new StringBuffer("data:image/png;base64,");
        stringBuffer.append(Base64.encode(byArray));
        String string2 = stringBuffer.toString();
        if (string2 == null || string2.equals("")) {
            return;
        }
        Element element = this.doc.createElement("image");
        if (n4 < 0) {
            element.setAttribute("x", "" + this.dc.toAbsoluteX(n));
            element.setAttribute("y", "" + this.dc.toAbsoluteY(n2 + n4));
            element.setAttribute("width", "" + this.dc.toRelativeX(n3));
            element.setAttribute("height", "" + this.dc.toRelativeY(-n4));
        } else {
            element.setAttribute("x", "" + this.dc.toAbsoluteX(n));
            element.setAttribute("y", "" + this.dc.toAbsoluteY(n2));
            element.setAttribute("width", "" + this.dc.toRelativeX(n3));
            element.setAttribute("height", "" + this.dc.toRelativeY(n4));
        }
        if (n5 != 0 || n6 != 0 || n7 != n3 || n8 != n4) {
            element.setAttribute("viewBox", "" + n5 + " " + n6 + " " + n7 + " " + n8);
            element.setAttribute("preserveAspectRatio", "none");
        }
        if ((string = this.dc.getRopFilter(l)) != null) {
            element.setAttribute("filter", string);
        }
        element.setAttribute("xlink:href", string2);
        this.parentNode.appendChild(element);
    }

    private byte[] dibToBmp(byte[] byArray) {
        byte[] byArray2 = new byte[14 + byArray.length];
        byArray2[0] = 66;
        byArray2[1] = 77;
        long l = byArray2.length;
        byArray2[2] = (byte)(l & 0xFFL);
        byArray2[3] = (byte)(l >> 8 & 0xFFL);
        byArray2[4] = (byte)(l >> 16 & 0xFFL);
        byArray2[5] = (byte)(l >> 24 & 0xFFL);
        byArray2[6] = 0;
        byArray2[7] = 0;
        byArray2[8] = 0;
        byArray2[9] = 0;
        long l2 = 14L;
        long l3 = (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8) + ((byArray[2] & 0xFF) << 16) + ((byArray[3] & 0xFF) << 24);
        l2 += l3;
        int n = (byArray[14] & 0xFF) + ((byArray[15] & 0xFF) << 8);
        long l4 = (byArray[32] & 0xFF) + ((byArray[33] & 0xFF) << 8) + ((byArray[34] & 0xFF) << 16) + ((byArray[35] & 0xFF) << 24);
        switch (n) {
            case 1: {
                l2 += 8L;
                break;
            }
            case 4: {
                l2 += 64L;
                break;
            }
            case 8: {
                l2 += 1024L;
                break;
            }
            case 16: {
                l2 += l4 == 0L ? 0L : 262144L;
                break;
            }
            case 24: {
                l2 += l4 == 0L ? 0L : 0x4000000L;
                break;
            }
            case 32: {
                l2 += l4 == 0L ? 0L : 0x400000000L;
            }
        }
        byArray2[10] = (byte)(l2 & 0xFFL);
        byArray2[11] = (byte)(l2 >> 8 & 0xFFL);
        byArray2[12] = (byte)(l2 >> 16 & 0xFFL);
        byArray2[13] = (byte)(l2 >> 24 & 0xFFL);
        System.arraycopy(byArray, 0, byArray2, 14, byArray.length);
        return byArray2;
    }
}

