/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.goca;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.afp.goca.AbstractGraphicsDrawingOrder;
import org.apache.xmlgraphics.java2d.color.CIELabColorSpace;
import org.apache.xmlgraphics.java2d.color.ColorUtil;
import org.apache.xmlgraphics.java2d.color.ColorWithAlternatives;

public class GraphicsSetProcessColor
extends AbstractGraphicsDrawingOrder {
    private static final byte RGB = 1;
    private static final byte CMYK = 4;
    private static final byte CIELAB = 8;
    private final Color color;
    private final int componentsSize;

    public GraphicsSetProcessColor(Color color) {
        ColorWithAlternatives cwa;
        Color alt;
        if (color instanceof ColorWithAlternatives && (alt = (cwa = (ColorWithAlternatives)color).getFirstAlternativeOfType(9)) != null) {
            this.color = alt;
            this.componentsSize = 4;
            return;
        }
        ColorSpace cs = color.getColorSpace();
        int colSpaceType = cs.getType();
        this.color = colSpaceType == 9 ? color : (cs instanceof CIELabColorSpace ? color : (!color.getColorSpace().isCS_sRGB() ? ColorUtil.toSRGBColor(color) : color));
        this.componentsSize = this.color.getColorSpace().getNumComponents();
    }

    public int getDataLength() {
        return 12 + this.componentsSize;
    }

    byte getOrderCode() {
        return -78;
    }

    public void writeToStream(OutputStream os) throws IOException {
        byte[] colsizes;
        byte colspace;
        float[] colorComponents = this.color.getColorComponents(null);
        ColorSpace cs = this.color.getColorSpace();
        int colSpaceType = cs.getType();
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        if (colSpaceType == 9) {
            colspace = 4;
            colsizes = new byte[]{8, 8, 8, 8};
            for (int i = 0; i < colorComponents.length; ++i) {
                baout.write(Math.round(colorComponents[i] * 255.0f));
            }
        } else if (colSpaceType == 5) {
            colspace = 1;
            colsizes = new byte[]{8, 8, 8, 0};
            for (int i = 0; i < colorComponents.length; ++i) {
                baout.write(Math.round(colorComponents[i] * 255.0f));
            }
        } else if (cs instanceof CIELabColorSpace) {
            colspace = 8;
            colsizes = new byte[]{8, 8, 8, 0};
            DataOutputStream dout = new DataOutputStream(baout);
            int l = Math.round(colorComponents[0] * 100.0f);
            int a = Math.round(colorComponents[1] * 255.0f) - 128;
            int b = Math.round(colorComponents[2] * 255.0f) - 128;
            dout.writeByte(l);
            dout.writeByte(a);
            dout.writeByte(b);
        } else {
            throw new IllegalStateException();
        }
        int len = this.getDataLength();
        byte[] data = new byte[]{this.getOrderCode(), (byte)(len - 2), 0, colspace, 0, 0, 0, 0, colsizes[0], colsizes[1], colsizes[2], colsizes[3]};
        os.write(data);
        baout.writeTo(os);
    }

    public String toString() {
        return "GraphicsSetProcessColor(col=" + this.color + ")";
    }
}

