/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.NamedCharacter;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.util.HexEncoder;

public class TTFFontLoader
extends FontLoader {
    private MultiByteFont multiFont;
    private SingleByteFont singleFont;
    private final String subFontName;
    private EncodingMode encodingMode;
    private EmbeddingMode embeddingMode;

    public TTFFontLoader(String fontFileURI, FontResolver resolver) {
        this(fontFileURI, null, true, EmbeddingMode.AUTO, EncodingMode.AUTO, true, true, resolver);
    }

    public TTFFontLoader(String fontFileURI, String subFontName, boolean embedded, EmbeddingMode embeddingMode, EncodingMode encodingMode, boolean useKerning, boolean useAdvanced, FontResolver resolver) {
        super(fontFileURI, embedded, useKerning, useAdvanced, resolver);
        this.subFontName = subFontName;
        this.encodingMode = encodingMode;
        this.embeddingMode = embeddingMode;
        if (this.encodingMode == EncodingMode.AUTO) {
            this.encodingMode = EncodingMode.CID;
        }
        if (this.embeddingMode == EmbeddingMode.AUTO) {
            this.embeddingMode = EmbeddingMode.SUBSET;
        }
    }

    protected void read() throws IOException {
        this.read(this.subFontName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(String ttcFontName) throws IOException {
        InputStream in = TTFFontLoader.openFontUri(this.resolver, this.fontFileURI);
        try {
            TTFFile ttf = new TTFFile(this.useKerning, this.useAdvanced);
            FontFileReader reader = new FontFileReader(in);
            boolean supported = ttf.readFont(reader, ttcFontName);
            if (!supported) {
                throw new IOException("TrueType font is not supported: " + this.fontFileURI);
            }
            this.buildFont(ttf, ttcFontName);
            this.loaded = true;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    private void buildFont(TTFFile ttf, String ttcFontName) {
        if (ttf.isCFF()) {
            throw new UnsupportedOperationException("OpenType fonts with CFF data are not supported, yet");
        }
        boolean isCid = this.embedded;
        if (this.encodingMode == EncodingMode.SINGLE_BYTE) {
            isCid = false;
        }
        if (isCid) {
            this.multiFont = new MultiByteFont();
            this.returnFont = this.multiFont;
            this.multiFont.setTTCName(ttcFontName);
        } else {
            this.singleFont = new SingleByteFont();
            this.returnFont = this.singleFont;
        }
        this.returnFont.setResolver(this.resolver);
        this.returnFont.setFontName(ttf.getPostScriptName());
        this.returnFont.setFullName(ttf.getFullName());
        this.returnFont.setFamilyNames(ttf.getFamilyNames());
        this.returnFont.setFontSubFamilyName(ttf.getSubFamilyName());
        this.returnFont.setCapHeight(ttf.getCapHeight());
        this.returnFont.setXHeight(ttf.getXHeight());
        this.returnFont.setAscender(ttf.getLowerCaseAscent());
        this.returnFont.setDescender(ttf.getLowerCaseDescent());
        this.returnFont.setFontBBox(ttf.getFontBBox());
        this.returnFont.setFlags(ttf.getFlags());
        this.returnFont.setStemV(Integer.parseInt(ttf.getStemV()));
        this.returnFont.setItalicAngle(Integer.parseInt(ttf.getItalicAngle()));
        this.returnFont.setMissingWidth(0);
        this.returnFont.setWeight(ttf.getWeightClass());
        this.returnFont.setEmbeddingMode(this.embeddingMode);
        if (isCid) {
            this.multiFont.setCIDType(CIDFontType.CIDTYPE2);
            int[] wx = ttf.getWidths();
            this.multiFont.setWidthArray(wx);
        } else {
            this.singleFont.setFontType(FontType.TRUETYPE);
            this.singleFont.setEncoding(ttf.getCharSetName());
            this.returnFont.setFirstChar(ttf.getFirstChar());
            this.returnFont.setLastChar(ttf.getLastChar());
            this.singleFont.setTrueTypePostScriptVersion(ttf.getPostScriptVersion());
            this.copyWidthsSingleByte(ttf);
        }
        this.returnFont.setCMap(this.getCMap(ttf));
        if (this.useKerning) {
            this.copyKerning(ttf, isCid);
        }
        if (this.useAdvanced) {
            this.copyAdvanced(ttf);
        }
        if (this.embedded) {
            if (ttf.isEmbeddable()) {
                this.returnFont.setEmbedFileName(this.fontFileURI);
            } else {
                String msg = "The font " + this.fontFileURI + " is not embeddable due to a" + " licensing restriction.";
                throw new RuntimeException(msg);
            }
        }
    }

    private CMapSegment[] getCMap(TTFFile ttf) {
        CMapSegment[] array = new CMapSegment[ttf.getCMaps().size()];
        return ttf.getCMaps().toArray(array);
    }

    private void copyWidthsSingleByte(TTFFile ttf) {
        int[] wx = ttf.getWidths();
        for (int i = this.singleFont.getFirstChar(); i <= this.singleFont.getLastChar(); ++i) {
            this.singleFont.setWidth(i, ttf.getCharWidth(i));
        }
        for (CMapSegment segment : ttf.getCMaps()) {
            if (segment.getUnicodeStart() >= 65534) continue;
            for (char u = (char)segment.getUnicodeStart(); u <= segment.getUnicodeEnd(); u = (char)(u + '\u0001')) {
                char codePoint = this.singleFont.getEncoding().mapChar(u);
                if (codePoint > '\u0000') continue;
                int glyphIndex = segment.getGlyphStartIndex() + u - segment.getUnicodeStart();
                String glyphName = ttf.getGlyphName(glyphIndex);
                if (glyphName.length() == 0 && ttf.getPostScriptVersion() != TTFFile.PostScriptVersion.V2) {
                    glyphName = "u" + HexEncoder.encode(u);
                }
                if (glyphName.length() <= 0) continue;
                String unicode = Character.toString(u);
                NamedCharacter nc = new NamedCharacter(glyphName, unicode);
                this.singleFont.addUnencodedCharacter(nc, wx[glyphIndex]);
            }
        }
    }

    private void copyKerning(TTFFile ttf, boolean isCid) {
        Set<Integer> kerningSet = isCid ? ttf.getKerning().keySet() : ttf.getAnsiKerning().keySet();
        for (Integer kpx1 : kerningSet) {
            Map<Integer, Integer> h2 = isCid ? ttf.getKerning().get(kpx1) : ttf.getAnsiKerning().get(kpx1);
            this.returnFont.putKerningEntry(kpx1, h2);
        }
    }

    private void copyAdvanced(TTFFile ttf) {
        if (this.returnFont instanceof MultiByteFont) {
            MultiByteFont mbf = (MultiByteFont)this.returnFont;
            mbf.setGDEF(ttf.getGDEF());
            mbf.setGSUB(ttf.getGSUB());
            mbf.setGPOS(ttf.getGPOS());
        }
    }
}

