/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.awt.image.BufferedImage;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.bitmap.BitmapRendererEventProducer;
import org.apache.fop.render.bitmap.TIFFConstants;
import org.apache.fop.render.java2d.Java2DRenderer;
import org.apache.xmlgraphics.image.GraphicsUtil;
import org.apache.xmlgraphics.image.rendered.FormatRed;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;
import org.apache.xmlgraphics.image.writer.MultiImageWriter;

public class TIFFRenderer
extends Java2DRenderer
implements TIFFConstants {
    private ImageWriterParams writerParams = new ImageWriterParams();
    private int bufferedImageType = 2;
    private OutputStream outputStream;

    public String getMimeType() {
        return "image/tiff";
    }

    public TIFFRenderer(FOUserAgent userAgent) {
        super(userAgent);
        this.writerParams.setCompressionMethod("PackBits");
        int dpi = Math.round(userAgent.getTargetResolution());
        this.writerParams.setResolution(dpi);
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        super.startRenderer(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRenderer() throws IOException {
        super.stopRenderer();
        log.debug("Starting TIFF encoding ...");
        LazyPageImagesIterator pageImagesItr = new LazyPageImagesIterator(this.getNumberOfPages(), log);
        ImageWriter writer = ImageWriterRegistry.getInstance().getWriterFor(this.getMimeType());
        if (writer == null) {
            BitmapRendererEventProducer eventProducer = BitmapRendererEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.noImageWriterFound(this, this.getMimeType());
        }
        if (writer.supportsMultiImageWriter()) {
            MultiImageWriter multiWriter = writer.createMultiImageWriter(this.outputStream);
            try {
                while (pageImagesItr.hasNext()) {
                    RenderedImage img = (RenderedImage)pageImagesItr.next();
                    multiWriter.writeImage(img, this.writerParams);
                }
            }
            finally {
                multiWriter.close();
            }
        } else {
            RenderedImage renderedImage = null;
            if (pageImagesItr.hasNext()) {
                renderedImage = (RenderedImage)pageImagesItr.next();
            }
            writer.writeImage(renderedImage, this.outputStream, this.writerParams);
            if (pageImagesItr.hasNext()) {
                BitmapRendererEventProducer eventProducer = BitmapRendererEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                eventProducer.stoppingAfterFirstPageNoFilename(this);
            }
        }
        this.outputStream.flush();
        this.clearViewportList();
        log.debug("TIFF encoding done.");
    }

    protected BufferedImage getBufferedImage(int bitmapWidth, int bitmapHeight) {
        return new BufferedImage(bitmapWidth, bitmapHeight, this.bufferedImageType);
    }

    public void setBufferedImageType(int bufferedImageType) {
        this.bufferedImageType = bufferedImageType;
    }

    public ImageWriterParams getWriterParams() {
        return this.writerParams;
    }

    private class LazyPageImagesIterator
    implements Iterator {
        private Log log;
        private int count;
        private int current = 0;

        public LazyPageImagesIterator(int c, Log log) {
            this.count = c;
            this.log = log;
        }

        public boolean hasNext() {
            return this.current < this.count;
        }

        public Object next() {
            if (this.log.isDebugEnabled()) {
                this.log.debug("[" + (this.current + 1) + "]");
            }
            BufferedImage pageImage = null;
            try {
                pageImage = TIFFRenderer.this.getPageImage(this.current++);
            }
            catch (FOPException e) {
                throw new NoSuchElementException(e.getMessage());
            }
            if ("CCITT T.4".equalsIgnoreCase(TIFFRenderer.this.writerParams.getCompressionMethod()) || "CCITT T.6".equalsIgnoreCase(TIFFRenderer.this.writerParams.getCompressionMethod())) {
                return pageImage;
            }
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)pageImage.getSampleModel();
            int bands = sppsm.getNumBands();
            int[] off = new int[bands];
            int w = pageImage.getWidth();
            int h = pageImage.getHeight();
            for (int i = 0; i < bands; ++i) {
                off[i] = i;
            }
            PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, w, h, bands, w * bands, off);
            FormatRed rimg = new FormatRed(GraphicsUtil.wrap(pageImage), sm);
            return rimg;
        }

        public void remove() {
            throw new UnsupportedOperationException("Method 'remove' is not supported.");
        }
    }
}

