/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx;

import java.util.regex.Pattern;
import org.camunda.bpm.dmn.xlsx.CellContentHandler;
import org.camunda.bpm.dmn.xlsx.XlsxWorksheetContext;
import org.xlsx4j.sml.Cell;
import org.xlsx4j.sml.STCellType;

public class DmnValueRangeConverter
implements CellContentHandler {
    public static final Pattern RANGE_REGEX = Pattern.compile("[\\[\\]][0-9\\.]+\\.\\.[0-9\\.]+[\\[\\]]");

    @Override
    public boolean canConvert(Cell cell, XlsxWorksheetContext context) {
        if (STCellType.S.equals((Object)cell.getT())) {
            String content = context.resolveCellValue(cell);
            return RANGE_REGEX.matcher(content).matches();
        }
        return false;
    }

    @Override
    public String convert(Cell cell, XlsxWorksheetContext context) {
        return context.resolveCellValue(cell);
    }
}

