/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx;

import java.util.List;
import org.camunda.bpm.dmn.xlsx.DmnConversionContext;
import org.camunda.bpm.dmn.xlsx.DmnValueNumberConverter;
import org.camunda.bpm.dmn.xlsx.DmnValueRangeConverter;
import org.camunda.bpm.dmn.xlsx.DmnValueStringConverter;
import org.camunda.bpm.dmn.xlsx.FeelSimpleUnaryTestConverter;
import org.camunda.bpm.dmn.xlsx.InputOutputColumns;
import org.camunda.bpm.dmn.xlsx.InputOutputDetectionStrategy;
import org.camunda.bpm.dmn.xlsx.XlsxWorksheetContext;
import org.camunda.bpm.dmn.xlsx.elements.IndexedCell;
import org.camunda.bpm.dmn.xlsx.elements.IndexedDmnColumns;
import org.camunda.bpm.dmn.xlsx.elements.IndexedRow;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.Definitions;
import org.camunda.bpm.model.dmn.instance.DmnElement;
import org.camunda.bpm.model.dmn.instance.Input;
import org.camunda.bpm.model.dmn.instance.InputEntry;
import org.camunda.bpm.model.dmn.instance.InputExpression;
import org.camunda.bpm.model.dmn.instance.NamedElement;
import org.camunda.bpm.model.dmn.instance.Output;
import org.camunda.bpm.model.dmn.instance.OutputEntry;
import org.camunda.bpm.model.dmn.instance.Rule;
import org.camunda.bpm.model.dmn.instance.Text;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class XlsxWorksheetConverter {
    protected XlsxWorksheetContext worksheetContext;
    protected DmnConversionContext dmnConversionContext;
    protected InputOutputDetectionStrategy ioDetectionStrategy;

    public XlsxWorksheetConverter(XlsxWorksheetContext worksheetContext, InputOutputDetectionStrategy ioDetectionStrategy) {
        this.worksheetContext = worksheetContext;
        this.dmnConversionContext = new DmnConversionContext(worksheetContext);
        this.ioDetectionStrategy = ioDetectionStrategy;
        this.dmnConversionContext.addCellContentHandler(new DmnValueRangeConverter());
        this.dmnConversionContext.addCellContentHandler(new FeelSimpleUnaryTestConverter());
        this.dmnConversionContext.addCellContentHandler(new DmnValueStringConverter());
        this.dmnConversionContext.addCellContentHandler(new DmnValueNumberConverter());
    }

    public DmnModelInstance convert() {
        DmnModelInstance dmnModel = this.initializeEmptyDmnModel();
        Decision decision = this.generateNamedElement(dmnModel, Decision.class, this.worksheetContext.getWorksheetName());
        dmnModel.getDefinitions().addChildElement((ModelElementInstance)decision);
        DecisionTable decisionTable = this.generateElement(dmnModel, DecisionTable.class, "decisionTable");
        decision.addChildElement((ModelElementInstance)decisionTable);
        List<IndexedRow> rows = this.worksheetContext.getRows();
        this.convertInputsOutputs(dmnModel, decisionTable, rows.get(0));
        this.convertRules(dmnModel, decisionTable, rows.subList(1, rows.size()));
        return dmnModel;
    }

    protected void convertInputsOutputs(DmnModelInstance dmnModel, DecisionTable decisionTable, IndexedRow header) {
        InputOutputColumns inputOutputColumns = this.ioDetectionStrategy.determineHeaderCells(header, this.worksheetContext);
        for (IndexedCell inputCell : inputOutputColumns.getInputHeaderCells()) {
            Input input = this.generateElement(dmnModel, Input.class, this.worksheetContext.resolveCellValue(inputCell.getCell()));
            decisionTable.addChildElement((ModelElementInstance)input);
            InputExpression inputExpression = this.generateElement(dmnModel, InputExpression.class);
            Text text = this.generateText(dmnModel, this.worksheetContext.resolveCellValue(inputCell.getCell()));
            inputExpression.setText(text);
            input.setInputExpression(inputExpression);
            this.dmnConversionContext.getIndexedDmnColumns().addInput(inputCell, input);
        }
        for (IndexedCell outputCell : inputOutputColumns.getOutputHeaderCells()) {
            Output output = this.generateElement(dmnModel, Output.class, this.worksheetContext.resolveCellValue(outputCell.getCell()));
            output.setName(this.worksheetContext.resolveCellValue(outputCell.getCell()));
            decisionTable.addChildElement((ModelElementInstance)output);
            this.dmnConversionContext.getIndexedDmnColumns().addOutput(outputCell, output);
        }
    }

    protected void convertRules(DmnModelInstance dmnModel, DecisionTable decisionTable, List<IndexedRow> rulesRows) {
        for (IndexedRow rule : rulesRows) {
            this.convertRule(dmnModel, decisionTable, rule);
        }
    }

    protected void convertRule(DmnModelInstance dmnModel, DecisionTable decisionTable, IndexedRow ruleRow) {
        Text text;
        String textValue;
        String coordinate;
        IndexedCell cell;
        String xlsxColumn;
        Rule rule = this.generateElement(dmnModel, Rule.class, "excelRow" + ruleRow.getRow().getR());
        decisionTable.addChildElement((ModelElementInstance)rule);
        IndexedDmnColumns dmnColumns = this.dmnConversionContext.getIndexedDmnColumns();
        for (Input input : dmnColumns.getOrderedInputs()) {
            xlsxColumn = dmnColumns.getXlsxColumn(input);
            cell = ruleRow.getCell(xlsxColumn);
            coordinate = xlsxColumn + ruleRow.getRow().getR();
            InputEntry inputEntry = this.generateElement(dmnModel, InputEntry.class, coordinate);
            textValue = cell != null ? this.dmnConversionContext.resolveCellValue(cell.getCell()) : this.getDefaultCellContent();
            text = this.generateText(dmnModel, textValue);
            inputEntry.setText(text);
            rule.addChildElement((ModelElementInstance)inputEntry);
        }
        for (Output output : dmnColumns.getOrderedOutputs()) {
            xlsxColumn = dmnColumns.getXlsxColumn(output);
            cell = ruleRow.getCell(xlsxColumn);
            coordinate = xlsxColumn + ruleRow.getRow().getR();
            OutputEntry outputEntry = this.generateElement(dmnModel, OutputEntry.class, coordinate);
            textValue = cell != null ? this.dmnConversionContext.resolveCellValue(cell.getCell()) : this.getDefaultCellContent();
            text = this.generateText(dmnModel, textValue);
            outputEntry.setText(text);
            rule.addChildElement((ModelElementInstance)outputEntry);
        }
    }

    protected String getDefaultCellContent() {
        return "-";
    }

    protected DmnModelInstance initializeEmptyDmnModel() {
        DmnModelInstance dmnModel = Dmn.createEmptyModel();
        Definitions definitions = this.generateNamedElement(dmnModel, Definitions.class, "definitions");
        definitions.setNamespace("http://camunda.org/schema/1.0/dmn");
        dmnModel.setDefinitions(definitions);
        return dmnModel;
    }

    public <E extends NamedElement> E generateNamedElement(DmnModelInstance modelInstance, Class<E> elementClass, String name) {
        NamedElement element = (NamedElement)this.generateElement(modelInstance, elementClass, name);
        element.setName(name);
        return (E)element;
    }

    public <E extends DmnElement> E generateElement(DmnModelInstance modelInstance, Class<E> elementClass, String id) {
        DmnElement element = (DmnElement)modelInstance.newInstance(elementClass);
        element.setId(id);
        return (E)element;
    }

    public <E extends DmnElement> E generateElement(DmnModelInstance modelInstance, Class<E> elementClass) {
        String generatedId = elementClass.getSimpleName() + Integer.toString((int)(2.147483647E9 * Math.random()));
        return this.generateElement(modelInstance, elementClass, generatedId);
    }

    protected Text generateText(DmnModelInstance dmnModel, String content) {
        Text text = (Text)dmnModel.newInstance(Text.class);
        text.setTextContent(content);
        return text;
    }
}

