/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.docx4j.convert.out.ConversionHyperlinkHandler;
import org.docx4j.model.images.ConversionImageHandler;
import org.docx4j.openpackaging.packages.OpcPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConversionSettings {
    public static final String IMAGE_INCLUDE_UUID = "imageIncludeUUID";
    public static final String IMAGE_DIR_PATH = "imageDirPath";
    public static final String IMAGE_HANDLER = "imageHandler";
    public static final String HYPERLINK_HANDLER = "hyperlinkHandler";
    public static final String WML_PACKAGE = "wmlPackage";
    public static final String CUSTOM_XSLT_TEMPLATES = "customXsltTemplates";
    protected Map<String, Object> settings = new TreeMap<String, Object>();
    protected Set<String> features = new TreeSet<String>();

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public Set<String> getFeatures() {
        return this.features;
    }

    public void addFeatures(String[] featuresArray) {
        if (featuresArray != null && featuresArray.length > 0) {
            for (int i = 0; i < featuresArray.length; ++i) {
                this.getFeatures().add(featuresArray[i]);
            }
        }
    }

    public void setImageDirPath(String imageDirPath) {
        this.settings.put(IMAGE_DIR_PATH, imageDirPath);
    }

    public String getImageDirPath() {
        return (String)this.settings.get(IMAGE_DIR_PATH);
    }

    public void setImageIncludeUUID(boolean imageIncludeUUID) {
        this.settings.put(IMAGE_INCLUDE_UUID, imageIncludeUUID);
    }

    public boolean isImageIncludeUUID() {
        return this.settings.containsKey(IMAGE_INCLUDE_UUID) ? (Boolean)this.settings.get(IMAGE_INCLUDE_UUID) : true;
    }

    public void setImageHandler(ConversionImageHandler imageHandler) {
        this.settings.put(IMAGE_HANDLER, imageHandler);
    }

    public ConversionImageHandler getImageHandler() {
        return (ConversionImageHandler)this.settings.get(IMAGE_HANDLER);
    }

    public void setHyperlinkHandler(ConversionHyperlinkHandler hyperlinkHandler) {
        this.settings.put(HYPERLINK_HANDLER, hyperlinkHandler);
    }

    public ConversionHyperlinkHandler getHyperlinkHandler() {
        return (ConversionHyperlinkHandler)this.settings.get(HYPERLINK_HANDLER);
    }

    public void setWmlPackage(OpcPackage wmlPackage) {
        this.settings.put(WML_PACKAGE, wmlPackage);
    }

    public OpcPackage getWmlPackage() {
        return (OpcPackage)this.settings.get(WML_PACKAGE);
    }

    public void setCustomXsltTemplates(Object templates) {
        this.settings.put(CUSTOM_XSLT_TEMPLATES, templates);
    }

    public Object getCustomXsltTemplates() {
        return this.settings.get(CUSTOM_XSLT_TEMPLATES);
    }
}

