/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import java.awt.font.NumericShaper;
import java.util.concurrent.ExecutionException;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.fonts.CJKToEnglish;
import org.docx4j.fonts.GlyphCheck;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.properties.Property;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTLanguage;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.PPr;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STHint;
import org.docx4j.wml.Style;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class RunFontSelector {
    protected static Logger log = LoggerFactory.getLogger(RunFontSelector.class);
    private WordprocessingMLPackage wordMLPackage;
    private RunFontCharacterVisitor vis;
    private RunFontActionType outputType;
    String fallbackFont = null;
    CTLanguage themeFontLang = null;
    public static final String CSS_NAME = "font-family";
    public static final String FO_NAME = "font-family";
    private Style defaultParagraphStyle;
    private String defaultFont = null;
    private boolean spacePreserve;
    private static NumericShaper numericShaperArabicIndic = null;
    private static NativeDigitsSetting nativeDigitsSetting = null;
    private static MicrosoftWordNumeralOption microsoftWordNumeralOption = null;

    public RunFontSelector(WordprocessingMLPackage wordMLPackage, RunFontCharacterVisitor visitor, RunFontActionType outputType) {
        this.wordMLPackage = wordMLPackage;
        this.vis = visitor;
        this.outputType = outputType;
        this.vis.setRunFontSelector(this);
        this.fallbackFont = this.getPhysicalFont(this.getDefaultFont());
        if (this.fallbackFont == null) {
            this.fallbackFont = this.getDefaultFont();
            if (outputType != RunFontActionType.DISCOVERY) {
                log.warn(this.getDefaultFont() + " is not mapped!");
            }
        }
        this.vis.setFallbackFont(this.fallbackFont);
        if (wordMLPackage.getMainDocumentPart().getDocumentSettingsPart() != null) {
            try {
                this.themeFontLang = ((CTSettings)wordMLPackage.getMainDocumentPart().getDocumentSettingsPart().getContents()).getThemeFontLang();
            }
            catch (Docx4JException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public String getCssName() {
        return "font-family";
    }

    private ThemePart getThemePart() {
        return this.wordMLPackage.getMainDocumentPart().getThemePart();
    }

    private Style getDefaultPStyle() {
        if (this.defaultParagraphStyle == null) {
            this.defaultParagraphStyle = this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart(false) != null ? this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart(false).getDefaultParagraphStyle() : null;
        }
        return this.defaultParagraphStyle;
    }

    public String getDefaultFont() {
        if (this.defaultFont == null) {
            PropertyResolver propertyResolver = this.wordMLPackage.getMainDocumentPart().getPropertyResolver();
            RFonts rFonts = propertyResolver.getDocumentDefaultRPr().getRFonts();
            if (rFonts == null) {
                log.info("No styles/docDefaults/rPrDefault/rPr/rFonts - default to Times New Roman");
                this.defaultFont = "Times New Roman";
            } else if (rFonts.getAsciiTheme() == null) {
                if (rFonts.getAscii() == null) {
                    log.error("Neither ascii or asciTheme.  What to do? ");
                    this.defaultFont = "Times New Roman";
                } else {
                    log.info("rPrDefault/rFonts referenced " + rFonts.getAscii());
                    this.defaultFont = rFonts.getAscii();
                }
            } else if (this.getThemePart() == null) {
                log.info("No theme part - default to Calibri");
                this.defaultFont = "Calibri";
            } else {
                String font = null;
                try {
                    font = this.getThemePart().getFont(rFonts.getAsciiTheme(), this.themeFontLang);
                }
                catch (Docx4JException e) {
                    log.error(e.getMessage(), e);
                }
                if (font != null) {
                    this.defaultFont = font;
                } else {
                    log.info("No minorFont/latin in theme part - default to Calibri");
                    this.defaultFont = "Calibri";
                }
            }
        }
        return this.defaultFont;
    }

    private DocumentFragment nullRPr(Document document, String text) {
        if (this.outputType == RunFontActionType.DISCOVERY) {
            this.vis.fontAction(this.getDefaultFont());
            return null;
        }
        Element span = this.createElement(document);
        if (span != null) {
            document.appendChild(span);
            this.setAttribute(span, this.getDefaultFont());
            span.setTextContent(text);
        }
        return this.result(document);
    }

    private DocumentFragment result(Document document) {
        if (this.outputType == RunFontActionType.DISCOVERY) {
            return null;
        }
        DocumentFragment docfrag = document.createDocumentFragment();
        docfrag.appendChild(document.getDocumentElement());
        return docfrag;
    }

    public Element createElement(Document document) {
        Element el = null;
        if (this.outputType == RunFontActionType.DISCOVERY) {
            return null;
        }
        if (this.outputType == RunFontActionType.XHTML) {
            el = document.createElement("span");
        } else if (this.outputType == RunFontActionType.XSL_FO) {
            el = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:inline");
        }
        return el;
    }

    public void setAttribute(Element el, String fontName) {
        if (this.outputType == RunFontActionType.DISCOVERY) {
            return;
        }
        if (this.outputType == RunFontActionType.XHTML) {
            if (this.spacePreserve) {
                el.setAttribute("style", this.getCssProperty(fontName) + "white-space:pre-wrap;");
            } else {
                el.setAttribute("style", this.getCssProperty(fontName));
            }
        } else if (this.outputType == RunFontActionType.XSL_FO) {
            String val = this.getPhysicalFont(fontName);
            if (val == null) {
                el.setAttribute("font-family", this.fallbackFont);
            } else {
                el.setAttribute("font-family", val);
            }
        }
    }

    public Object fontSelector(PPr pPr, RPr rPr, Text wmlText) {
        String text = null;
        if (wmlText == null) {
            log.debug("Null Text object");
        } else {
            text = wmlText.getValue();
            this.spacePreserve = wmlText.getSpace() != null && wmlText.getSpace().equals("preserve");
        }
        return this.fontSelector(pPr, rPr, text);
    }

    public Object fontSelector(PPr pPr, RPr rPr, String text) {
        if (text == null) {
            log.debug("w:t with null value");
            if (this.outputType != RunFontActionType.DISCOVERY) {
                return null;
            }
        } else {
            log.debug(text);
        }
        PropertyResolver propertyResolver = this.wordMLPackage.getMainDocumentPart().getPropertyResolver();
        String pStyleId = null;
        RPr pRPr = null;
        if (pPr == null || pPr.getPStyle() == null) {
            if (this.getDefaultPStyle() == null) {
                log.warn("getDefaultPStyle() returned null");
            } else {
                pStyleId = this.getDefaultPStyle().getStyleId();
            }
        } else {
            pStyleId = pPr.getPStyle().getVal();
        }
        if (pStyleId != null && this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart(false) != null) {
            pRPr = propertyResolver.getEffectiveRPr(pStyleId);
        }
        rPr = propertyResolver.getEffectiveRPrUsingPStyleRPr(rPr, pRPr);
        log.debug("effective\n" + XmlUtils.marshaltoString(rPr));
        Document document = XmlUtils.getNewDocumentBuilder().newDocument();
        if (rPr == null) {
            log.warn("effective rPr is null");
            return this.nullRPr(document, text);
        }
        RFonts rFonts = rPr.getRFonts();
        if (rFonts == null) {
            return this.nullRPr(document, text);
        }
        if (pPr != null && pPr.getBidi() != null && pPr.getBidi().isVal()) {
            text = this.arabicNumbering(text, rPr.getRtl(), rPr.getCs(), this.themeFontLang);
        }
        if (rPr.getCs() != null || rPr.getRtl() != null) {
            if (rFonts.getCstheme() != null) {
                Element span;
                String fontName = null;
                if (this.getThemePart() != null) {
                    try {
                        fontName = this.getThemePart().getFont(rFonts.getCstheme(), this.themeFontLang);
                    }
                    catch (Docx4JException e) {
                        log.error(e.getMessage(), e);
                    }
                }
                if (fontName == null) {
                    fontName = rFonts.getCs();
                }
                if (fontName == null) {
                    log.warn("font name is null, for " + text);
                    log.warn(XmlUtils.marshaltoString((Object)rPr, true, true));
                    new Throwable().printStackTrace();
                }
                if ((span = this.createElement(document)) != null) {
                    document.appendChild(span);
                    this.setAttribute(span, fontName);
                    span.setTextContent(text);
                }
                if (this.outputType == RunFontActionType.DISCOVERY) {
                    this.vis.fontAction(fontName);
                }
                return this.result(document);
            }
            if (rFonts.getCs() != null) {
                String fontName = rFonts.getCs();
                Element span = this.createElement(document);
                if (span != null) {
                    document.appendChild(span);
                    this.setAttribute(span, fontName);
                    span.setTextContent(text);
                }
                if (this.outputType == RunFontActionType.DISCOVERY) {
                    this.vis.fontAction(fontName);
                }
                return this.result(document);
            }
        }
        String eastAsia = null;
        String ascii = null;
        String hAnsi = null;
        STHint hint = rFonts.getHint();
        if (rFonts.getEastAsiaTheme() != null && this.getThemePart() != null) {
            try {
                eastAsia = this.getThemePart().getFont(rFonts.getEastAsiaTheme(), this.themeFontLang);
            }
            catch (Docx4JException e) {
                log.error(e.getMessage(), e);
            }
            if (eastAsia == null) {
                log.info("theme font for lang " + this.themeFontLang + " is " + eastAsia + ", but we don't have that");
                eastAsia = rFonts.getEastAsia();
            }
        } else {
            eastAsia = rFonts.getEastAsia();
        }
        if (rFonts.getAsciiTheme() != null && this.getThemePart() != null) {
            try {
                ascii = this.getThemePart().getFont(rFonts.getAsciiTheme(), this.themeFontLang);
            }
            catch (Docx4JException e) {
                log.error(e.getMessage(), e);
            }
        } else {
            ascii = rFonts.getAscii();
        }
        if (rFonts.getHAnsiTheme() != null && this.getThemePart() != null) {
            try {
                hAnsi = this.getThemePart().getFont(rFonts.getHAnsiTheme(), this.themeFontLang);
            }
            catch (Docx4JException e) {
                log.error(e.getMessage(), e);
            }
        } else {
            hAnsi = rFonts.getHAnsi();
        }
        if ("Times New Roman".equals(eastAsia) && ascii != null && ascii.equals(hAnsi)) {
            Element span = this.createElement(document);
            if (span != null) {
                document.appendChild(span);
            }
            if (this.outputType == RunFontActionType.DISCOVERY) {
                this.vis.fontAction(ascii);
                return null;
            }
            this.setAttribute(span, ascii);
            span.setTextContent(text);
            return this.result(document);
        }
        if (ascii == null) {
            log.debug("No value for ascii, using default font");
            ascii = this.getDefaultFont();
        }
        if (hAnsi == null) {
            log.debug("No value for hAnsi, using default font");
            hAnsi = this.getDefaultFont();
        }
        String langEastAsia = null;
        if (rPr.getLang() != null) {
            langEastAsia = rPr.getLang().getEastAsia();
        }
        this.vis.setDocument(document);
        return this.unicodeRangeToFont(text, hint, langEastAsia, eastAsia, ascii, hAnsi);
    }

    private boolean contains(String langEastAsia, String lang) {
        if (langEastAsia == null) {
            return false;
        }
        return langEastAsia.contains(lang);
    }

    private Object unicodeRangeToFont(String text, STHint hint, String langEastAsia, String eastAsia, String ascii, String hAnsi) {
        char currentRangeLower = '\u0000';
        int currentRangeUpper = '\u0000';
        if (text == null) {
            return null;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (this.vis.isReusable() && (c == ' ' || c >= currentRangeLower && c <= currentRangeUpper)) {
                this.vis.addCharacterToCurrent(c);
                continue;
            }
            this.vis.finishPrevious();
            this.vis.createNew();
            this.vis.setMustCreateNewFlag(false);
            if (c >= '\u0000' && c <= '\u007f') {
                this.vis.fontAction(ascii);
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\u0000';
                currentRangeUpper = 127;
                continue;
            }
            if (c >= '\u00a0' && c <= '\u00ff') {
                if (hint == STHint.EAST_ASIA && eastAsia != null) {
                    if (c == '\u00a1' || c == '\u00a4' || c >= '\u00a7' && c <= '\u00a8' || c == '\u00aa' || c == '\u00ad' || c == '\u00af' || c >= '\u00b0' && c <= '\u00b4' || c >= '\u00b6' && c <= '\u00ba' || c >= '\u00bc' && c <= '\u00bf' || c == '\u00d7' || c == '\u00f7') {
                        this.vis.fontAction(eastAsia);
                    } else if (this.contains(langEastAsia, "zh") && (c >= '\u00e0' && c <= '\u00e1' || c >= '\u00e8' && c <= '\u00ea' || c >= '\u00ec' && c <= '\u00ed' || c >= '\u00f2' && c <= '\u00f3' || c >= '\u00f9' && c <= '\u00fa' || c == '\u00fc')) {
                        this.vis.fontAction(eastAsia);
                    } else if (hAnsi != null) {
                        this.vis.fontAction(hAnsi);
                    } else {
                        this.vis.fontAction(this.getDefaultFont());
                    }
                } else if (hAnsi != null) {
                    this.vis.fontAction(hAnsi);
                } else {
                    this.vis.fontAction(this.getDefaultFont());
                }
                this.vis.addCharacterToCurrent(c);
                this.vis.setMustCreateNewFlag(false);
                currentRangeLower = '\u0000';
                currentRangeUpper = 127;
                continue;
            }
            if (c >= '\u0100' && c <= '\u02af') {
                if (hint == STHint.EAST_ASIA) {
                    if (this.contains(langEastAsia, "zh")) {
                        this.vis.fontAction(eastAsia);
                        this.vis.setMustCreateNewFlag(true);
                    } else {
                        this.vis.fontAction(hAnsi);
                        this.vis.setMustCreateNewFlag(true);
                    }
                } else {
                    this.vis.fontAction(hAnsi);
                }
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\u0100';
                currentRangeUpper = 687;
                continue;
            }
            if (c >= '\u02b0' && c <= '\u04ff') {
                if (hint == STHint.EAST_ASIA) {
                    this.vis.fontAction(eastAsia);
                } else {
                    this.vis.fontAction(hAnsi);
                }
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\u02b0';
                currentRangeUpper = 1279;
                continue;
            }
            if (c >= '\u0590' && c <= '\u07bf') {
                try {
                    if (GlyphCheck.hasChar("Times New Roman", c)) {
                        this.vis.fontAction("Times New Roman");
                    }
                }
                catch (ExecutionException e) {
                    log.error(e.getMessage(), e);
                }
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\u0590';
                currentRangeUpper = 1983;
                continue;
            }
            if (c >= '\u1100' && c <= '\u11ff') {
                if (eastAsia == null) {
                    this.vis.fontAction("Gungsuh");
                } else {
                    this.vis.fontAction(eastAsia);
                }
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\u1100';
                currentRangeUpper = 4607;
                continue;
            }
            if (c >= '\u1e00' && c <= '\u1eff') {
                if (hint == STHint.EAST_ASIA) {
                    if (this.contains(langEastAsia, "zh")) {
                        this.vis.fontAction(eastAsia);
                    } else {
                        this.vis.fontAction(hAnsi);
                    }
                } else {
                    this.vis.fontAction(hAnsi);
                }
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\u1e00';
                currentRangeUpper = 7935;
                continue;
            }
            if (c >= '\u2000' && c <= '\u2eff') {
                if (hint == STHint.EAST_ASIA) {
                    this.vis.fontAction(eastAsia);
                } else if (hAnsi == null) {
                    log.warn("TODO: how to handle char '" + c + "' lacking hAnsi?");
                } else {
                    try {
                        if (GlyphCheck.hasChar(hAnsi, c)) {
                            this.vis.fontAction(hAnsi);
                        } else if (GlyphCheck.hasChar("MS Gothic", c)) {
                            this.vis.fontAction("MS Gothic");
                        } else {
                            log.warn("TODO: how to handle char '" + c + "' in range c>='\u2000' && c<='\u2eff'?");
                        }
                    }
                    catch (ExecutionException e) {
                        log.error(e.getMessage(), e);
                    }
                }
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\u2000';
                currentRangeUpper = 12031;
                continue;
            }
            if (c >= '\u2f00' && c <= '\udfff') {
                if (eastAsia == null) {
                    this.vis.fontAction(hAnsi);
                    this.debugCheckGlyph(hAnsi, c);
                } else {
                    this.vis.fontAction(eastAsia);
                    this.debugCheckGlyph(eastAsia, c);
                }
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\u2f00';
                currentRangeUpper = 57343;
                continue;
            }
            if (c >= '\ue000' && c <= '\uf8ff') {
                if (hint == STHint.EAST_ASIA) {
                    this.vis.fontAction(eastAsia);
                } else if (hAnsi == null) {
                    log.warn("TODO: how to handle char '" + c + "' (0x" + Integer.toHexString(c) + ") lacking hAnsi?");
                } else {
                    this.vis.fontAction(hAnsi);
                    this.debugCheckGlyph(hAnsi, c);
                }
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\ue000';
                currentRangeUpper = 63743;
                continue;
            }
            if (c >= '\uf900' && c <= '\ufaff') {
                this.vis.fontAction(eastAsia);
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\uf900';
                currentRangeUpper = 64255;
                continue;
            }
            if (c >= '\ufb00' && c <= '\ufb4f') {
                if (hint == STHint.EAST_ASIA) {
                    if (c >= '\ufb00' && c <= '\ufb1c') {
                        this.vis.fontAction(eastAsia);
                        this.vis.setMustCreateNewFlag(true);
                    } else {
                        this.vis.fontAction(hAnsi);
                    }
                } else if (c >= '\ufb1d' && c <= '\ufb4f') {
                    this.vis.fontAction(ascii);
                    this.vis.setMustCreateNewFlag(true);
                } else {
                    this.vis.fontAction(hAnsi);
                }
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\ufb00';
                currentRangeUpper = 64335;
                continue;
            }
            if (c >= '\ufb50' && c <= '\ufdff') {
                this.vis.fontAction(eastAsia);
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\ufb50';
                currentRangeUpper = 65023;
                continue;
            }
            if (c >= '\ufe30' && c <= '\ufe6f') {
                this.vis.fontAction(eastAsia);
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\ufe30';
                currentRangeUpper = 65135;
                continue;
            }
            if (c >= '\ufe70' && c <= '\ufefe') {
                this.vis.fontAction(ascii);
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\ufe70';
                currentRangeUpper = 65278;
                continue;
            }
            if (c >= '\uff00' && c <= '\uffef') {
                if (eastAsia == null) {
                    this.vis.fontAction(hAnsi);
                } else {
                    this.vis.fontAction(eastAsia);
                }
                this.vis.addCharacterToCurrent(c);
                currentRangeLower = '\uff00';
                currentRangeUpper = 65519;
                continue;
            }
            String hex = String.format("%04x", c);
            log.debug("Defaulting to hAnsi for char " + hex);
            this.vis.fontAction(hAnsi);
            this.debugCheckGlyph(hAnsi, c);
            this.vis.addCharacterToCurrent(c);
            currentRangeLower = '\u0000';
            currentRangeUpper = 0;
        }
        this.vis.finishPrevious();
        return this.vis.getResult();
    }

    private void debugCheckGlyph(String fontName, char c) {
        if (log.isDebugEnabled()) {
            try {
                if (!GlyphCheck.hasChar(fontName, c)) {
                    Throwable t = new Throwable();
                    log.debug("FIXME", t);
                }
            }
            catch (ExecutionException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    private String getCssProperty(String fontName) {
        String font;
        if (log.isDebugEnabled() && fontName == null) {
            Throwable t = new Throwable();
            t.printStackTrace();
        }
        if ((font = this.getPhysicalFont(fontName)) != null) {
            return Property.composeCss("font-family", "'" + font + "'");
        }
        log.warn("No mapping from " + font);
        return "";
    }

    private String getPhysicalFont(String fontName) {
        log.debug("looking for: " + fontName);
        PhysicalFont pf = this.wordMLPackage.getFontMapper().get(fontName);
        if (pf != null) {
            log.debug("Font '" + fontName + "' maps to " + pf.getName());
            return pf.getName();
        }
        String englishFromCJK = CJKToEnglish.toEnglish(fontName);
        if (englishFromCJK == null) {
            if (this.wordMLPackage.getFontMapper().size() > 0) {
                log.warn("Font '" + fontName + "' is not mapped to a physical font. ");
            }
            return null;
        }
        pf = this.wordMLPackage.getFontMapper().get(englishFromCJK);
        if (pf == null) {
            if (this.wordMLPackage.getFontMapper().size() > 0) {
                log.warn("Font '" + englishFromCJK + "' is not mapped to a physical font. ");
            }
            return null;
        }
        return pf.getName();
    }

    private static NumericShaper getNumericShaperArabicIndic() {
        if (numericShaperArabicIndic == null) {
            numericShaperArabicIndic = NumericShaper.getShaper(2);
        }
        return numericShaperArabicIndic;
    }

    private static NativeDigitsSetting getNativeDigitsSetting() {
        if (nativeDigitsSetting == null) {
            nativeDigitsSetting = NativeDigitsSetting.valueOf(Docx4jProperties.getProperty("docx4j.MicrosoftWindows.Region.Format.Numbers.NativeDigits", "National"));
        }
        return nativeDigitsSetting;
    }

    private static MicrosoftWordNumeralOption getMicrosoftWordNumeralOption() {
        if (microsoftWordNumeralOption == null) {
            microsoftWordNumeralOption = MicrosoftWordNumeralOption.valueOf(Docx4jProperties.getProperty("docx4j.MicrosoftWord.Numeral", "Arabic"));
        }
        return microsoftWordNumeralOption;
    }

    private String shapeAsArabicIndic(String text) {
        char[] chars = text.toCharArray();
        RunFontSelector.getNumericShaperArabicIndic().shape(chars, 0, chars.length);
        return new String(chars);
    }

    private String arabicNumbering(String text, BooleanDefaultTrue rtl, BooleanDefaultTrue cs, CTLanguage themeFontLang) {
        if (themeFontLang == null || themeFontLang.getBidi() == null || !themeFontLang.getBidi().equals("ar-SA")) {
            return text;
        }
        if (rtl != null && rtl.isVal() || cs != null && cs.isVal()) {
            if (RunFontSelector.getMicrosoftWordNumeralOption().equals((Object)MicrosoftWordNumeralOption.Arabic)) {
                return text;
            }
            return this.shapeAsArabicIndic(text);
        }
        if (RunFontSelector.getNativeDigitsSetting().equals((Object)NativeDigitsSetting.National)) {
            return this.shapeAsArabicIndic(text);
        }
        if (RunFontSelector.getMicrosoftWordNumeralOption().equals((Object)MicrosoftWordNumeralOption.Hindi)) {
            return this.shapeAsArabicIndic(text);
        }
        return text;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NativeDigitsSetting {
        National,
        Context;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MicrosoftWordNumeralOption {
        Hindi,
        Context,
        Arabic,
        System;

    }

    public static interface RunFontCharacterVisitor {
        public void setRunFontSelector(RunFontSelector var1);

        public void setDocument(Document var1);

        public void addCharacterToCurrent(char var1);

        public void finishPrevious();

        public void createNew();

        public void setMustCreateNewFlag(boolean var1);

        public boolean isReusable();

        public void fontAction(String var1);

        public void setFallbackFont(String var1);

        public Object getResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RunFontActionType {
        XSL_FO,
        XHTML,
        DISCOVERY;

    }
}

