/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.autodetect;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.docx4j.fonts.fop.fonts.CustomFont;
import org.docx4j.fonts.fop.fonts.EmbedFontInfo;
import org.docx4j.fonts.fop.fonts.EncodingMode;
import org.docx4j.fonts.fop.fonts.FontCache;
import org.docx4j.fonts.fop.fonts.FontEventListener;
import org.docx4j.fonts.fop.fonts.FontLoader;
import org.docx4j.fonts.fop.fonts.FontResolver;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.fonts.fop.fonts.FontUtil;
import org.docx4j.fonts.fop.fonts.MultiByteFont;
import org.docx4j.fonts.fop.fonts.truetype.FontFileReader;
import org.docx4j.fonts.fop.fonts.truetype.TTFFile;
import org.docx4j.fonts.fop.fonts.truetype.TTFFontLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontInfoFinder {
    private Logger log = LoggerFactory.getLogger(FontInfoFinder.class);
    private FontEventListener eventListener;
    private final Pattern quotePattern = Pattern.compile("'");

    public void setEventListener(FontEventListener listener) {
        this.eventListener = listener;
    }

    private void generateTripletsFromFont(CustomFont customFont, Collection triplets) {
        int guessedWeight;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Font: " + customFont.getFullName() + ", family: " + customFont.getFamilyNames() + ", PS: " + customFont.getFontName() + ", EmbedName: " + customFont.getEmbedFontName());
        }
        String strippedName = this.stripQuotes(customFont.getStrippedFontName());
        String fullName = this.stripQuotes(customFont.getFullName());
        String searchName = fullName.toLowerCase();
        String style = this.guessStyle(customFont, searchName);
        int weight = guessedWeight = FontUtil.guessWeight(searchName);
        triplets.add(new FontTriplet(fullName, "normal", 400));
        if (!fullName.equals(strippedName)) {
            triplets.add(new FontTriplet(strippedName, "normal", 400));
        }
        Set familyNames = customFont.getFamilyNames();
        Iterator iter = familyNames.iterator();
        while (iter.hasNext()) {
            String familyName = this.stripQuotes((String)iter.next());
            if (fullName.equals(familyName)) continue;
            int priority = fullName.startsWith(familyName) ? fullName.length() - familyName.length() : fullName.length();
            triplets.add(new FontTriplet(familyName, style, weight, priority));
        }
    }

    private String stripQuotes(String name) {
        return this.quotePattern.matcher(name).replaceAll("");
    }

    private String guessStyle(CustomFont customFont, String fontName) {
        String style = "normal";
        style = customFont.getItalicAngle() > 0 ? "italic" : FontUtil.guessStyle(fontName);
        return style;
    }

    private EmbedFontInfo getFontInfoFromCustomFont(URL fontUrl, CustomFont customFont, FontCache fontCache) {
        ArrayList fontTripletList = new ArrayList();
        this.generateTripletsFromFont(customFont, fontTripletList);
        String embedUrl = fontUrl.toExternalForm();
        String subFontName = null;
        if (customFont instanceof MultiByteFont) {
            subFontName = ((MultiByteFont)customFont).getTTCName();
        }
        EmbedFontInfo fontInfo = new EmbedFontInfo(null, customFont.isKerningEnabled(), fontTripletList, embedUrl, subFontName);
        fontInfo.setFamilyNames(customFont.getFamilyNames());
        fontInfo.setPanose(customFont.getPanose());
        fontInfo.setPostScriptName(customFont.getFontName());
        fontInfo.setEmbeddable(customFont.isEmbeddable());
        if (fontCache != null) {
            fontCache.addFont(fontInfo);
        }
        return fontInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbedFontInfo[] find(URL fontUrl, FontResolver resolver, FontCache fontCache) {
        String embedUrl = null;
        embedUrl = fontUrl.toExternalForm();
        long fileLastModified = -1L;
        if (fontCache != null) {
            fileLastModified = FontCache.getLastModified(fontUrl);
            if (fontCache.containsFont(embedUrl)) {
                EmbedFontInfo[] fontInfos = fontCache.getFontInfos(embedUrl, fileLastModified);
                if (fontInfos != null) {
                    return fontInfos;
                }
            } else if (fontCache.isFailedFont(embedUrl, fileLastModified)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Skipping font file that failed to load previously: " + embedUrl);
                }
                return null;
            }
        }
        CustomFont customFont = null;
        if (fontUrl.toExternalForm().endsWith(".ttc")) {
            List ttcNames = null;
            String fontFileURI = fontUrl.toExternalForm().trim();
            InputStream in = null;
            try {
                in = FontLoader.openFontUri(resolver, fontFileURI);
                TTFFile ttf = new TTFFile();
                FontFileReader reader = new FontFileReader(in);
                ttcNames = ttf.getTTCnames(reader);
            }
            catch (Exception e) {
                if (this.eventListener != null) {
                    this.eventListener.fontLoadingErrorAtAutoDetection(this, fontFileURI, e);
                }
                EmbedFontInfo[] reader = null;
                return reader;
            }
            finally {
                IOUtils.closeQuietly(in);
            }
            ArrayList<EmbedFontInfo> embedFontInfoList = new ArrayList<EmbedFontInfo>();
            for (String fontName : ttcNames) {
                EmbedFontInfo fi;
                block25: {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Loading " + fontName);
                    }
                    try {
                        TTFFontLoader ttfLoader = new TTFFontLoader(fontFileURI, fontName, true, EncodingMode.AUTO, true, resolver);
                        customFont = ttfLoader.getFont();
                        if (this.eventListener == null) break block25;
                        customFont.setEventListener(this.eventListener);
                    }
                    catch (Exception e) {
                        if (fontCache != null) {
                            fontCache.registerFailedFont(embedUrl, fileLastModified);
                        }
                        if (this.eventListener == null) continue;
                        this.eventListener.fontLoadingErrorAtAutoDetection(this, embedUrl, e);
                        continue;
                    }
                }
                if ((fi = this.getFontInfoFromCustomFont(fontUrl, customFont, fontCache)) == null) continue;
                embedFontInfoList.add(fi);
            }
            return embedFontInfoList.toArray(new EmbedFontInfo[embedFontInfoList.size()]);
        }
        try {
            customFont = FontLoader.loadFont(fontUrl, null, true, EncodingMode.AUTO, resolver);
            if (this.eventListener != null) {
                customFont.setEventListener(this.eventListener);
            }
        }
        catch (Exception e) {
            if (fontCache != null) {
                fontCache.registerFailedFont(embedUrl, fileLastModified);
            }
            if (this.eventListener != null) {
                this.eventListener.fontLoadingErrorAtAutoDetection(this, embedUrl, e);
            }
            return null;
        }
        EmbedFontInfo fi = this.getFontInfoFromCustomFont(fontUrl, customFont, fontCache);
        if (fi != null) {
            return new EmbedFontInfo[]{fi};
        }
        return null;
    }
}

