/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.run;

import java.lang.reflect.Method;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.run.AbstractRunProperty;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.RPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class RShading
extends AbstractRunProperty {
    protected static Logger log = LoggerFactory.getLogger(RShading.class);
    public static final String CSS_NAME = "background-color";
    public static final String FO_NAME = "background-color";

    public String getCssName() {
        return "background-color";
    }

    public RShading(CTShd shading) {
        this.setObject(shading);
    }

    public RShading(CSSValue value) {
        CTShd shd = Context.getWmlObjectFactory().createCTShd();
        short ignored = 1;
        CSSPrimitiveValue cssPrimitiveValue = (CSSPrimitiveValue)value;
        try {
            float fRed = cssPrimitiveValue.getRGBColorValue().getRed().getFloatValue(ignored);
            float fGreen = cssPrimitiveValue.getRGBColorValue().getGreen().getFloatValue(ignored);
            float fBlue = cssPrimitiveValue.getRGBColorValue().getBlue().getFloatValue(ignored);
            shd.setFill(UnitsOfMeasurement.rgbTripleToHex(fRed, fGreen, fBlue));
        }
        catch (UnsupportedOperationException e) {
            try {
                Class<?> xhtmlImporterClass = Class.forName("org.docx4j.convert.in.xhtml.FSColorToHexString");
                Method rgbToHexMethod = xhtmlImporterClass.getMethod("rgbToHex", CSSPrimitiveValue.class);
                shd.setFill((String)rgbToHexMethod.invoke(null, cssPrimitiveValue));
            }
            catch (Exception e2) {
                log.error("docx4j-XHTMLImport jar not found. Please add this to your classpath.");
                log.error(e2.getMessage(), e2);
                throw e;
            }
        }
        this.setObject(shd);
    }

    public String getCssProperty() {
        CTShd shd = (CTShd)this.getObject();
        if (shd.getColor() != null && !shd.getColor().equals("auto")) {
            log.warn("TODO support w:shd/@w:color=" + shd.getColor());
        }
        if (shd.getFill() != null && !shd.getFill().equals("auto")) {
            return RShading.composeCss("background-color", "#" + shd.getFill());
        }
        return "";
    }

    public void setXslFO(Element foElement) {
        CTShd shd = (CTShd)this.getObject();
        if (shd.getColor() != null && !shd.getColor().equals("auto")) {
            log.warn("TODO support w:shd/@w:color=" + shd.getColor());
        }
        if (shd.getFill() != null && !shd.getFill().equals("auto")) {
            foElement.setAttribute("background-color", "#" + shd.getFill());
        }
    }

    public void set(RPr rPr) {
        rPr.setShd((CTShd)this.getObject());
    }

    public void set(CTTextCharacterProperties rPr) {
    }
}

