/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.util.HashMap;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parts {
    private static Logger log = LoggerFactory.getLogger(Parts.class);
    private HashMap<PartName, Part> parts = new HashMap();

    public void put(Part part) {
        if (this.get(part.getPartName()) != null) {
            log.info("Overwriting existing part " + part.getPartName());
        } else {
            log.debug("put part " + part.getPartName());
        }
        this.parts.put(part.getPartName(), part);
    }

    public Part get(PartName partName) {
        return this.parts.get(partName);
    }

    public HashMap<PartName, Part> getParts() {
        return this.parts;
    }

    public void remove(PartName partName) {
        if (this.get(partName) != null) {
            log.info("Deleting part " + partName);
            this.parts.remove(partName);
        } else {
            log.error("Couldn't delete part " + partName + " - nothing by that name");
        }
    }
}

