/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.PresentationML;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.JaxbPmlPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.docx4j.relationships.Relationship;
import org.pptx4j.jaxb.Context;
import org.pptx4j.model.ResolvedLayout;
import org.pptx4j.model.ShapeWrapper;
import org.pptx4j.pml.CTPlaceholder;
import org.pptx4j.pml.CommonSlideData;
import org.pptx4j.pml.ObjectFactory;
import org.pptx4j.pml.Shape;
import org.pptx4j.pml.SldLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SlideLayoutPart
extends JaxbPmlPart<SldLayout> {
    SlideMasterPart master = null;
    private ResolvedLayout resolvedLayout;
    Map<String, ShapeWrapper> indexedPlaceHolders;
    private static final String VML_DECL = "xmlns:v=\"urn:schemas-microsoft-com:vml\"";

    public SlideLayoutPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public SlideLayoutPart() throws InvalidFormatException {
        super(new PartName("/ppt/slideLayouts/slideLayout1.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideLayout");
    }

    public SlideMasterPart getSlideMasterPart() {
        if (this.master != null) {
            return this.master;
        }
        Relationship masterRel = this.getRelationshipsPart().getRelationshipByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideMaster");
        if (masterRel == null) {
            log.warn(this.getPartName().getName() + " has no master!");
        } else {
            this.master = (SlideMasterPart)this.getRelationshipsPart().getPart(masterRel);
        }
        return this.master;
    }

    public boolean setPartShortcut(Part part) {
        if (part == null) {
            return false;
        }
        return this.setPartShortcut(part, part.getRelationshipType());
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        if (relationshipType == null) {
            log.warn("trying to set part shortcut against a null relationship type.");
            return false;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideMaster")) {
            this.master = (SlideMasterPart)part;
            return true;
        }
        return false;
    }

    public ResolvedLayout getResolvedLayout() {
        if (this.resolvedLayout != null) {
            return this.resolvedLayout;
        }
        this.resolvedLayout = ResolvedLayout.resolveSlideLayout(this);
        return this.resolvedLayout;
    }

    public static SldLayout createSldLayout() throws JAXBException {
        ObjectFactory factory = Context.getpmlObjectFactory();
        SldLayout sldLayout = factory.createSldLayout();
        CommonSlideData cSld = (CommonSlideData)XmlUtils.unmarshalString("<p:cSld  xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"><p:spTree><p:nvGrpSpPr><p:cNvPr id=\"1\" name=\"\"/><p:cNvGrpSpPr/><p:nvPr/></p:nvGrpSpPr><p:grpSpPr><a:xfrm><a:off x=\"0\" y=\"0\"/><a:ext cx=\"0\" cy=\"0\"/><a:chOff x=\"0\" y=\"0\"/><a:chExt cx=\"0\" cy=\"0\"/></a:xfrm></p:grpSpPr></p:spTree></p:cSld>", Context.jcPML, CommonSlideData.class);
        cSld.setName("Title Slide");
        sldLayout.setCSld(cSld);
        return sldLayout;
    }

    public Map<String, ShapeWrapper> getIndexedPlaceHolders() {
        if (this.indexedPlaceHolders == null) {
            this.indexPlaceHolders();
        }
        return this.indexedPlaceHolders;
    }

    private Map<String, ShapeWrapper> indexPlaceHolders() {
        this.indexedPlaceHolders = new HashMap<String, ShapeWrapper>();
        List<Object> possiblyShapes = this.getResolvedLayout().getShapeTree().getSpOrGrpSpOrGraphicFrame();
        for (Object o : possiblyShapes) {
            Shape sp;
            if (!(o instanceof Shape) || (sp = (Shape)o).getNvSpPr() == null || sp.getNvSpPr().getNvPr() == null || sp.getNvSpPr().getNvPr().getPh() == null) continue;
            CTPlaceholder placeholder = sp.getNvSpPr().getNvPr().getPh();
            ShapeWrapper sw = new ShapeWrapper(sp, placeholder.getType().toString(), this);
            this.indexedPlaceHolders.put(sw.getPhType(), sw);
            String name = "";
            if (sp.getNvSpPr().getCNvPr() != null) {
                name = sp.getNvSpPr().getCNvPr().getName();
            }
            log.debug("Indexed: " + sw.getPhType() + "(" + name + ") in " + sw.getOwner().getPartName().toString());
        }
        return this.indexedPlaceHolders;
    }

    @Override
    public void marshal(OutputStream os, Object namespacePrefixMapper) throws JAXBException {
        int closeTagPos;
        int pos;
        String xmlString = XmlUtils.marshaltoString(this.getJaxbElement(), false, true, this.jc);
        if (!xmlString.substring(pos = xmlString.indexOf(":sldLayout "), closeTagPos = xmlString.indexOf(">", pos)).contains(VML_DECL)) {
            xmlString = xmlString.substring(0, pos + 11) + VML_DECL + " " + xmlString.substring(pos + 11);
        }
        try {
            IOUtils.write(xmlString, os, "UTF-8");
        }
        catch (IOException e) {
            throw new JAXBException(e.getMessage(), (Throwable)e);
        }
    }
}

