/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.wml.CTCompat;
import org.docx4j.wml.CTCompatSetting;
import org.docx4j.wml.CTSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentSettingsPart
extends JaxbXmlPartXPathAware<CTSettings> {
    private static final Logger log = LoggerFactory.getLogger(DocumentSettingsPart.class);

    public DocumentSettingsPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public DocumentSettingsPart() throws InvalidFormatException {
        super(new PartName("/word/settings.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/settings");
    }

    @Override
    protected void setMceIgnorable() {
        boolean needW14 = false;
        if (((CTSettings)this.jaxbElement).getDocId14() != null) {
            needW14 = true;
        } else if (((CTSettings)this.jaxbElement).getConflictMode() != null) {
            needW14 = true;
        } else if (((CTSettings)this.jaxbElement).getDiscardImageEditingData() != null) {
            needW14 = true;
        } else if (((CTSettings)this.jaxbElement).getDefaultImageDpi() != null) {
            needW14 = true;
        }
        boolean needW15 = false;
        if (((CTSettings)this.jaxbElement).getChartTrackingRefBased() != null) {
            needW15 = true;
        } else if (((CTSettings)this.jaxbElement).getDocId15() != null) {
            needW15 = true;
        }
        String mceIgnorableVal = "";
        if (needW14) {
            mceIgnorableVal = "w14";
        }
        if (needW15) {
            mceIgnorableVal = mceIgnorableVal + " w15";
        }
        log.warn(mceIgnorableVal);
        ((CTSettings)this.jaxbElement).setIgnorable(mceIgnorableVal);
    }

    public CTCompatSetting getWordCompatSetting(String name) throws Docx4JException {
        CTCompat compat = ((CTSettings)this.getContents()).getCompat();
        if (compat == null) {
            log.warn("No w:settings/w:compat element");
            return null;
        }
        CTCompatSetting theSetting = null;
        for (CTCompatSetting setting : compat.getCompatSetting()) {
            if (!setting.getUri().equals("http://schemas.microsoft.com/office/word") || !setting.getName().equals(name)) continue;
            theSetting = setting;
            break;
        }
        return theSetting;
    }

    public void setWordCompatSetting(String name, String val) throws Docx4JException {
        CTCompat compat = ((CTSettings)this.getContents()).getCompat();
        if (compat == null) {
            log.debug("No w:settings/w:compat element; creating..");
        }
        compat = Context.getWmlObjectFactory().createCTCompat();
        ((CTSettings)this.getContents()).setCompat(compat);
        CTCompatSetting theSetting = null;
        for (CTCompatSetting setting : compat.getCompatSetting()) {
            if (!setting.getUri().equals("http://schemas.microsoft.com/office/word") || !setting.getName().equals(name)) continue;
            theSetting = setting;
            break;
        }
        if (theSetting == null) {
            theSetting = Context.getWmlObjectFactory().createCTCompatSetting();
            theSetting.setUri("http://schemas.microsoft.com/office/word");
            theSetting.setName(name);
            compat.getCompatSetting().add(theSetting);
        }
        theSetting.setVal(val);
    }
}

