/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.sequence;

import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.sequence.PrefixMapping;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public final class EventSequence {
    private final PrefixMapping prefixMapping = new PrefixMapping();
    private final List<DiffXEvent> sequence;

    public EventSequence() {
        this.sequence = new LinkedList<DiffXEvent>();
    }

    public EventSequence(int size) {
        this.sequence = new ArrayList<DiffXEvent>(size);
    }

    public void addSequence(EventSequence seq) {
        for (int i = 0; i < seq.size(); ++i) {
            this.sequence.add(seq.getEvent(i));
        }
    }

    public void addEvent(DiffXEvent e) {
        this.sequence.add(e);
    }

    public void addEvent(int i, DiffXEvent e) {
        this.sequence.add(i, e);
    }

    public DiffXEvent getEvent(int i) {
        return this.sequence.get(i);
    }

    public DiffXEvent setEvent(int index, DiffXEvent e) {
        return this.sequence.set(index, e);
    }

    public DiffXEvent removeEvent(int index) {
        return this.sequence.remove(index);
    }

    public int size() {
        return this.sequence.size();
    }

    public EventIterator eventIterator() {
        return new EventIterator(this.sequence.iterator());
    }

    public List<DiffXEvent> events() {
        return this.sequence;
    }

    public int hashCode() {
        return this.sequence.size();
    }

    public boolean equals(EventSequence seq) {
        if (seq == null) {
            return false;
        }
        if (seq.getClass() != this.getClass()) {
            return false;
        }
        List<DiffXEvent> sequence2 = seq.sequence;
        if (this.sequence.size() != this.sequence.size()) {
            return false;
        }
        DiffXEvent x1 = null;
        DiffXEvent x2 = null;
        for (int i = 0; i < this.sequence.size(); ++i) {
            x1 = this.sequence.get(i);
            if (x1.equals(x2 = sequence2.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof EventSequence)) {
            return false;
        }
        return this.equals((EventSequence)o);
    }

    public String toString() {
        return "Event Sequence [" + this.size() + "]";
    }

    public void export(PrintWriter w) {
        DiffXEvent x = null;
        for (int i = 0; i < this.sequence.size(); ++i) {
            x = this.sequence.get(i);
            w.println(x.toString());
        }
        w.flush();
    }

    public void mapPrefix(String uri, String prefix) throws NullPointerException {
        this.prefixMapping.add(uri, prefix);
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMapping;
    }

    public final class EventIterator
    implements Iterator<DiffXEvent> {
        private final Iterator<DiffXEvent> iterator;

        private EventIterator(Iterator<DiffXEvent> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public DiffXEvent next() {
            return this.iterator.next();
        }

        public DiffXEvent nextEvent() throws NoSuchElementException {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

