/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx;

import java.util.List;
import org.camunda.bpm.dmn.xlsx.CellContentHandler;
import org.camunda.bpm.dmn.xlsx.XlsxWorksheetContext;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetCell;
import org.camunda.bpm.dmn.xlsx.elements.IndexedDmnColumns;

public class DmnConversionContext {
    protected final List<CellContentHandler> cellContentHandlers;
    protected final XlsxWorksheetContext worksheetContext;
    protected IndexedDmnColumns indexedDmnColumns = new IndexedDmnColumns();

    public DmnConversionContext(XlsxWorksheetContext worksheetContext, List<CellContentHandler> cellContentHandlers) {
        this.worksheetContext = worksheetContext;
        this.cellContentHandlers = cellContentHandlers;
    }

    public String resolveCellValue(SpreadsheetCell cell) {
        for (CellContentHandler contentHandler : this.cellContentHandlers) {
            if (!contentHandler.canConvert(cell, this.worksheetContext)) continue;
            return contentHandler.convert(cell, this.worksheetContext);
        }
        throw new RuntimeException("cannot parse cell content, unsupported format");
    }

    public IndexedDmnColumns getIndexedDmnColumns() {
        return this.indexedDmnColumns;
    }
}

