/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx;

import java.util.regex.Pattern;
import org.camunda.bpm.dmn.xlsx.CellContentHandler;
import org.camunda.bpm.dmn.xlsx.api.Spreadsheet;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetCell;
import org.xlsx4j.sml.Cell;
import org.xlsx4j.sml.STCellType;

public class DmnValueRangeConverter
implements CellContentHandler {
    public static final Pattern RANGE_REGEX = Pattern.compile("[\\[\\]](?:[0-9.]+|(?:date and time\\(.+\\)))\\.\\.(?:[0-9.]+|(?:date and time\\(.+\\)))[\\[\\]]");

    @Override
    public boolean canConvert(SpreadsheetCell cell, Spreadsheet context) {
        Cell rawCell = cell.getRaw();
        if (STCellType.S.equals((Object)rawCell.getT())) {
            String content = context.resolveCellContent(cell);
            return RANGE_REGEX.matcher(content).matches();
        }
        return false;
    }

    @Override
    public String convert(SpreadsheetCell cell, Spreadsheet context) {
        return context.resolveCellContent(cell);
    }
}

