/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetCell;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetRow;
import org.camunda.bpm.dmn.xlsx.elements.IndexedCell;
import org.xlsx4j.sml.Cell;
import org.xlsx4j.sml.Row;

public class IndexedRow
implements SpreadsheetRow {
    public static final Pattern CELL_REF_PATTERN = Pattern.compile("([A-Z]+)([0-9]+)");
    protected Row row;
    protected List<SpreadsheetCell> cells;
    protected Map<String, SpreadsheetCell> cellsByColumn;

    public IndexedRow(Row row) {
        this.row = row;
        this.cells = new ArrayList<SpreadsheetCell>();
        this.cellsByColumn = new HashMap<String, SpreadsheetCell>();
        for (Cell cell : row.getC()) {
            IndexedCell indexedCell = new IndexedCell(cell);
            String column = indexedCell.getColumn();
            this.cells.add(indexedCell);
            this.cellsByColumn.put(column, indexedCell);
        }
    }

    protected String extractColumn(Cell cell) {
        String cellReference = cell.getR();
        Matcher matcher = CELL_REF_PATTERN.matcher(cellReference);
        return matcher.group(1);
    }

    @Override
    public Row getRaw() {
        return this.row;
    }

    @Override
    public Collection<String> getColumns() {
        return this.cellsByColumn.keySet();
    }

    @Override
    public SpreadsheetCell getCell(String column) {
        return this.cellsByColumn.get(column);
    }

    @Override
    public boolean hasCells() {
        return !this.cells.isEmpty();
    }

    @Override
    public List<SpreadsheetCell> getCells() {
        return this.cells;
    }
}

