/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.xlsx.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.dmn.xlsx.XlsxConverter;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.persistence.deploy.Deployer;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.xlsx.plugin.XlsxDeploymentMetaData;
import org.yaml.snakeyaml.Yaml;

public class XlsxDeployer
implements Deployer {
    public static final String XLSX_RESOURCE_SUFFIX = "xlsx";

    public void deploy(DeploymentEntity deployment) {
        if (!deployment.isNew()) {
            return;
        }
        ArrayList<ResourceEntity> generatedResources = new ArrayList<ResourceEntity>();
        for (ResourceEntity resource : deployment.getResources().values()) {
            if (!this.canHandle(resource)) continue;
            XlsxDeploymentMetaData metaData = this.loadMetaData(deployment, resource.getName() + ".yaml");
            DmnModelInstance dmnModel = this.generateDmnModel(resource, metaData);
            ResourceEntity dmnResource = this.generateDeploymentResource(deployment, dmnModel, this.generateDmnResourceName(resource));
            generatedResources.add(dmnResource);
        }
        this.addToDeployment(generatedResources, deployment);
    }

    protected ResourceEntity generateDeploymentResource(DeploymentEntity deployment, DmnModelInstance dmnModel, String name) {
        ResourceEntity resource = new ResourceEntity();
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        Dmn.writeModelToStream((OutputStream)byteStream, (DmnModelInstance)dmnModel);
        byte[] bytes = byteStream.toByteArray();
        resource.setName(name);
        resource.setBytes(bytes);
        resource.setDeploymentId(deployment.getId());
        resource.setGenerated(true);
        return resource;
    }

    protected void addToDeployment(List<ResourceEntity> generatedResources, DeploymentEntity deployment) {
        for (ResourceEntity resource : generatedResources) {
            Context.getCommandContext().getResourceManager().insert((DbEntity)resource);
            deployment.addResource(resource);
        }
    }

    protected String generateDmnResourceName(ResourceEntity xlsxResource) {
        return xlsxResource.getName() + ".dmn";
    }

    protected boolean canHandle(ResourceEntity resource) {
        return resource.getName().endsWith(".xlsx");
    }

    protected DmnModelInstance generateDmnModel(ResourceEntity xlsxResource, XlsxDeploymentMetaData metaData) {
        byte[] bytes = xlsxResource.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        XlsxConverter converter = new XlsxConverter();
        if (metaData != null) {
            metaData.applyTo(converter);
        }
        return converter.convert(inputStream);
    }

    protected XlsxDeploymentMetaData loadMetaData(DeploymentEntity deployment, String metaDataResource) {
        ResourceEntity resource = deployment.getResource(metaDataResource);
        if (resource != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getBytes());
            Yaml yaml = new Yaml();
            return yaml.loadAs(inputStream, XlsxDeploymentMetaData.class);
        }
        return null;
    }
}

