/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.util.List;
import javax.xml.transform.TransformerException;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.writer.AbstractFldSimpleWriter;
import org.docx4j.convert.out.common.writer.AbstractPagerefHandler;
import org.docx4j.convert.out.common.writer.RefHandler;
import org.docx4j.convert.out.html.HtmlCssHelper;
import org.docx4j.convert.out.html.HyperlinkWriter;
import org.docx4j.model.fields.FldSimpleModel;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.model.properties.Property;
import org.docx4j.utils.FoNumberFormatUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FldSimpleWriter
extends AbstractFldSimpleWriter {
    public FldSimpleWriter() {
        super(null, "span");
    }

    @Override
    protected void registerHandlers() {
        super.registerHandlers();
        this.registerHandler(new PageHandler());
        this.registerHandler(new NumpagesHandler());
        this.registerHandler(new SectionpagesHandler());
        this.registerHandler(new HyperlinkWriter());
        this.registerHandler(new RefHandler(1));
        this.registerHandler(new PagerefHandler());
    }

    @Override
    protected void applyProperties(List<Property> properties, Node node) {
        HtmlCssHelper.applyAttributes(properties, (Element)node);
    }

    protected static class PagerefHandler
    extends AbstractPagerefHandler {
        protected PagerefHandler() {
            super(1);
        }

        @Override
        protected Node createPageref(AbstractWmlConversionContext context, Document doc, String bookmarkId) {
            Element ret = doc.createElement("span");
            String pageNumberFormat = context.getSections().getCurrentSection().getPageNumberInformation().getNumpagesFormat();
            pageNumberFormat = FormattingSwitchHelper.getFoPageNumberFormat(pageNumberFormat);
            ret.appendChild(doc.createTextNode(FoNumberFormatUtil.format(1, pageNumberFormat)));
            return ret;
        }
    }

    protected static class SectionpagesHandler
    extends AbstractPageHandler {
        protected SectionpagesHandler() {
        }

        @Override
        public String getName() {
            return "SECTIONPAGES";
        }
    }

    protected static class NumpagesHandler
    extends AbstractPageHandler {
        protected NumpagesHandler() {
        }

        @Override
        public String getName() {
            return "NUMPAGES";
        }
    }

    protected static class PageHandler
    extends AbstractPageHandler {
        protected PageHandler() {
        }

        @Override
        public String getName() {
            return "PAGE";
        }
    }

    protected static abstract class AbstractPageHandler
    implements AbstractFldSimpleWriter.FldSimpleStringWriterHandler {
        protected AbstractPageHandler() {
        }

        @Override
        public String toString(AbstractWmlConversionContext context, FldSimpleModel model) throws TransformerException {
            String pageFormat = context.getSections().getCurrentSection().getPageNumberInformation().getPageFormat();
            pageFormat = FormattingSwitchHelper.getFoPageNumberFormat(pageFormat);
            return FoNumberFormatUtil.format(1, pageFormat);
        }
    }
}

