/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.poi.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.events.Namespace;
import org.docx4j.org.apache.poi.util.SAXHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class DocumentHelper {
    private static Logger logger = LoggerFactory.getLogger(DocumentHelper.class);
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final DocumentBuilder documentBuilderSingleton;

    private DocumentHelper() {
    }

    public static synchronized DocumentBuilder newDocumentBuilder() {
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(SAXHelper.IGNORING_ENTITY_RESOLVER);
            return documentBuilder;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("cannot create a DocumentBuilder", e);
        }
    }

    private static void trySetSAXFeature(DocumentBuilderFactory documentBuilderFactory, String feature, boolean enabled) {
        try {
            documentBuilderFactory.setFeature(feature, enabled);
        }
        catch (Exception e) {
            logger.warn("SAX Feature unsupported " + feature, e);
        }
        catch (AbstractMethodError ame) {
            logger.warn("Cannot set SAX feature because outdated XML parser in classpath " + feature, ame);
        }
    }

    private static void trySetXercesSecurityManager(DocumentBuilderFactory documentBuilderFactory) {
        for (String securityManagerClassName : new String[]{"com.sun.org.apache.xerces.internal.util.SecurityManager", "org.apache.xerces.util.SecurityManager"}) {
            try {
                Object mgr = Class.forName(securityManagerClassName).newInstance();
                Method setLimit = mgr.getClass().getMethod("setEntityExpansionLimit", Integer.TYPE);
                setLimit.invoke(mgr, 4096);
                documentBuilderFactory.setAttribute("http://apache.org/xml/properties/security-manager", mgr);
                return;
            }
            catch (Throwable t) {
                logger.warn("SAX Security Manager could not be setup", t);
            }
        }
    }

    public static Document readDocument(InputStream inp) throws IOException, SAXException {
        return DocumentHelper.newDocumentBuilder().parse(inp);
    }

    public static synchronized Document createDocument() {
        return documentBuilderSingleton.newDocument();
    }

    public static void addNamespaceDeclaration(Element element, String namespacePrefix, String namespaceURI) {
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + namespacePrefix, namespaceURI);
    }

    public static void addNamespaceDeclaration(Element element, Namespace namespace) {
        DocumentHelper.addNamespaceDeclaration(element, namespace.getPrefix(), namespace.getNamespaceURI());
    }

    static {
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        DocumentHelper.trySetSAXFeature(documentBuilderFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentHelper.trySetXercesSecurityManager(documentBuilderFactory);
        documentBuilderSingleton = DocumentHelper.newDocumentBuilder();
    }
}

