/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TocPageNumbersHandler
extends DefaultHandler {
    private static Logger log = LoggerFactory.getLogger(TocPageNumbersHandler.class);
    private static final String L_BRACKET_P = "\\(P";
    private static final String R_BRACKET = ")";
    private static final String COMMA = ",";
    private static final String INTERNAL_LINK = "internal-link";
    private static final String INLINE_PARENT = "inlineparent";
    private Map<String, Integer> pageNumbers;

    @Override
    public void startDocument() throws SAXException {
        this.pageNumbers = new HashMap<String, Integer>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(INLINE_PARENT)) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String aQName = attributes.getQName(i);
                if (!aQName.equals(INTERNAL_LINK)) continue;
                this.parseValue(attributes.getValue(i));
            }
        }
    }

    private void parseValue(String value) {
        String[] split = value.split(COMMA);
        String pageRef = split[1].replace(R_BRACKET, "");
        int pageNumber = 1;
        try {
            pageNumber = Integer.parseInt(split[0].replaceAll(L_BRACKET_P, ""));
        }
        catch (NumberFormatException ex) {
            log.info("Invalid page number: " + value, ex);
        }
        this.pageNumbers.put(pageRef, pageNumber);
    }

    public Map<String, Integer> getPageNumbers() {
        return this.pageNumbers;
    }
}

